/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.cache.AutoSavingKeyCache;
import org.apache.cassandra.cache.AutoSavingRowCache;
import org.apache.cassandra.cache.ConcurrentLinkedHashCache;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.BinaryMemtable;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IFlushable;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.MeteredFlusher;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowIterator;
import org.apache.cassandra.db.RowIteratorFactory;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.db.filter.IFilter;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.LocalByPartionerType;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ByteOrderedPartitioner;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.dht.OrderPreservingPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexOperator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.DefaultDouble;
import org.apache.cassandra.utils.DefaultInteger;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamilyStore
implements ColumnFamilyStoreMBean {
    private static Logger logger = LoggerFactory.getLogger(ColumnFamilyStore.class);
    private static final ExecutorService flushSorter = new JMXEnabledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Runtime.getRuntime().availableProcessors()), new NamedThreadFactory("FlushSorter"), "internal");
    private static final ExecutorService flushWriter = new JMXEnabledThreadPoolExecutor(DatabaseDescriptor.getFlushWriters(), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(DatabaseDescriptor.getFlushQueueSize()), new NamedThreadFactory("FlushWriter"), "internal");
    public static final ExecutorService postFlushExecutor = new JMXEnabledThreadPoolExecutor("MemtablePostFlusher");
    public final Table table;
    public final String columnFamily;
    public final CFMetaData metadata;
    public final IPartitioner partitioner;
    private final String mbeanName;
    private boolean invalid = false;
    private final DataTracker data;
    private volatile int memtableSwitchCount = 0;
    private AtomicInteger fileIndexGenerator = new AtomicInteger(0);
    private final ConcurrentSkipListMap<ByteBuffer, ColumnFamilyStore> indexedColumns;
    private AtomicReference<BinaryMemtable> binaryMemtable;
    private LatencyTracker readStats = new LatencyTracker();
    private LatencyTracker writeStats = new LatencyTracker();
    private final EstimatedHistogram recentSSTablesPerRead = new EstimatedHistogram(35);
    private final EstimatedHistogram sstablesPerRead = new EstimatedHistogram(35);
    private static final int INTERN_CUTOFF = 256;
    public final ConcurrentMap<ByteBuffer, ByteBuffer> internedNames = new NonBlockingHashMap();
    private volatile DefaultInteger minCompactionThreshold;
    private volatile DefaultInteger maxCompactionThreshold;
    private volatile DefaultInteger memtime;
    private volatile DefaultInteger memsize;
    private volatile DefaultDouble memops;
    private volatile DefaultInteger rowCacheSaveInSeconds;
    private volatile DefaultInteger keyCacheSaveInSeconds;
    public final Lock flushLock = new ReentrantLock();
    public final AutoSavingCache<Pair<Descriptor, DecoratedKey>, Long> keyCache;
    public final AutoSavingCache<DecoratedKey, ColumnFamily> rowCache;
    volatile double liveRatio = 1.0;
    private final AtomicLong liveRatioComputedAt = new AtomicLong(32L);

    public void reload() {
        if (!this.minCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.minCompactionThreshold = new DefaultInteger(this.metadata.getMinCompactionThreshold());
            }
        }
        if (!this.maxCompactionThreshold.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.maxCompactionThreshold = new DefaultInteger(this.metadata.getMaxCompactionThreshold());
            }
        }
        if (!this.memtime.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.memtime = new DefaultInteger(this.metadata.getMemtableFlushAfterMins());
            }
        }
        if (!this.memsize.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.memsize = new DefaultInteger(this.metadata.getMemtableThroughputInMb());
            }
        }
        if (!this.memops.isModified()) {
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                cfs.memops = new DefaultDouble(this.metadata.getMemtableOperationsInMillions());
            }
        }
        if (!this.rowCacheSaveInSeconds.isModified()) {
            this.rowCacheSaveInSeconds = new DefaultInteger(this.metadata.getRowCacheSavePeriodInSeconds());
        }
        if (!this.keyCacheSaveInSeconds.isModified()) {
            this.keyCacheSaveInSeconds = new DefaultInteger(this.metadata.getKeyCacheSavePeriodInSeconds());
        }
        this.updateCacheSizes();
        this.scheduleCacheSaving(this.rowCacheSaveInSeconds.value(), this.keyCacheSaveInSeconds.value());
        for (ByteBuffer indexedColumn : this.indexedColumns.keySet()) {
            if (this.metadata.getColumn_metadata().containsKey(indexedColumn)) continue;
            this.removeIndex(indexedColumn);
        }
        for (ColumnDefinition cdef : this.metadata.getColumn_metadata().values()) {
            if (cdef.getIndexType() == null || this.indexedColumns.containsKey(cdef.name)) continue;
            this.addIndex(cdef);
        }
    }

    void removeIndex(ByteBuffer indexedColumn) {
        ColumnFamilyStore indexCfs = this.indexedColumns.remove(indexedColumn);
        if (indexCfs == null) {
            logger.debug("index {} already removed; ignoring", (Object)ByteBufferUtil.bytesToHex(indexedColumn));
            return;
        }
        indexCfs.unregisterMBean();
        SystemTable.setIndexRemoved(this.metadata.ksName, indexCfs.columnFamily);
        indexCfs.removeAllSSTables();
    }

    private ColumnFamilyStore(Table table, String columnFamilyName, IPartitioner partitioner, int generation, CFMetaData metadata) {
        assert (metadata != null) : "null metadata for " + table + ":" + columnFamilyName;
        this.table = table;
        this.columnFamily = columnFamilyName;
        this.metadata = metadata;
        this.minCompactionThreshold = new DefaultInteger(metadata.getMinCompactionThreshold());
        this.maxCompactionThreshold = new DefaultInteger(metadata.getMaxCompactionThreshold());
        this.memtime = new DefaultInteger(metadata.getMemtableFlushAfterMins());
        this.memsize = new DefaultInteger(metadata.getMemtableThroughputInMb());
        this.memops = new DefaultDouble(metadata.getMemtableOperationsInMillions());
        this.rowCacheSaveInSeconds = new DefaultInteger(metadata.getRowCacheSavePeriodInSeconds());
        this.keyCacheSaveInSeconds = new DefaultInteger(metadata.getKeyCacheSavePeriodInSeconds());
        this.partitioner = partitioner;
        this.fileIndexGenerator.set(generation);
        this.binaryMemtable = new AtomicReference<BinaryMemtable>(new BinaryMemtable(this));
        if (logger.isDebugEnabled()) {
            logger.debug("Starting CFS {}", (Object)this.columnFamily);
        }
        ConcurrentLinkedHashCache kc = ConcurrentLinkedHashCache.create(0);
        this.keyCache = new AutoSavingKeyCache<Pair<Descriptor, DecoratedKey>, Long>(kc, table.name, columnFamilyName);
        ICache<DecoratedKey, ColumnFamily> rc = metadata.getRowCacheProvider().create(0);
        this.rowCache = new AutoSavingRowCache<DecoratedKey, ColumnFamily>(rc, table.name, columnFamilyName);
        this.data = new DataTracker(this);
        Set<DecoratedKey> savedKeys = this.keyCache.readSaved();
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>();
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : ColumnFamilyStore.files(table.name, columnFamilyName, false).entrySet()) {
            SSTableReader sstable;
            try {
                sstable = SSTableReader.open(sstableFiles.getKey(), sstableFiles.getValue(), savedKeys, this.data, metadata, this.partitioner);
            }
            catch (FileNotFoundException ex) {
                logger.error("Missing sstable component in " + sstableFiles + "; skipped because of " + ex.getMessage());
                continue;
            }
            catch (IOException ex) {
                logger.error("Corrupt sstable " + sstableFiles + "; skipped", (Throwable)ex);
                continue;
            }
            sstables.add(sstable);
        }
        this.data.addSSTables(sstables);
        this.indexedColumns = new ConcurrentSkipListMap(this.getComparator());
        for (ColumnDefinition info : metadata.getColumn_metadata().values()) {
            if (info.getIndexType() == null) continue;
            this.addIndex(info);
        }
        String type = this.partitioner instanceof LocalPartitioner ? "IndexColumnFamilies" : "ColumnFamilies";
        this.mbeanName = "org.apache.cassandra.db:type=" + type + ",keyspace=" + this.table.name + ",columnfamily=" + this.columnFamily;
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nameObj = new ObjectName(this.mbeanName);
            mbs.registerMBean(this, nameObj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Future<?> addIndex(final ColumnDefinition info) {
        assert (info.getIndexType() != null);
        IPartitioner rowPartitioner = StorageService.getPartitioner();
        BytesType columnComparator = rowPartitioner instanceof OrderPreservingPartitioner || rowPartitioner instanceof ByteOrderedPartitioner ? BytesType.instance : new LocalByPartionerType(StorageService.getPartitioner());
        final CFMetaData indexedCfMetadata = CFMetaData.newIndexMetadata(this.metadata, info, columnComparator);
        ColumnFamilyStore indexedCfs = ColumnFamilyStore.createColumnFamilyStore(this.table, indexedCfMetadata.cfName, new LocalPartitioner(this.metadata.getColumn_metadata().get(info.name).getValidator()), indexedCfMetadata);
        if (this.indexedColumns.putIfAbsent(info.name, indexedCfs) != null) {
            return null;
        }
        if (indexedCfs.isIndexBuilt()) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnFamilyStore.this.forceBlockingFlush();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                ColumnFamilyStore.this.buildSecondaryIndexes(ColumnFamilyStore.this.getSSTables(), FBUtilities.singleton(info.name));
                SystemTable.setIndexBuilt(ColumnFamilyStore.this.table.name, indexedCfMetadata.cfName);
            }
        };
        FutureTask<Object> f = new FutureTask<Object>(runnable, null);
        new Thread(f, "Create index " + indexedCfMetadata.cfName).start();
        return f;
    }

    public void buildSecondaryIndexes(Collection<SSTableReader> sstables, SortedSet<ByteBuffer> columns) {
        logger.info(String.format("Submitting index build of %s for data in %s", this.metadata.comparator.getString(columns), StringUtils.join(sstables, (String)", ")));
        Table.IndexBuilder builder = this.table.createIndexBuilder(this, columns, new ReducingKeyIterator(sstables));
        Future future = CompactionManager.instance.submitIndexBuild(this, builder);
        try {
            future.get();
            for (ByteBuffer column : columns) {
                this.getIndexedColumnFamilyStore(column).forceBlockingFlush();
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        logger.info("Index build of " + this.metadata.comparator.getString(columns) + " complete");
    }

    void unregisterMBean() {
        try {
            this.invalid = true;
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName nameObj = new ObjectName(this.mbeanName);
            if (mbs.isRegistered(nameObj)) {
                mbs.unregisterMBean(nameObj);
            }
            for (ColumnFamilyStore index : this.indexedColumns.values()) {
                index.unregisterMBean();
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public long getMinRowSize() {
        return this.data.getMinRowSize();
    }

    @Override
    public long getMaxRowSize() {
        return this.data.getMaxRowSize();
    }

    @Override
    public long getMeanRowSize() {
        return this.data.getMeanRowSize();
    }

    public int getMeanColumns() {
        return this.data.getMeanColumns();
    }

    public static ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily) {
        return ColumnFamilyStore.createColumnFamilyStore(table, columnFamily, StorageService.getPartitioner(), DatabaseDescriptor.getCFMetaData(table.name, columnFamily));
    }

    public static synchronized ColumnFamilyStore createColumnFamilyStore(Table table, String columnFamily, IPartitioner partitioner, CFMetaData metadata) {
        ArrayList<Integer> generations = new ArrayList<Integer>();
        for (Descriptor desc : ColumnFamilyStore.files(table.name, columnFamily, true).keySet()) {
            generations.add(desc.generation);
            if (!desc.isFromTheFuture()) continue;
            throw new RuntimeException(String.format("Can't open sstables from the future! Current version %s, found file: %s", "f", desc));
        }
        Collections.sort(generations);
        int value = generations.size() > 0 ? (Integer)generations.get(generations.size() - 1) : 0;
        return new ColumnFamilyStore(table, columnFamily, partitioner, value, metadata);
    }

    public static void scrubDataDirectories(String table, String columnFamily) {
        CFMetaData cfm;
        for (Map.Entry<Descriptor, Set<Component>> sstableFiles : ColumnFamilyStore.files(table, columnFamily, true).entrySet()) {
            Descriptor desc = sstableFiles.getKey();
            Set<Component> components = sstableFiles.getValue();
            if (components.contains(Component.COMPACTED_MARKER) || desc.temporary) {
                SSTable.delete(desc, components);
                continue;
            }
            File dataFile = new File(desc.filenameFor(Component.DATA));
            if (components.contains(Component.DATA) && dataFile.length() > 0L) continue;
            logger.warn("Removing orphans for {}: {}", (Object)desc, components);
            for (Component component : components) {
                try {
                    FileUtils.deleteWithConfirm(desc.filenameFor(component));
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
        Pattern tmpCacheFilePattern = Pattern.compile(table + "-" + columnFamily + "-(Key|Row)Cache.*\\.tmp$");
        File dir = new File(DatabaseDescriptor.getSavedCachesLocation());
        if (dir.exists()) {
            assert (dir.isDirectory());
            for (File file : dir.listFiles()) {
                if (!tmpCacheFilePattern.matcher(file.getName()).matches() || file.delete()) continue;
                logger.warn("could not delete " + file.getAbsolutePath());
            }
        }
        if ((cfm = DatabaseDescriptor.getCFMetaData(table, columnFamily)) != null) {
            for (ColumnDefinition def : cfm.getColumn_metadata().values()) {
                ColumnFamilyStore.scrubDataDirectories(table, CFMetaData.indexName(cfm.cfName, def));
            }
        }
    }

    public void initCaches() {
        long start = System.currentTimeMillis();
        for (DecoratedKey key : this.rowCache.readSaved()) {
            this.cacheRow(key);
        }
        if (this.rowCache.size() > 0) {
            logger.info(String.format("completed loading (%d ms; %d keys) row cache for %s.%s", System.currentTimeMillis() - start, this.rowCache.size(), this.table.name, this.columnFamily));
        }
        this.scheduleCacheSaving(this.metadata.getRowCacheSavePeriodInSeconds(), this.metadata.getKeyCacheSavePeriodInSeconds());
    }

    public void scheduleCacheSaving(int rowCacheSavePeriodInSeconds, int keyCacheSavePeriodInSeconds) {
        this.keyCache.scheduleSaving(keyCacheSavePeriodInSeconds);
        this.rowCache.scheduleSaving(rowCacheSavePeriodInSeconds);
    }

    public AutoSavingCache<Pair<Descriptor, DecoratedKey>, Long> getKeyCache() {
        return this.keyCache;
    }

    private static Map<Descriptor, Set<Component>> files(String keyspace, final String columnFamily, final boolean includeCompacted) {
        final HashMap<Descriptor, Set<Component>> sstables = new HashMap<Descriptor, Set<Component>>();
        for (String directory : DatabaseDescriptor.getAllDataFileLocationsForTable(keyspace)) {
            new File(directory).list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    Pair<Descriptor, Component> component = SSTable.tryComponentFromFilename(dir, name);
                    if (component != null && ((Descriptor)component.left).cfname.equals(columnFamily)) {
                        if (includeCompacted || !new File(((Descriptor)component.left).filenameFor(Component.COMPACTED_MARKER)).exists()) {
                            HashSet components = (HashSet)sstables.get(component.left);
                            if (components == null) {
                                components = new HashSet();
                                sstables.put(component.left, components);
                            }
                            components.add(component.right);
                        } else {
                            logger.debug("not including compacted sstable " + ((Descriptor)component.left).cfname + "-" + ((Descriptor)component.left).generation);
                        }
                    }
                    return false;
                }
            });
        }
        return sstables;
    }

    @Override
    public String getColumnFamilyName() {
        return this.columnFamily;
    }

    public String getFlushPath(long estimatedSize, String version) {
        String location = this.table.getDataFileLocation(estimatedSize);
        if (location == null) {
            throw new RuntimeException("Insufficient disk space to flush " + estimatedSize + " bytes");
        }
        return this.getTempSSTablePath(location, version);
    }

    public String getTempSSTablePath(String directory, String version) {
        Descriptor desc = new Descriptor(version, new File(directory), this.table.name, this.columnFamily, this.fileIndexGenerator.incrementAndGet(), true);
        return desc.filenameFor(Component.DATA);
    }

    public String getTempSSTablePath(String directory) {
        return this.getTempSSTablePath(directory, "f");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<?> maybeSwitchMemtable(Memtable oldMemtable, final boolean writeCommitLog) {
        if (oldMemtable.isFrozen()) {
            logger.debug("memtable is already frozen; another thread must be flushing it");
            return null;
        }
        Table.switchLock.writeLock().lock();
        try {
            if (oldMemtable.isFrozen()) {
                logger.debug("memtable is already frozen; another thread must be flushing it");
                Future<?> future = null;
                return future;
            }
            assert (this.getMemtableThreadSafe() == oldMemtable);
            oldMemtable.freeze();
            final CommitLogSegment.CommitLogContext ctx = writeCommitLog ? CommitLog.instance.getContext() : null;
            ArrayList<ColumnFamilyStore> icc = new ArrayList<ColumnFamilyStore>(this.indexedColumns.size());
            for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
                if (cfs.getMemtableThreadSafe().isClean()) continue;
                icc.add(cfs);
            }
            final CountDownLatch latch = new CountDownLatch(icc.size());
            for (ColumnFamilyStore cfs : icc) {
                this.submitFlush(cfs.data.switchMemtable(), latch);
            }
            if (!icc.contains(this)) {
                this.data.renewMemtable();
            }
            if (this.memtableSwitchCount == Integer.MAX_VALUE) {
                this.memtableSwitchCount = 0;
            }
            ++this.memtableSwitchCount;
            Future<?> future = postFlushExecutor.submit(new WrappedRunnable(){

                @Override
                public void runMayThrow() throws InterruptedException, IOException {
                    latch.await();
                    if (writeCommitLog) {
                        CommitLog.instance.discardCompletedSegments(ColumnFamilyStore.this.metadata.cfId, ctx);
                    }
                }
            });
            return future;
        }
        finally {
            Table.switchLock.writeLock().unlock();
        }
    }

    public boolean isDropped() {
        return this.isIndex() ? DatabaseDescriptor.getCFMetaData(this.table.name, this.getParentColumnfamily()) == null : DatabaseDescriptor.getCFMetaData(this.metadata.cfId) == null;
    }

    void switchBinaryMemtable(DecoratedKey key, ByteBuffer buffer) {
        this.binaryMemtable.set(new BinaryMemtable(this));
        this.binaryMemtable.get().put(key, buffer);
    }

    public void forceFlushIfExpired() {
        if (this.getMemtableThreadSafe().isExpired()) {
            this.forceFlush();
        }
    }

    @Override
    public Future<?> forceFlush() {
        boolean clean = true;
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            clean &= cfs.getMemtableThreadSafe().isClean();
        }
        if (clean) {
            logger.debug("forceFlush requested but everything is clean");
            return null;
        }
        return this.maybeSwitchMemtable(this.getMemtableThreadSafe(), true);
    }

    public void forceBlockingFlush() throws ExecutionException, InterruptedException {
        Object future = this.forceFlush();
        if (future != null) {
            future.get();
        }
    }

    public void forceFlushBinary() {
        if (this.binaryMemtable.get().isClean()) {
            return;
        }
        this.submitFlush(this.binaryMemtable.get(), new CountDownLatch(1));
    }

    public void updateRowCache(DecoratedKey key, ColumnFamily columnFamily) {
        if (this.rowCache.isPutCopying()) {
            this.invalidateCachedRow(key);
        } else {
            ColumnFamily cachedRow = this.getRawCachedRow(key);
            if (cachedRow != null) {
                cachedRow.addAll(columnFamily);
            }
        }
    }

    Memtable apply(DecoratedKey key, ColumnFamily columnFamily) {
        long start = System.nanoTime();
        Memtable mt = this.getMemtableThreadSafe();
        boolean flushRequested = mt.isThresholdViolated();
        mt.put(key, columnFamily);
        this.updateRowCache(key, columnFamily);
        this.writeStats.addNano(System.nanoTime() - start);
        if (DatabaseDescriptor.estimatesRealMemtableSize()) {
            while (true) {
                long last = this.liveRatioComputedAt.get();
                long operations = this.writeStats.getOpCount();
                if (operations < 2L * last) break;
                if (!this.liveRatioComputedAt.compareAndSet(last, operations)) continue;
                logger.debug("computing liveRatio of {} at {} ops", (Object)this, (Object)operations);
                mt.updateLiveRatio();
            }
        }
        return flushRequested ? mt : null;
    }

    void applyBinary(DecoratedKey key, ByteBuffer buffer) {
        long start = System.nanoTime();
        this.binaryMemtable.get().put(key, buffer);
        this.writeStats.addNano(System.nanoTime() - start);
    }

    public static ColumnFamily removeDeletedCF(ColumnFamily cf, int gcBefore) {
        if (cf.getColumnCount() == 0 && cf.getLocalDeletionTime() <= gcBefore) {
            return null;
        }
        return cf;
    }

    public static ColumnFamily removeDeleted(ColumnFamily cf, int gcBefore) {
        if (cf == null) {
            return null;
        }
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, gcBefore);
        return ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    private static void removeDeletedColumnsOnly(ColumnFamily cf, int gcBefore) {
        if (cf.isSuper()) {
            ColumnFamilyStore.removeDeletedSuper(cf, gcBefore);
        } else {
            ColumnFamilyStore.removeDeletedStandard(cf, gcBefore);
        }
    }

    private static void removeDeletedStandard(ColumnFamily cf, int gcBefore) {
        for (Map.Entry<ByteBuffer, IColumn> entry : cf.getColumnsMap().entrySet()) {
            ByteBuffer cname = entry.getKey();
            IColumn c = entry.getValue();
            if ((!c.isMarkedForDelete() || c.getLocalDeletionTime() > gcBefore) && c.timestamp() > cf.getMarkedForDeleteAt()) continue;
            cf.remove(cname);
        }
    }

    private static void removeDeletedSuper(ColumnFamily cf, int gcBefore) {
        for (Map.Entry<ByteBuffer, IColumn> entry : cf.getColumnsMap().entrySet()) {
            SuperColumn c = (SuperColumn)entry.getValue();
            long minTimestamp = Math.max(c.getMarkedForDeleteAt(), cf.getMarkedForDeleteAt());
            for (IColumn subColumn : c.getSubColumns()) {
                if (subColumn.timestamp() > minTimestamp && (!subColumn.isMarkedForDelete() || subColumn.getLocalDeletionTime() > gcBefore)) continue;
                c.remove(subColumn.name());
            }
            if (!c.getSubColumns().isEmpty() || c.getLocalDeletionTime() > gcBefore) continue;
            cf.remove(c.name());
        }
    }

    public boolean isKeyInRemainingSSTables(DecoratedKey key, Set<? extends SSTable> sstablesToIgnore) {
        for (SSTableReader sstable : this.data.getSSTables()) {
            if (sstablesToIgnore.contains(sstable) || !sstable.getBloomFilter().isPresent(key.key)) continue;
            return true;
        }
        return false;
    }

    public void addSSTable(SSTableReader sstable) {
        assert (sstable.getColumnFamilyName().equals(this.columnFamily));
        this.data.addStreamedSSTable(sstable);
        CompactionManager.instance.submitMinorIfNeeded(this);
    }

    long getExpectedCompactedFileSize(Iterable<SSTableReader> sstables) {
        long expectedFileSize = 0L;
        for (SSTableReader sstable : sstables) {
            long size = sstable.length();
            expectedFileSize += size;
        }
        return expectedFileSize;
    }

    SSTableReader getMaxSizeFile(Iterable<SSTableReader> sstables) {
        long maxSize = 0L;
        SSTableReader maxFile = null;
        for (SSTableReader sstable : sstables) {
            if (sstable.length() <= maxSize) continue;
            maxSize = sstable.length();
            maxFile = sstable;
        }
        return maxFile;
    }

    public void forceCleanup(NodeId.OneShotRenewer renewer) throws ExecutionException, InterruptedException {
        CompactionManager.instance.performCleanup(this, renewer);
    }

    public void scrub() throws ExecutionException, InterruptedException {
        this.snapshotWithoutFlush("pre-scrub-" + System.currentTimeMillis());
        CompactionManager.instance.performScrub(this);
    }

    void markCompacted(Collection<SSTableReader> sstables) {
        this.data.markCompacted(sstables);
    }

    boolean isCompleteSSTables(Collection<SSTableReader> sstables) {
        return ((Object)this.data.getSSTables()).equals(new HashSet<SSTableReader>(sstables));
    }

    void replaceCompactedSSTables(Collection<SSTableReader> sstables, Iterable<SSTableReader> replacements) {
        this.data.replaceCompactedSSTables(sstables, replacements);
    }

    void replaceFlushed(Memtable memtable, SSTableReader sstable) {
        this.data.replaceFlushed(memtable, sstable);
        CompactionManager.instance.submitMinorIfNeeded(this);
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void removeAllSSTables() {
        this.data.removeAllSSTables();
        for (ColumnFamilyStore indexedCfs : this.indexedColumns.values()) {
            indexedCfs.removeAllSSTables();
        }
    }

    void submitFlush(IFlushable flushable, CountDownLatch latch) {
        logger.info("Enqueuing flush of {}", (Object)flushable);
        flushable.flushAndSignal(latch, flushSorter, flushWriter);
    }

    @Override
    public long getMemtableColumnsCount() {
        return this.getMemtableThreadSafe().getOperations();
    }

    @Override
    public long getMemtableDataSize() {
        return this.getMemtableThreadSafe().getLiveSize();
    }

    public long getTotalMemtableLiveSize() {
        long total = 0L;
        for (ColumnFamilyStore cfs : this.concatWithIndexes()) {
            total += cfs.getMemtableThreadSafe().getLiveSize();
        }
        return total;
    }

    @Override
    public int getMemtableSwitchCount() {
        return this.memtableSwitchCount;
    }

    private Memtable getMemtableThreadSafe() {
        return this.data.getMemtable();
    }

    DataTracker getDataTracker() {
        return this.data;
    }

    public Collection<SSTableReader> getSSTables() {
        return this.data.getSSTables();
    }

    @Override
    public long[] getRecentSSTablesPerReadHistogram() {
        return this.recentSSTablesPerRead.getBuckets(true);
    }

    @Override
    public long[] getSSTablesPerReadHistogram() {
        return this.sstablesPerRead.getBuckets(false);
    }

    @Override
    public long getReadCount() {
        return this.readStats.getOpCount();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return this.readStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getLifetimeReadLatencyHistogramMicros() {
        return this.readStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return this.readStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return this.readStats.getTotalLatencyMicros();
    }

    @Override
    public int getPendingTasks() {
        return Table.switchLock.getQueueLength();
    }

    @Override
    public long getWriteCount() {
        return this.writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return this.writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return this.writeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getLifetimeWriteLatencyHistogramMicros() {
        return this.writeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return this.writeStats.getRecentLatencyHistogramMicros();
    }

    public ColumnFamily getColumnFamily(DecoratedKey key, QueryPath path, ByteBuffer start, ByteBuffer finish, boolean reversed, int limit) {
        return this.getColumnFamily(QueryFilter.getSliceFilter(key, path, start, finish, reversed, limit));
    }

    public ColumnFamily getColumnFamily(QueryFilter filter) {
        return this.getColumnFamily(filter, this.gcBefore());
    }

    public int gcBefore() {
        return (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
    }

    private ColumnFamily cacheRow(DecoratedKey key) {
        ColumnFamily cached = (ColumnFamily)this.rowCache.get(key);
        if (cached == null) {
            cached = this.getTopLevelColumns(QueryFilter.getIdentityFilter(key, new QueryPath(this.columnFamily)), Integer.MIN_VALUE);
            if (cached == null) {
                return null;
            }
            if (!this.rowCache.isPutCopying()) {
                for (IColumn column : cached.getSortedColumns()) {
                    cached.remove(column.name());
                    cached.addColumn(column.localCopy(this));
                }
            }
            this.rowCache.put(new DecoratedKey(key.token, ByteBufferUtil.clone(key.key)), cached);
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily getColumnFamily(QueryFilter filter, int gcBefore) {
        assert (this.columnFamily.equals(filter.getColumnFamilyName())) : filter.getColumnFamilyName();
        long start = System.nanoTime();
        try {
            if (this.rowCache.getCapacity() == 0) {
                ColumnFamily cf = this.getTopLevelColumns(filter, gcBefore);
                ColumnFamily columnFamily = cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
                return columnFamily;
            }
            ColumnFamily cached = this.cacheRow(filter.key);
            if (cached == null) {
                ColumnFamily columnFamily = null;
                return columnFamily;
            }
            ColumnFamily columnFamily = this.filterColumnFamily(cached, filter, gcBefore);
            return columnFamily;
        }
        finally {
            this.readStats.addNano(System.nanoTime() - start);
        }
    }

    ColumnFamily filterColumnFamily(ColumnFamily cached, QueryFilter filter, int gcBefore) {
        if (filter.filter instanceof SliceQueryFilter) {
            SliceQueryFilter sliceFilter = (SliceQueryFilter)filter.filter;
            if (sliceFilter.start.remaining() == 0 && sliceFilter.finish.remaining() == 0) {
                if (cached.isSuper() && filter.path.superColumnName != null) {
                    IColumn sc = cached.getColumn(filter.path.superColumnName);
                    if (sc == null || sliceFilter.count >= sc.getSubColumns().size()) {
                        ColumnFamily cf = cached.cloneMeShallow();
                        if (sc != null) {
                            cf.addColumn(sc);
                        }
                        return ColumnFamilyStore.removeDeleted(cf, gcBefore);
                    }
                } else if (sliceFilter.count >= cached.getColumnCount()) {
                    ColumnFamilyStore.removeDeletedColumnsOnly(cached, gcBefore);
                    return ColumnFamilyStore.removeDeletedCF(cached, gcBefore);
                }
            }
        }
        IColumnIterator ci = filter.getMemtableColumnIterator(cached, null, this.getComparator());
        ColumnFamily cf = ci.getColumnFamily().cloneMeShallow();
        filter.collectCollatedColumns(cf, ci, gcBefore);
        return cf.isSuper() ? ColumnFamilyStore.removeDeleted(cf, gcBefore) : ColumnFamilyStore.removeDeletedCF(cf, gcBefore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnFamily getTopLevelColumns(QueryFilter filter, int gcBefore) {
        ArrayList<IColumnIterator> iterators = new ArrayList<IColumnIterator>();
        ColumnFamily returnCF = ColumnFamily.create(this.metadata);
        try {
            int sstablesToIterate = 0;
            DataTracker.View currentView = this.data.getView();
            IColumnIterator iter = filter.getMemtableColumnIterator(currentView.memtable, this.getComparator());
            if (iter != null) {
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
            }
            for (Memtable memtable : currentView.memtablesPendingFlush) {
                iter = filter.getMemtableColumnIterator(memtable, this.getComparator());
                if (iter == null) continue;
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
            }
            for (SSTableReader sstable : currentView.sstables) {
                iter = filter.getSSTableColumnIterator(sstable);
                if (iter.getColumnFamily() == null) continue;
                returnCF.delete(iter.getColumnFamily());
                iterators.add(iter);
                ++sstablesToIterate;
            }
            this.recentSSTablesPerRead.add(sstablesToIterate);
            this.sstablesPerRead.add(sstablesToIterate);
            Comparator<IColumn> comparator = filter.filter.getColumnComparator(this.getComparator());
            Iterator collated = IteratorUtils.collatedIterator(comparator, iterators);
            filter.collectCollatedColumns(returnCF, collated, gcBefore);
            ColumnFamily columnFamily = returnCF;
            return columnFamily;
        }
        finally {
            for (IColumnIterator ci : iterators) {
                try {
                    ci.close();
                }
                catch (Throwable th) {
                    logger.error("error closing " + ci, th);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> getRangeSlice(ByteBuffer superColumn, AbstractBounds range, int maxResults, IFilter columnFilter) throws ExecutionException, InterruptedException {
        assert (range instanceof Bounds || !((Range)range).isWrapAround() || range.right.equals(StorageService.getPartitioner().getMinimumToken())) : range;
        DecoratedKey<Token> startWith = new DecoratedKey<Token>(range.left, null);
        DecoratedKey<Token> stopAt = new DecoratedKey<Token>(range.right, null);
        QueryFilter filter = new QueryFilter(null, new QueryPath(this.columnFamily, superColumn, null), columnFilter);
        int gcBefore = (int)(System.currentTimeMillis() / 1000L) - this.metadata.getGcGraceSeconds();
        DataTracker.View currentView = this.data.getView();
        ArrayList<Memtable> memtables = new ArrayList<Memtable>();
        memtables.add(currentView.memtable);
        memtables.addAll(currentView.memtablesPendingFlush);
        Set<SSTableReader> sstables = currentView.sstables;
        RowIterator iterator = RowIteratorFactory.getIterator(memtables, sstables, startWith, stopAt, filter, this.getComparator(), this);
        ArrayList<Row> rows = new ArrayList<Row>();
        try {
            boolean first = true;
            while (iterator.hasNext()) {
                Row current = iterator.next();
                DecoratedKey<?> key = current.key;
                if (!stopAt.isEmpty() && stopAt.compareTo(key) < 0) {
                    ArrayList<Row> arrayList = rows;
                    return arrayList;
                }
                if (range instanceof Bounds || !first || !key.equals(startWith)) {
                    rows.add(current.cf != null && current.cf.isSuper() ? new Row(current.key, ColumnFamilyStore.removeDeleted(current.cf, gcBefore)) : current);
                    if (logger.isDebugEnabled()) {
                        logger.debug("scanned " + key);
                    }
                }
                first = false;
                if (rows.size() < maxResults) continue;
                ArrayList<Row> arrayList = rows;
                return arrayList;
            }
        }
        finally {
            try {
                iterator.close();
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        return rows;
    }

    public List<Row> scan(IndexClause clause, AbstractBounds range, IFilter dataFilter) {
        IndexExpression primary = this.highestSelectivityPredicate(clause);
        ColumnFamilyStore indexCFS = this.getIndexedColumnFamilyStore(primary.column_name);
        if (logger.isDebugEnabled()) {
            logger.debug("Primary scan clause is " + this.getComparator().getString(primary.column_name));
        }
        assert (indexCFS != null);
        DecoratedKey indexKey = indexCFS.partitioner.decorateKey(primary.value);
        IFilter firstFilter = dataFilter;
        NamesQueryFilter extraFilter = null;
        if (clause.expressions.size() > 1) {
            TreeSet<ByteBuffer> columns;
            if (dataFilter instanceof SliceQueryFilter) {
                if (this.getMaxRowSize() < (long)DatabaseDescriptor.getColumnIndexSize()) {
                    logger.debug("Expanding slice filter to entire row to cover additional expressions");
                    firstFilter = new SliceQueryFilter(ByteBufferUtil.EMPTY_BYTE_BUFFER, ByteBufferUtil.EMPTY_BYTE_BUFFER, ((SliceQueryFilter)dataFilter).reversed, Integer.MAX_VALUE);
                } else {
                    logger.debug("adding extraFilter to cover additional expressions");
                    columns = new TreeSet<ByteBuffer>(this.getComparator());
                    for (IndexExpression expr : clause.expressions) {
                        if (expr == primary) continue;
                        columns.add(expr.column_name);
                    }
                    extraFilter = new NamesQueryFilter(columns);
                }
            } else {
                logger.debug("adding columns to firstFilter to cover additional expressions");
                assert (dataFilter instanceof NamesQueryFilter);
                columns = new TreeSet<ByteBuffer>(this.getComparator());
                for (IndexExpression expr : clause.expressions) {
                    if (expr == primary || ((NamesQueryFilter)dataFilter).columns.contains(expr.column_name)) continue;
                    columns.add(expr.column_name);
                }
                if (columns.size() > 0) {
                    columns.addAll(((NamesQueryFilter)dataFilter).columns);
                    firstFilter = new NamesQueryFilter(columns);
                }
            }
        }
        ArrayList<Row> rows = new ArrayList<Row>();
        ByteBuffer startKey = clause.start_key;
        QueryPath path = new QueryPath(this.columnFamily);
        ByteBuffer lastDataKey = null;
        block2: while (true) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Scanning index row %s:%s starting with %s", indexCFS.columnFamily, indexKey, indexCFS.getComparator().getString(startKey)));
            }
            QueryFilter indexFilter = QueryFilter.getSliceFilter(indexKey, new QueryPath(indexCFS.getColumnFamilyName()), startKey, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, clause.count);
            ColumnFamily indexRow = indexCFS.getColumnFamily(indexFilter);
            logger.debug("fetched {}", (Object)indexRow);
            if (indexRow == null) break;
            ByteBuffer dataKey = null;
            int n = 0;
            for (IColumn column : indexRow.getSortedColumns()) {
                if (column.isMarkedForDelete()) continue;
                dataKey = column.name();
                ++n;
                DecoratedKey dk = this.partitioner.decorateKey(dataKey);
                if (!range.right.equals(this.partitioner.getMinimumToken()) && range.right.compareTo(dk.token) < 0) break block2;
                if (!range.contains((Token)dk.token) || dataKey.equals(lastDataKey)) continue;
                ColumnFamily data = this.getColumnFamily(new QueryFilter(dk, path, firstFilter));
                logger.debug("fetched data row {}", (Object)data);
                if (extraFilter != null) {
                    for (IndexExpression expr : clause.expressions) {
                        if (expr == primary || data.getColumn(expr.column_name) != null) continue;
                        data.addAll(this.getColumnFamily(new QueryFilter(dk, path, extraFilter)));
                        break;
                    }
                }
                if (ColumnFamilyStore.satisfies(data, clause, primary)) {
                    logger.debug("row {} satisfies all clauses", (Object)data);
                    if (firstFilter != dataFilter) {
                        ColumnFamily expandedData = data;
                        data = expandedData.cloneMeShallow();
                        IColumnIterator iter = dataFilter.getMemtableColumnIterator(expandedData, dk, this.getComparator());
                        new QueryFilter(dk, path, dataFilter).collectCollatedColumns(data, iter, this.gcBefore());
                    }
                    rows.add(new Row(dk, data));
                }
                if (rows.size() != clause.count) continue;
                break block2;
            }
            if (n < clause.count || startKey.equals(dataKey)) break;
            lastDataKey = startKey = dataKey;
        }
        return rows;
    }

    private IndexExpression highestSelectivityPredicate(IndexClause clause) {
        IndexExpression best = null;
        int bestMeanCount = Integer.MAX_VALUE;
        for (IndexExpression expression : clause.expressions) {
            int columns;
            ColumnFamilyStore cfs = this.getIndexedColumnFamilyStore(expression.column_name);
            if (cfs == null || !expression.op.equals((Object)IndexOperator.EQ) || (columns = cfs.getMeanColumns()) >= bestMeanCount) continue;
            best = expression;
            bestMeanCount = columns;
        }
        return best;
    }

    private static boolean satisfies(ColumnFamily data, IndexClause clause, IndexExpression first) {
        for (IndexExpression expression : clause.expressions) {
            if (expression == first) continue;
            IColumn column = data.getColumn(expression.column_name);
            if (column == null) {
                return false;
            }
            int v = data.metadata().getValueValidator(expression.column_name).compare(column.value(), expression.value);
            if (ColumnFamilyStore.satisfies(v, expression.op)) continue;
            return false;
        }
        return true;
    }

    private static boolean satisfies(int comparison, IndexOperator op) {
        switch (op) {
            case EQ: {
                return comparison == 0;
            }
            case GTE: {
                return comparison >= 0;
            }
            case GT: {
                return comparison > 0;
            }
            case LTE: {
                return comparison <= 0;
            }
            case LT: {
                return comparison < 0;
            }
        }
        throw new IllegalStateException();
    }

    public AbstractType getComparator() {
        return this.metadata.comparator;
    }

    private void snapshotWithoutFlush(String snapshotName) {
        for (SSTableReader ssTable : this.data.getSSTables()) {
            try {
                File dataDirectory = ssTable.descriptor.directory.getParentFile();
                String snapshotDirectoryPath = Table.getSnapshotPath(dataDirectory.getAbsolutePath(), this.table.name, snapshotName);
                FileUtils.createDirectory(snapshotDirectoryPath);
                ssTable.createLinks(snapshotDirectoryPath);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Snapshot for " + this.table + " keyspace data file " + ssTable.getFilename() + " created in " + snapshotDirectoryPath);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public void snapshot(String snapshotName) {
        try {
            this.forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.snapshotWithoutFlush(snapshotName);
    }

    public boolean hasUnreclaimedSpace() {
        return this.data.getLiveSize() < this.data.getTotalSize();
    }

    @Override
    public long getTotalDiskSpaceUsed() {
        return this.data.getTotalSize();
    }

    @Override
    public long getLiveDiskSpaceUsed() {
        return this.data.getLiveSize();
    }

    @Override
    public int getLiveSSTableCount() {
        return this.data.getSSTables().size();
    }

    public ColumnFamily getRawCachedRow(DecoratedKey key) {
        return this.rowCache.getCapacity() == 0 ? null : (ColumnFamily)this.rowCache.getInternal(key);
    }

    public void invalidateCachedRow(DecoratedKey key) {
        this.rowCache.remove(key);
    }

    @Override
    public void forceMajorCompaction() throws InterruptedException, ExecutionException {
        CompactionManager.instance.performMajor(this);
    }

    @Override
    public void invalidateRowCache() {
        this.rowCache.clear();
    }

    @Override
    public void invalidateKeyCache() {
        this.keyCache.clear();
    }

    public int getRowCacheCapacity() {
        return this.rowCache.getCapacity();
    }

    public int getKeyCacheCapacity() {
        return this.keyCache.getCapacity();
    }

    public int getRowCacheSize() {
        return this.rowCache.size();
    }

    public int getKeyCacheSize() {
        return this.keyCache.size();
    }

    public static Iterable<ColumnFamilyStore> all() {
        Iterable[] stores = new Iterable[DatabaseDescriptor.getTables().size()];
        int i = 0;
        for (Table table : Table.all()) {
            stores[i++] = table.getColumnFamilyStores();
        }
        return Iterables.concat((Iterable[])stores);
    }

    public Iterable<DecoratedKey> allKeySamples() {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] samples = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            samples[i++] = sstable.getKeySamples();
        }
        return Iterables.concat((Iterable[])samples);
    }

    public Iterable<DecoratedKey> keySamples(Range range) {
        Collection<SSTableReader> sstables = this.getSSTables();
        Iterable[] samples = new Iterable[sstables.size()];
        int i = 0;
        for (SSTableReader sstable : sstables) {
            samples[i++] = sstable.getKeySamples(range);
        }
        return Iterables.concat((Iterable[])samples);
    }

    void clearUnsafe() {
        this.data.init();
    }

    public Future<?> truncate() throws IOException {
        try {
            this.forceBlockingFlush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        final long truncatedAt = System.currentTimeMillis();
        this.snapshot(Table.getTimestampedSnapshotName("before-truncate"));
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws InterruptedException, IOException {
                for (ColumnFamilyStore cfs : ColumnFamilyStore.this.concatWithIndexes()) {
                    ArrayList<SSTableReader> truncatedSSTables = new ArrayList<SSTableReader>();
                    for (SSTableReader sstable : cfs.getSSTables()) {
                        if (sstable.newSince(truncatedAt)) continue;
                        truncatedSSTables.add(sstable);
                    }
                    cfs.data.markCompacted(truncatedSSTables);
                }
                ColumnFamilyStore.this.invalidateRowCache();
            }
        };
        return postFlushExecutor.submit(runnable);
    }

    public void renameSSTables(String newCfName) throws IOException {
        IOException mostRecentProblem = null;
        for (File existing : DefsTable.getFiles(this.table.name, this.columnFamily)) {
            try {
                String newFileName = existing.getName().replaceFirst("\\w+-", newCfName + "-");
                FileUtils.renameWithConfirm(existing, new File(existing.getParent(), newFileName));
            }
            catch (IOException ex) {
                mostRecentProblem = ex;
            }
        }
        if (mostRecentProblem != null) {
            throw new IOException("One or more IOExceptions encountered while renaming files. Most recent problem is included.", mostRecentProblem);
        }
        for (ColumnFamilyStore indexedCfs : this.indexedColumns.values()) {
            indexedCfs.renameSSTables(indexedCfs.columnFamily.replace(this.columnFamily, newCfName));
        }
    }

    @Override
    public long getBloomFilterFalsePositives() {
        return this.data.getBloomFilterFalsePositives();
    }

    @Override
    public long getRecentBloomFilterFalsePositives() {
        return this.data.getRecentBloomFilterFalsePositives();
    }

    @Override
    public double getBloomFilterFalseRatio() {
        return this.data.getBloomFilterFalseRatio();
    }

    @Override
    public double getRecentBloomFilterFalseRatio() {
        return this.data.getRecentBloomFilterFalseRatio();
    }

    public SortedSet<ByteBuffer> getIndexedColumns() {
        return this.indexedColumns.keySet();
    }

    public ColumnFamilyStore getIndexedColumnFamilyStore(ByteBuffer column) {
        return this.indexedColumns.get(column);
    }

    public ColumnFamily newIndexedColumnFamily(ByteBuffer column) {
        return ColumnFamily.create(this.indexedColumns.get((Object)column).metadata);
    }

    public DecoratedKey<LocalToken> getIndexKeyFor(ByteBuffer name, ByteBuffer value) {
        return this.indexedColumns.get((Object)name).partitioner.decorateKey(value);
    }

    public String toString() {
        return "ColumnFamilyStore(table='" + this.table.name + '\'' + ", columnFamily='" + this.columnFamily + '\'' + ')';
    }

    @Override
    public void disableAutoCompaction() {
        this.minCompactionThreshold.set(0);
        this.maxCompactionThreshold.set(0);
    }

    @Override
    public int getMinimumCompactionThreshold() {
        return this.minCompactionThreshold.value();
    }

    @Override
    public void setMinimumCompactionThreshold(int minCompactionThreshold) {
        if (minCompactionThreshold > this.maxCompactionThreshold.value() && this.maxCompactionThreshold.value() != 0) {
            throw new RuntimeException("The min_compaction_threshold cannot be larger than the max.");
        }
        this.minCompactionThreshold.set(minCompactionThreshold);
    }

    @Override
    public int getMaximumCompactionThreshold() {
        return this.maxCompactionThreshold.value();
    }

    @Override
    public void setMaximumCompactionThreshold(int maxCompactionThreshold) {
        if (maxCompactionThreshold < this.minCompactionThreshold.value()) {
            throw new RuntimeException("The max_compaction_threshold cannot be smaller than the min.");
        }
        this.maxCompactionThreshold.set(maxCompactionThreshold);
    }

    @Override
    public int getMemtableFlushAfterMins() {
        return this.memtime.value();
    }

    @Override
    public void setMemtableFlushAfterMins(int time) {
        if (time <= 0) {
            throw new RuntimeException("MemtableFlushAfterMins must be greater than 0.");
        }
        this.memtime.set(time);
    }

    @Override
    public int getMemtableThroughputInMB() {
        return this.memsize.value();
    }

    @Override
    public void setMemtableThroughputInMB(int size) throws ConfigurationException {
        DatabaseDescriptor.validateMemtableThroughput(size);
        this.memsize.set(size);
    }

    @Override
    public double getMemtableOperationsInMillions() {
        return this.memops.value();
    }

    @Override
    public void setMemtableOperationsInMillions(double ops) throws ConfigurationException {
        DatabaseDescriptor.validateMemtableOperations(ops);
        this.memops.set(ops);
    }

    @Override
    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSaveInSeconds.value();
    }

    @Override
    public void setRowCacheSavePeriodInSeconds(int rcspis) {
        if (rcspis < 0) {
            throw new RuntimeException("RowCacheSavePeriodInSeconds must be non-negative.");
        }
        this.rowCacheSaveInSeconds.set(rcspis);
        this.scheduleCacheSaving(this.rowCacheSaveInSeconds.value(), this.keyCacheSaveInSeconds.value());
    }

    @Override
    public int getKeyCacheSavePeriodInSeconds() {
        return this.keyCacheSaveInSeconds.value();
    }

    @Override
    public void setKeyCacheSavePeriodInSeconds(int kcspis) {
        if (kcspis < 0) {
            throw new RuntimeException("KeyCacheSavePeriodInSeconds must be non-negative.");
        }
        this.keyCacheSaveInSeconds.set(kcspis);
        this.scheduleCacheSaving(this.rowCacheSaveInSeconds.value(), this.keyCacheSaveInSeconds.value());
    }

    @Override
    public long estimateKeys() {
        return this.data.estimatedKeys();
    }

    public synchronized void updateCacheSizes() {
        long keys = this.estimateKeys();
        this.keyCache.updateCacheSize(keys);
        this.rowCache.updateCacheSize(keys);
    }

    @Override
    public long[] getEstimatedRowSizeHistogram() {
        return this.data.getEstimatedRowSizeHistogram();
    }

    @Override
    public long[] getEstimatedColumnCountHistogram() {
        return this.data.getEstimatedRowSizeHistogram();
    }

    public boolean isIndexBuilt() {
        return SystemTable.isIndexBuilt(this.table.name, this.columnFamily);
    }

    @Override
    public List<String> getBuiltIndexes() {
        ArrayList<String> indexes = new ArrayList<String>();
        for (ColumnFamilyStore cfs : this.indexedColumns.values()) {
            if (!cfs.isIndexBuilt()) continue;
            indexes.add(cfs.columnFamily);
        }
        return indexes;
    }

    public boolean isIndex() {
        return this.partitioner instanceof LocalPartitioner;
    }

    private String getParentColumnfamily() {
        assert (this.isIndex());
        return this.columnFamily.split("\\.")[0];
    }

    public void reduceCacheSizes() {
        this.rowCache.reduceCacheSize();
        this.keyCache.reduceCacheSize();
    }

    private ByteBuffer intern(ByteBuffer name) {
        ByteBuffer concurrentName;
        ByteBuffer internedName = (ByteBuffer)this.internedNames.get(name);
        if (internedName == null && (concurrentName = this.internedNames.putIfAbsent(internedName = ByteBufferUtil.clone(name), internedName)) != null) {
            internedName = concurrentName;
        }
        return internedName;
    }

    public ByteBuffer internOrCopy(ByteBuffer name) {
        if (this.internedNames.size() >= 256) {
            return ByteBufferUtil.clone(name);
        }
        return this.intern(name);
    }

    public ByteBuffer maybeIntern(ByteBuffer name) {
        if (this.internedNames.size() >= 256) {
            return name;
        }
        return this.intern(name);
    }

    public SSTableWriter createFlushWriter(long estimatedRows, long estimatedSize) throws IOException {
        return new SSTableWriter(this.getFlushPath(estimatedSize, "f"), estimatedRows, this.metadata, this.partitioner);
    }

    public SSTableWriter createCompactionWriter(long estimatedRows, String location) throws IOException {
        return new SSTableWriter(this.getTempSSTablePath(location), estimatedRows, this.metadata, this.partitioner);
    }

    public Iterable<ColumnFamilyStore> concatWithIndexes() {
        return Iterables.concat(this.indexedColumns.values(), Collections.singleton(this));
    }

    public Set<Memtable> getMemtablesPendingFlush() {
        return this.data.getMemtablesPendingFlush();
    }

    static {
        if (DatabaseDescriptor.estimatesRealMemtableSize()) {
            logger.info("Global memtable threshold is enabled at {}MB", (Object)DatabaseDescriptor.getTotalMemtableSpaceInMB());
            StorageService.tasks.scheduleWithFixedDelay(new MeteredFlusher(), 1000L, 1000L, TimeUnit.MILLISECONDS);
        } else {
            logger.info("Global memtable threshold is disabled");
        }
    }

    public static enum CacheType {
        KEY_CACHE_TYPE("KeyCache"),
        ROW_CACHE_TYPE("RowCache");

        public final String name;

        private CacheType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

