/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryVerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(BinaryVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        byte[] bytes = message.getMessageBody();
        ByteArrayInputStream buffer = new ByteArrayInputStream(bytes);
        try {
            RowMutation rm = RowMutation.serializer().deserialize(new DataInputStream(buffer), message.getVersion());
            rm.applyBinary();
            WriteResponse response = new WriteResponse(rm.getTable(), rm.key(), true);
            Message responseMessage = WriteResponse.makeWriteResponseMessage(message, response);
            if (logger_.isDebugEnabled()) {
                logger_.debug("binary " + rm + " applied.  Sending response to " + id + "@" + message.getFrom());
            }
            MessagingService.instance().sendReply(responseMessage, id, message.getFrom());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

