/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.regex.Pattern;
import org.apache.cassandra.cql.jdbc.CassandraResultSet;
import org.apache.cassandra.cql.jdbc.Connection;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;

class CassandraStatement
implements Statement {
    protected static final Pattern UpdatePattern = Pattern.compile("UPDATE .*", 2);
    protected final Connection connection;
    protected final String cql;

    CassandraStatement(Connection con) {
        this(con, null);
    }

    CassandraStatement(Connection con, String cql) {
        this.connection = con;
        this.cql = cql;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void cancel() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public boolean execute(String query) throws SQLException {
        try {
            return this.connection.execute(query) != null;
        }
        catch (InvalidRequestException e) {
            throw new SQLException(e.getWhy());
        }
        catch (UnavailableException e) {
            throw new SQLException("Cassandra was unavialable", e);
        }
        catch (TimedOutException e) {
            throw new SQLException(e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new SQLException("schema does not match across nodes, (try again later).");
        }
        catch (TException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public ResultSet executeQuery(String query) throws SQLException {
        try {
            CqlResult rSet = this.connection.execute(query);
            return new CassandraResultSet(rSet, this.connection.decoder, this.connection.curKeyspace, this.connection.curColumnFamily);
        }
        catch (InvalidRequestException e) {
            throw new SQLException(e.getWhy());
        }
        catch (UnavailableException e) {
            throw new SQLException(e.getMessage());
        }
        catch (TimedOutException e) {
            throw new SQLException(e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new SQLException("schema does not match across nodes, (try again later).");
        }
        catch (TException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        if (!UpdatePattern.matcher(query).matches()) {
            throw new SQLException("Not an update statement.");
        }
        try {
            CqlResult rSet = this.connection.execute(query);
            assert (rSet.getType().equals((Object)CqlResultType.VOID));
            return 0;
        }
        catch (InvalidRequestException e) {
            throw new SQLException(e.getWhy());
        }
        catch (UnavailableException e) {
            throw new SQLException(e.getMessage());
        }
        catch (TimedOutException e) {
            throw new SQLException(e.getMessage());
        }
        catch (SchemaDisagreementException e) {
            throw new SQLException("schema does not match across nodes, (try again later).");
        }
        catch (TException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public java.sql.Connection getConnection() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }
}

