/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.cql.jdbc.CassandraStatement;
import org.apache.cassandra.cql.jdbc.ColumnDecoder;
import org.apache.cassandra.cql.jdbc.ColumnMetaData;
import org.apache.cassandra.cql.jdbc.Connection;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public class CassandraPreparedStatement
extends CassandraStatement
implements PreparedStatement {
    private static final Pattern Select = Pattern.compile("SELECT[\\s+FIRST\\s+\\d+]?[\\s+REVERSED]?\\s+(.*)WHERE\\s+(.*)", 2);
    private static final Pattern Update = Pattern.compile("UPDATE\\s+\\w+.*\\s+SET\\s+(.*)\\s+WHERE KEY(.*)", 2);
    private static final Pattern Delete = Pattern.compile("DELETE\\s+(.*)\\s+FROM\\s+\\w+\\s+WHERE KEY(.*)", 2);
    private final Map<Integer, Object> variables = new HashMap<Integer, Object>();
    private final List<String> queries = new ArrayList<String>();

    CassandraPreparedStatement(Connection con, String cql) {
        super(con, cql);
    }

    private static boolean needsQuotes(AbstractType type) {
        if (type instanceof ColumnMetaData) {
            return ((ColumnMetaData)((Object)type)).needsQuotes();
        }
        return type == BytesType.instance || type == AsciiType.instance || type == UTF8Type.instance || type == LexicalUUIDType.instance || type == TimeUUIDType.instance || type == UUIDType.instance;
    }

    private static String makeCqlString(String s) {
        return s.replaceAll("'", "''");
    }

    private static String applySimpleBindings(String q, AbstractType type, ParameterIterator params) throws SQLException {
        assert (type != null);
        StringBuffer sb = new StringBuffer();
        boolean between = false;
        for (char c : q.toCharArray()) {
            if (c == '\'') {
                boolean bl = between = !between;
            }
            if (between) {
                sb.append(c);
                continue;
            }
            if (c == '?') {
                try {
                    Object param = params.nextParam();
                    String stringParam = type == null ? param.toString() : type.toString(param);
                    stringParam = CassandraPreparedStatement.makeCqlString(stringParam);
                    if (type == null || CassandraPreparedStatement.needsQuotes(type)) {
                        stringParam = "'" + stringParam + "'";
                    }
                    sb.append(stringParam);
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new SQLException("Mismatched types: " + ex.getLocalizedMessage());
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String applyDualBindings(String q, AbstractType ltype, AbstractType rtype, ParameterIterator params) throws SQLException {
        StringBuffer sb = new StringBuffer();
        boolean between = false;
        boolean left = true;
        for (char c : q.toCharArray()) {
            if (c == '\'') {
                boolean bl = between = !between;
            }
            if (c == '=' && !between) {
                left = false;
            }
            if (c == ',' && !between) {
                left = true;
            }
            if (c == '?' && !between) {
                try {
                    Object param = params.nextParam();
                    AbstractType type = left ? ltype : rtype;
                    String stringParam = CassandraPreparedStatement.makeCqlString(type.toString(param));
                    if (CassandraPreparedStatement.needsQuotes(type)) {
                        stringParam = "'" + stringParam + "'";
                    }
                    sb.append(stringParam);
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new SQLException("Mismatched types: " + ex.getLocalizedMessage());
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public synchronized String makeCql() throws SQLException {
        Matcher m = Delete.matcher(this.cql);
        if (m.matches()) {
            return this.makeDelete(m.end(1));
        }
        m = Update.matcher(this.cql);
        if (m.matches()) {
            return this.makeUpdate(m.end(1));
        }
        m = Select.matcher(this.cql);
        if (m.matches()) {
            return this.makeSelect(m.end(1));
        }
        return this.cql;
    }

    private String makeDelete(int pivot) throws SQLException {
        String keyspace = this.connection.getKeyspace(this.cql);
        String columnFamily = this.connection.getColumnFamily(this.cql);
        ParameterIterator params = new ParameterIterator();
        String left = this.cql.substring(0, pivot);
        AbstractType leftType = this.connection.decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Comparator, null);
        if (leftType == null) {
            throw new SQLException("Could not find comparator for " + keyspace + "." + columnFamily);
        }
        left = CassandraPreparedStatement.applySimpleBindings(left, leftType, params);
        String right = this.cql.substring(pivot);
        AbstractType keyVald = this.connection.decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Key, null);
        if (keyVald == null) {
            throw new SQLException("Could not find key validator for " + keyspace + "." + columnFamily);
        }
        right = CassandraPreparedStatement.applySimpleBindings(right, keyVald, params);
        return left + right;
    }

    private String makeSelect(int pivot) throws SQLException {
        String keyspace = this.connection.getKeyspace(this.cql);
        String columnFamily = this.connection.getColumnFamily(this.cql);
        ParameterIterator params = new ParameterIterator();
        String left = this.cql.substring(0, pivot);
        AbstractType leftType = this.connection.decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Comparator, null);
        if (leftType == null) {
            throw new SQLException("Could not find comparator for " + keyspace + "." + columnFamily);
        }
        left = CassandraPreparedStatement.applySimpleBindings(left, leftType, params);
        String right = this.cql.substring(pivot);
        AbstractType keyVald = this.connection.decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Key, null);
        if (keyVald == null) {
            throw new SQLException("Could not find key validator for " + keyspace + "." + columnFamily);
        }
        right = CassandraPreparedStatement.applySimpleBindings(right, keyVald, params);
        return left + right;
    }

    private String makeUpdate(int pivot) throws SQLException {
        String keyspace = this.connection.getKeyspace(this.cql);
        String columnFamily = this.connection.getColumnFamily(this.cql);
        ParameterIterator params = new ParameterIterator();
        String left = this.cql.substring(0, pivot);
        AbstractType leftComp = this.connection.decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Comparator, null);
        if (leftComp == null) {
            throw new SQLException("Could not find comparator for " + keyspace + "." + columnFamily);
        }
        AbstractType leftVald = this.connection.decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Validator, null);
        if (leftVald == null) {
            throw new SQLException("Could not find validator for " + keyspace + "." + columnFamily);
        }
        left = CassandraPreparedStatement.applyDualBindings(left, leftComp, leftVald, params);
        String right = this.cql.substring(pivot);
        AbstractType keyVald = this.connection.decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Key, null);
        if (keyVald == null) {
            throw new SQLException("Could not find key validator for " + keyspace + "." + columnFamily);
        }
        right = CassandraPreparedStatement.applySimpleBindings(right, keyVald, params);
        return left + right;
    }

    @Override
    public void addBatch() throws SQLException {
        this.queries.add(this.makeCql());
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        this.variables.clear();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.cql != null && super.execute(this.makeCql());
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.cql != null ? super.executeQuery(this.makeCql()) : null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        String q = this.makeCql();
        if (!UpdatePattern.matcher(q).matches()) {
            throw new SQLException("Not an update statement.");
        }
        super.execute(q);
        return 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement.getMetaData() hasn't been implemented yet.");
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, new byte[]{x});
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, ByteBuffer.wrap(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, new BigInteger(Integer.toString(x)));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.variables.put(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setInt(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("PreparedStatement.getParameterMetaData() hasn't been implemented yet.");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("method not supported");
    }

    private class ParameterIterator {
        private Map<Integer, Object> params;
        private int index;

        private ParameterIterator() {
            this.params = new HashMap<Integer, Object>(CassandraPreparedStatement.this.variables);
            this.index = 1;
        }

        private Object nextParam() throws SQLException {
            Object p;
            if ((p = this.params.get(this.index++)) == null) {
                throw new SQLException("No parameter bound to " + (this.index - 1));
            }
            return p;
        }
    }
}

