/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.lang.management.ManagementFactory;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.cache.ICache;
import org.apache.cassandra.cache.InstrumentingCacheMBean;

public class InstrumentingCache<K, V>
implements InstrumentingCacheMBean {
    private final AtomicLong requests = new AtomicLong(0L);
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong lastRequests = new AtomicLong(0L);
    private final AtomicLong lastHits = new AtomicLong(0L);
    private volatile boolean capacitySetManually;
    private final ICache<K, V> map;

    public InstrumentingCache(ICache<K, V> map, String table, String name) {
        this.map = map;
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mbeanName = new ObjectName("org.apache.cassandra.db:type=Caches,keyspace=" + table + ",cache=" + name);
            if (mbs.isRegistered(mbeanName)) {
                mbs.unregisterMBean(mbeanName);
            }
            mbs.registerMBean(this, mbeanName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public V get(K key) {
        V v = this.map.get(key);
        this.requests.incrementAndGet();
        if (v != null) {
            this.hits.incrementAndGet();
        }
        return v;
    }

    public V getInternal(K key) {
        return this.map.get(key);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    @Override
    public int getCapacity() {
        return this.map.capacity();
    }

    public boolean isCapacitySetManually() {
        return this.capacitySetManually;
    }

    public void updateCapacity(int capacity) {
        this.map.setCapacity(capacity);
    }

    @Override
    public void setCapacity(int capacity) {
        this.updateCapacity(capacity);
        this.capacitySetManually = true;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public long getHits() {
        return this.hits.get();
    }

    @Override
    public long getRequests() {
        return this.requests.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRecentHitRate() {
        long r = this.requests.get();
        long h = this.hits.get();
        try {
            double d = (double)(h - this.lastHits.get()) / (double)(r - this.lastRequests.get());
            return d;
        }
        finally {
            this.lastRequests.set(r);
            this.lastHits.set(h);
        }
    }

    public void clear() {
        this.map.clear();
        this.requests.set(0L);
        this.hits.set(0L);
    }

    public Set<K> getKeySet() {
        return this.map.keySet();
    }

    public boolean isPutCopying() {
        return this.map.isPutCopying();
    }
}

