/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cassandra.cache.InstrumentingCacheMBean;
import org.apache.cassandra.concurrent.IExecutorMBean;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.db.CompactionManagerMBean;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.streaming.StreamingServiceMBean;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.tools.ColumnFamilyStoreMBeanIterator;
import org.apache.cassandra.tools.ThreadPoolProxyMBeanIterator;

public class NodeProbe {
    private static final String fmtUrl = "service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi";
    private static final String ssObjName = "org.apache.cassandra.db:type=StorageService";
    private static final int defaultPort = 7199;
    final String host;
    final int port;
    private String username;
    private String password;
    private JMXConnector jmxc;
    private MBeanServerConnection mbeanServerConn;
    private CompactionManagerMBean compactionProxy;
    private StorageServiceMBean ssProxy;
    private MemoryMXBean memProxy;
    private RuntimeMXBean runtimeProxy;
    private StreamingServiceMBean streamProxy;

    public NodeProbe(String host, int port, String username, String password) throws IOException, InterruptedException {
        assert (username != null && !username.isEmpty() && null != password && !password.isEmpty()) : "neither username nor password can be blank";
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.connect();
    }

    public NodeProbe(String host, int port) throws IOException, InterruptedException {
        this.host = host;
        this.port = port;
        this.connect();
    }

    public NodeProbe(String host) throws IOException, InterruptedException {
        this.host = host;
        this.port = 7199;
        this.connect();
    }

    private void connect() throws IOException {
        JMXServiceURL jmxUrl = new JMXServiceURL(String.format(fmtUrl, this.host, this.port));
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (this.username != null) {
            String[] creds = new String[]{this.username, this.password};
            env.put("jmx.remote.credentials", creds);
        }
        this.jmxc = JMXConnectorFactory.connect(jmxUrl, env);
        this.mbeanServerConn = this.jmxc.getMBeanServerConnection();
        try {
            ObjectName name = new ObjectName(ssObjName);
            this.ssProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StorageServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.net:type=StreamingService");
            this.streamProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, StreamingServiceMBean.class);
            name = new ObjectName("org.apache.cassandra.db:type=CompactionManager");
            this.compactionProxy = JMX.newMBeanProxy(this.mbeanServerConn, name, CompactionManagerMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        this.memProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Memory", MemoryMXBean.class);
        this.runtimeProxy = ManagementFactory.newPlatformMXBeanProxy(this.mbeanServerConn, "java.lang:type=Runtime", RuntimeMXBean.class);
    }

    public void close() throws IOException {
        this.jmxc.close();
    }

    public void forceTableCleanup(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceTableCleanup(tableName, columnFamilies);
    }

    public void scrub(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.scrub(tableName, columnFamilies);
    }

    public void forceTableCompaction(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceTableCompaction(tableName, columnFamilies);
    }

    public void forceTableFlush(String tableName, String ... columnFamilies) throws IOException, ExecutionException, InterruptedException {
        this.ssProxy.forceTableFlush(tableName, columnFamilies);
    }

    public void forceTableRepair(String tableName, String ... columnFamilies) throws IOException {
        this.ssProxy.forceTableRepair(tableName, columnFamilies);
    }

    public void invalidateKeyCaches(String tableName, String ... columnFamilies) throws IOException {
        this.ssProxy.invalidateKeyCaches(tableName, columnFamilies);
    }

    public void invalidateRowCaches(String tableName, String ... columnFamilies) throws IOException {
        this.ssProxy.invalidateRowCaches(tableName, columnFamilies);
    }

    public void drain() throws IOException, InterruptedException, ExecutionException {
        this.ssProxy.drain();
    }

    public Map<Token, String> getTokenToEndpointMap() {
        return this.ssProxy.getTokenToEndpointMap();
    }

    public List<String> getLiveNodes() {
        return this.ssProxy.getLiveNodes();
    }

    public List<String> getJoiningNodes() {
        return this.ssProxy.getJoiningNodes();
    }

    public List<String> getLeavingNodes() {
        return this.ssProxy.getLeavingNodes();
    }

    public List<String> getMovingNodes() {
        return this.ssProxy.getMovingNodes();
    }

    public List<String> getUnreachableNodes() {
        return this.ssProxy.getUnreachableNodes();
    }

    public Map<String, String> getLoadMap() {
        return this.ssProxy.getLoadMap();
    }

    public Map<Token, Float> getOwnership() {
        return this.ssProxy.getOwnership();
    }

    public Iterator<Map.Entry<String, ColumnFamilyStoreMBean>> getColumnFamilyStoreMBeanProxies() {
        try {
            return new ColumnFamilyStoreMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public CompactionManagerMBean getCompactionManagerProxy() {
        return this.compactionProxy;
    }

    public InstrumentingCacheMBean getKeyCacheMBean(String tableName, String cfName) {
        String keyCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "KeyCache";
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(keyCachePath), InstrumentingCacheMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public InstrumentingCacheMBean getRowCacheMBean(String tableName, String cfName) {
        String rowCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "RowCache";
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(rowCachePath), InstrumentingCacheMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public String getToken() {
        return this.ssProxy.getToken();
    }

    public String getLoadString() {
        return this.ssProxy.getLoadString();
    }

    public String getReleaseVersion() {
        return this.ssProxy.getReleaseVersion();
    }

    public int getCurrentGenerationNumber() {
        return this.ssProxy.getCurrentGenerationNumber();
    }

    public long getUptime() {
        return this.runtimeProxy.getUptime();
    }

    public MemoryUsage getHeapMemoryUsage() {
        return this.memProxy.getHeapMemoryUsage();
    }

    public void takeSnapshot(String snapshotName, String ... keyspaces) throws IOException {
        this.ssProxy.takeSnapshot(snapshotName, keyspaces);
    }

    public void clearSnapshot(String tag, String ... keyspaces) throws IOException {
        this.ssProxy.clearSnapshot(tag, keyspaces);
    }

    public boolean isJoined() {
        return this.ssProxy.isJoined();
    }

    public void joinRing() throws IOException, ConfigurationException {
        this.ssProxy.joinRing();
    }

    public void decommission() throws InterruptedException {
        this.ssProxy.decommission();
    }

    public void move(String newToken) throws IOException, InterruptedException {
        this.ssProxy.move(newToken);
    }

    public void removeToken(String token) {
        this.ssProxy.removeToken(token);
    }

    public String getRemovalStatus() {
        return this.ssProxy.getRemovalStatus();
    }

    public void forceRemoveCompletion() {
        this.ssProxy.forceRemoveCompletion();
    }

    public Iterator<Map.Entry<String, IExecutorMBean>> getThreadPoolMBeanProxies() {
        try {
            return new ThreadPoolProxyMBeanIterator(this.mbeanServerConn);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName? Please report this as a bug.", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not retrieve list of stat mbeans.", e);
        }
    }

    public void getCompactionThreshold(PrintStream outs, String ks, String cf) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        outs.println("Current compaction thresholds for " + ks + "/" + cf + ": \n" + " min = " + cfsProxy.getMinimumCompactionThreshold() + ", " + " max = " + cfsProxy.getMaximumCompactionThreshold());
    }

    public void setCompactionThreshold(String ks, String cf, int minimumCompactionThreshold, int maximumCompactionThreshold) {
        ColumnFamilyStoreMBean cfsProxy = this.getCfsProxy(ks, cf);
        cfsProxy.setMinimumCompactionThreshold(minimumCompactionThreshold);
        cfsProxy.setMaximumCompactionThreshold(maximumCompactionThreshold);
    }

    public void setCacheCapacities(String tableName, String cfName, int keyCacheCapacity, int rowCacheCapacity) {
        try {
            String keyCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "KeyCache";
            InstrumentingCacheMBean keyCacheMBean = JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(keyCachePath), InstrumentingCacheMBean.class);
            keyCacheMBean.setCapacity(keyCacheCapacity);
            String rowCachePath = "org.apache.cassandra.db:type=Caches,keyspace=" + tableName + ",cache=" + cfName + "RowCache";
            InstrumentingCacheMBean rowCacheMBean = null;
            rowCacheMBean = JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName(rowCachePath), InstrumentingCacheMBean.class);
            rowCacheMBean.setCapacity(rowCacheCapacity);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public List<InetAddress> getEndpoints(String keyspace, String key) {
        return this.ssProxy.getNaturalEndpoints(keyspace, key.getBytes(Charsets.UTF_8));
    }

    public Set<InetAddress> getStreamDestinations() {
        return this.streamProxy.getStreamDestinations();
    }

    public List<String> getFilesDestinedFor(InetAddress host) throws IOException {
        return this.streamProxy.getOutgoingFiles(host.getHostAddress());
    }

    public Set<InetAddress> getStreamSources() {
        return this.streamProxy.getStreamSources();
    }

    public List<String> getIncomingFiles(InetAddress host) throws IOException {
        return this.streamProxy.getIncomingFiles(host.getHostAddress());
    }

    public String getOperationMode() {
        return this.ssProxy.getOperationMode();
    }

    public void truncate(String tableName, String cfName) {
        try {
            this.ssProxy.truncate(tableName, cfName);
        }
        catch (UnavailableException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while executing truncate", e);
        }
    }

    public MessagingServiceMBean getMsProxy() {
        try {
            return JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.net:type=MessagingService"), MessagingServiceMBean.class);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnFamilyStoreMBean getCfsProxy(String ks, String cf) {
        ColumnFamilyStoreMBean cfsProxy = null;
        try {
            cfsProxy = JMX.newMBeanProxy(this.mbeanServerConn, new ObjectName("org.apache.cassandra.db:type=ColumnFamilies,keyspace=" + ks + ",columnfamily=" + cf), ColumnFamilyStoreMBean.class);
        }
        catch (MalformedObjectNameException mone) {
            System.err.println("ColumnFamilyStore for " + ks + "/" + cf + " not found.");
            System.exit(1);
        }
        return cfsProxy;
    }

    public List<String> getKeyspaces() {
        return this.ssProxy.getKeyspaces();
    }

    public void stopGossiping() {
        this.ssProxy.stopGossiping();
    }

    public void startGossiping() {
        this.ssProxy.startGossiping();
    }

    public void stopThriftServer() {
        this.ssProxy.stopRPCServer();
    }

    public void startThriftServer() {
        this.ssProxy.startRPCServer();
    }

    public boolean isInitialized() {
        return this.ssProxy.isInitialized();
    }

    public void setCompactionThroughput(int value) {
        this.ssProxy.setCompactionThroughputMbPerSec(value);
    }
}

