/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.utils.FBUtilities;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReplicationStrategy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReplicationStrategy.class);
    public final String table;
    public final Map<String, String> configOptions;
    private final TokenMetadata tokenMetadata;
    public IEndpointSnitch snitch;
    private final Map<Token, ArrayList<InetAddress>> cachedEndpoints = new NonBlockingHashMap();

    AbstractReplicationStrategy(String table, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) {
        assert (table != null);
        assert (snitch != null);
        assert (tokenMetadata != null);
        this.tokenMetadata = tokenMetadata;
        this.snitch = snitch;
        this.tokenMetadata.register(this);
        this.configOptions = configOptions;
        this.table = table;
    }

    public ArrayList<InetAddress> getCachedEndpoints(Token t) {
        return this.cachedEndpoints.get(t);
    }

    public void cacheEndpoint(Token t, ArrayList<InetAddress> addr) {
        this.cachedEndpoints.put(t, addr);
    }

    public void clearEndpointCache() {
        logger.debug("clearing cached endpoints");
        this.cachedEndpoints.clear();
    }

    public ArrayList<InetAddress> getNaturalEndpoints(Token searchToken) throws IllegalStateException {
        Token keyToken = TokenMetadata.firstToken(this.tokenMetadata.sortedTokens(), searchToken);
        ArrayList<InetAddress> endpoints = this.getCachedEndpoints(keyToken);
        if (endpoints == null) {
            TokenMetadata tokenMetadataClone = this.tokenMetadata.cloneOnlyTokenMap();
            keyToken = TokenMetadata.firstToken(tokenMetadataClone.sortedTokens(), searchToken);
            endpoints = new ArrayList<InetAddress>(this.calculateNaturalEndpoints(searchToken, tokenMetadataClone));
            this.cacheEndpoint(keyToken, endpoints);
            assert (this.getReplicationFactor() <= endpoints.size()) : String.format("endpoints %s generated for RF of %s", Arrays.toString(endpoints.toArray()), this.getReplicationFactor());
        }
        return new ArrayList<InetAddress>(endpoints);
    }

    public abstract List<InetAddress> calculateNaturalEndpoints(Token var1, TokenMetadata var2) throws IllegalStateException;

    public IWriteResponseHandler getWriteResponseHandler(Collection<InetAddress> writeEndpoints, Multimap<InetAddress, InetAddress> hintedEndpoints, ConsistencyLevel consistencyLevel) {
        return WriteResponseHandler.create(writeEndpoints, hintedEndpoints, consistencyLevel, this.table);
    }

    public abstract int getReplicationFactor();

    public Multimap<InetAddress, InetAddress> getHintedEndpoints(Collection<InetAddress> targets) {
        HashMultimap map = HashMultimap.create((int)targets.size(), (int)1);
        for (InetAddress ep : targets) {
            if (!FailureDetector.instance.isAlive(ep)) continue;
            map.put((Object)ep, (Object)ep);
        }
        if (map.size() == targets.size() || !StorageProxy.isHintedHandoffEnabled()) {
            return map;
        }
        InetAddress localAddress = FBUtilities.getLocalAddress();
        for (InetAddress ep : targets) {
            if (map.containsKey((Object)ep)) continue;
            if (!StorageProxy.shouldHint(ep)) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug("not hinting " + ep + " which has been down " + Gossiper.instance.getEndpointDowntime(ep) + "ms");
                continue;
            }
            InetAddress destination = map.isEmpty() ? localAddress : this.snitch.getSortedListByProximity(localAddress, map.keySet()).get(0);
            map.put((Object)destination, (Object)ep);
        }
        return map;
    }

    public Multimap<InetAddress, Range> getAddressRanges(TokenMetadata metadata) {
        HashMultimap map = HashMultimap.create();
        for (Token token : metadata.sortedTokens()) {
            Range range = metadata.getPrimaryRangeFor(token);
            for (InetAddress ep : this.calculateNaturalEndpoints(token, metadata)) {
                map.put((Object)ep, (Object)range);
            }
        }
        return map;
    }

    public Multimap<Range, InetAddress> getRangeAddresses(TokenMetadata metadata) {
        HashMultimap map = HashMultimap.create();
        for (Token token : metadata.sortedTokens()) {
            Range range = metadata.getPrimaryRangeFor(token);
            for (InetAddress ep : this.calculateNaturalEndpoints(token, metadata)) {
                map.put((Object)range, (Object)ep);
            }
        }
        return map;
    }

    public Multimap<InetAddress, Range> getAddressRanges() {
        return this.getAddressRanges(this.tokenMetadata);
    }

    public Collection<Range> getPendingAddressRanges(TokenMetadata metadata, Token pendingToken, InetAddress pendingAddress) {
        TokenMetadata temp = metadata.cloneOnlyTokenMap();
        temp.updateNormalToken(pendingToken, pendingAddress);
        return this.getAddressRanges(temp).get((Object)pendingAddress);
    }

    public void invalidateCachedTokenEndpointValues() {
        this.clearEndpointCache();
    }

    public abstract void validateOptions() throws ConfigurationException;

    public static AbstractReplicationStrategy createReplicationStrategy(String table, Class<? extends AbstractReplicationStrategy> strategyClass, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> strategyOptions) throws ConfigurationException {
        AbstractReplicationStrategy strategy;
        Class[] parameterTypes = new Class[]{String.class, TokenMetadata.class, IEndpointSnitch.class, Map.class};
        try {
            Constructor<? extends AbstractReplicationStrategy> constructor = strategyClass.getConstructor(parameterTypes);
            strategy = constructor.newInstance(table, tokenMetadata, snitch, strategyOptions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        strategy.validateOptions();
        return strategy;
    }

    public static AbstractReplicationStrategy createReplicationStrategy(String table, String strategyClassName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> strategyOptions) throws ConfigurationException {
        Class<AbstractReplicationStrategy> c = AbstractReplicationStrategy.getClass(strategyClassName);
        return AbstractReplicationStrategy.createReplicationStrategy(table, c, tokenMetadata, snitch, strategyOptions);
    }

    public static Class<AbstractReplicationStrategy> getClass(String cls) throws ConfigurationException {
        String className = cls.contains(".") ? cls : "org.apache.cassandra.locator." + cls;
        return FBUtilities.classForName(className, "replication strategy");
    }
}

