/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class AsciiType
extends AbstractType<String> {
    public static final AsciiType instance = new AsciiType();

    public static AsciiType getInstance() {
        return instance;
    }

    AsciiType() {
    }

    @Override
    public String getString(ByteBuffer bytes) {
        try {
            return ByteBufferUtil.string(bytes, Charsets.US_ASCII);
        }
        catch (CharacterCodingException e) {
            throw new MarshalException("Invalid ascii bytes " + ByteBufferUtil.bytesToHex(bytes));
        }
    }

    @Override
    public String toString(String s) {
        return s;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return BytesType.bytesCompare(o1, o2);
    }

    @Override
    public String compose(ByteBuffer bytes) {
        return this.getString(bytes);
    }

    @Override
    public ByteBuffer decompose(String value) {
        return ByteBufferUtil.bytes(value, Charsets.US_ASCII);
    }

    @Override
    public ByteBuffer fromString(String source) {
        return this.decompose(source);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        for (int i = bytes.position(); i < bytes.limit(); ++i) {
            byte b = bytes.get(i);
            if (b >= 0 && b <= 127) continue;
            throw new MarshalException("Invalid byte for ascii: " + Byte.toString(b));
        }
    }

    @Override
    public Class<String> getType() {
        return String.class;
    }
}

