/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.sstable.IndexHelper;

public abstract class AbstractType<T>
implements Comparator<ByteBuffer> {
    public final Comparator<IndexHelper.IndexInfo> indexComparator = new Comparator<IndexHelper.IndexInfo>(){

        @Override
        public int compare(IndexHelper.IndexInfo o1, IndexHelper.IndexInfo o2) {
            return AbstractType.this.compare(o1.lastName, o2.lastName);
        }
    };
    public final Comparator<IndexHelper.IndexInfo> indexReverseComparator = new Comparator<IndexHelper.IndexInfo>(){

        @Override
        public int compare(IndexHelper.IndexInfo o1, IndexHelper.IndexInfo o2) {
            return AbstractType.this.compare(o1.firstName, o2.firstName);
        }
    };
    public final Comparator<IColumn> columnComparator = new Comparator<IColumn>(){

        @Override
        public int compare(IColumn c1, IColumn c2) {
            return AbstractType.this.compare(c1.name(), c2.name());
        }
    };
    public final Comparator<IColumn> columnReverseComparator = new Comparator<IColumn>(){

        @Override
        public int compare(IColumn c1, IColumn c2) {
            return AbstractType.this.compare(c2.name(), c1.name());
        }
    };
    public final Comparator<ByteBuffer> reverseComparator = new Comparator<ByteBuffer>(){

        @Override
        public int compare(ByteBuffer o1, ByteBuffer o2) {
            if (o1.remaining() == 0) {
                return o2.remaining() == 0 ? 0 : -1;
            }
            if (o2.remaining() == 0) {
                return 1;
            }
            return -AbstractType.this.compare(o1, o2);
        }
    };

    protected AbstractType() {
    }

    public abstract T compose(ByteBuffer var1);

    public abstract ByteBuffer decompose(T var1);

    public abstract String toString(T var1);

    public abstract String getString(ByteBuffer var1);

    public ByteBuffer fromString(String source) throws MarshalException {
        throw new UnsupportedOperationException();
    }

    public abstract void validate(ByteBuffer var1) throws MarshalException;

    public Comparator<ByteBuffer> getReverseComparator() {
        return this.reverseComparator;
    }

    public String getString(Collection<ByteBuffer> names) {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer name : names) {
            builder.append(this.getString(name)).append(",");
        }
        return builder.toString();
    }

    public String getColumnsString(Collection<IColumn> columns) {
        StringBuilder builder = new StringBuilder();
        for (IColumn column : columns) {
            builder.append(column.getString(this)).append(",");
        }
        return builder.toString();
    }

    public boolean isCommutative() {
        return false;
    }

    public abstract Class<T> getType();
}

