/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.CompactionManager;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.HintedHandOffManagerMBean;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.ArrayUtils;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintedHandOffManager
implements HintedHandOffManagerMBean {
    public static final HintedHandOffManager instance = new HintedHandOffManager();
    public static final String HINTS_CF = "HintsColumnFamily";
    private static final Logger logger_ = LoggerFactory.getLogger(HintedHandOffManager.class);
    private static final int PAGE_SIZE = 10000;
    private static final String SEPARATOR = "-";
    private static final int LARGE_NUMBER = 65536;
    private final NonBlockingHashSet<InetAddress> queuedDeliveries = new NonBlockingHashSet();
    private final ExecutorService executor_ = new JMXEnabledThreadPoolExecutor("HintedHandoff", DatabaseDescriptor.getCompactionThreadPriority());

    public HintedHandOffManager() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.db:type=HintedHandoffManager"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerMBean() {
        logger_.debug("Created HHOM instance, registered MBean.");
    }

    private static boolean sendMessage(InetAddress endpoint, String tableName, String cfName, ByteBuffer key) throws IOException {
        QueryFilter filter;
        ColumnFamily cf;
        if (!Gossiper.instance.isKnownEndpoint(endpoint)) {
            logger_.warn("Hints found for endpoint " + endpoint + " which is not part of the gossip network.  discarding.");
            return true;
        }
        if (!FailureDetector.instance.isAlive(endpoint)) {
            return false;
        }
        Table table = Table.open(tableName);
        DecoratedKey dkey = StorageService.getPartitioner().decorateKey(key);
        ColumnFamilyStore cfs = table.getColumnFamilyStore(cfName);
        ByteBuffer startColumn = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        while (!HintedHandOffManager.pagingFinished(cf = cfs.getColumnFamily(filter = QueryFilter.getSliceFilter(dkey, new QueryPath(cfs.getColumnFamilyName()), startColumn, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 10000)), startColumn)) {
            if (cf.getColumnNames().isEmpty()) {
                logger_.debug("Nothing to hand off for {}", dkey);
                break;
            }
            startColumn = cf.getColumnNames().last();
            RowMutation rm = new RowMutation(tableName, key);
            rm.add(cf);
            IWriteResponseHandler responseHandler = WriteResponseHandler.create(endpoint);
            MessagingService.instance().sendRR(rm, endpoint, responseHandler);
            try {
                responseHandler.get();
            }
            catch (TimeoutException e) {
                return false;
            }
            try {
                Thread.sleep(DatabaseDescriptor.getHintedHandoffThrottleDelay());
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }
        return true;
    }

    private static void deleteHintKey(ByteBuffer endpointAddress, ByteBuffer key, ByteBuffer tableCF, long timestamp) throws IOException {
        RowMutation rm = new RowMutation("system", endpointAddress);
        rm.delete(new QueryPath(HINTS_CF, key, tableCF), timestamp);
        rm.apply();
    }

    @Override
    public void deleteHintsForEndpoint(String ipOrHostname) {
        try {
            InetAddress endpoint = InetAddress.getByName(ipOrHostname);
            this.deleteHintsForEndpoint(endpoint);
        }
        catch (UnknownHostException e) {
            logger_.warn("Unable to find " + ipOrHostname + ", not a hostname or ipaddr of a node?:");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void deleteHintsForEndpoint(InetAddress endpoint) {
        final String ipaddr = endpoint.getHostAddress();
        final ColumnFamilyStore hintStore = Table.open("system").getColumnFamilyStore(HINTS_CF);
        final RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes(ipaddr));
        rm.delete(new QueryPath(HINTS_CF), System.currentTimeMillis());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    logger_.info("Deleting any stored hints for " + ipaddr);
                    rm.apply();
                    hintStore.forceFlush();
                    CompactionManager.instance.submitMajor(hintStore, 0L, Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    logger_.warn("Could not delete hints for " + ipaddr + ": " + e);
                }
            }
        };
        StorageService.scheduledTasks.execute(runnable);
    }

    private static boolean pagingFinished(ColumnFamily hintColumnFamily, ByteBuffer startColumn) {
        return hintColumnFamily == null || hintColumnFamily.getSortedColumns().size() == 1 && hintColumnFamily.getColumn(startColumn) != null;
    }

    public static ByteBuffer makeCombinedName(String tableName, String columnFamily) {
        byte[] withsep = ArrayUtils.addAll((byte[])tableName.getBytes(Charsets.UTF_8), (byte[])SEPARATOR.getBytes(Charsets.UTF_8));
        return ByteBuffer.wrap(ArrayUtils.addAll((byte[])withsep, (byte[])columnFamily.getBytes(Charsets.UTF_8)));
    }

    private static String[] getTableAndCFNames(ByteBuffer joined) {
        int index = ByteBufferUtil.lastIndexOf(joined, SEPARATOR.getBytes(Charsets.UTF_8)[0], joined.limit());
        if (index == -1 || index < joined.position() + 1) {
            throw new RuntimeException("Corrupted hint name " + ByteBufferUtil.bytesToHex(joined));
        }
        try {
            return new String[]{ByteBufferUtil.string(joined, joined.position(), index - joined.position()), ByteBufferUtil.string(joined, index + 1, joined.limit() - (index + 1))};
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    private int waitForSchemaAgreement(InetAddress endpoint) throws InterruptedException {
        Gossiper gossiper = Gossiper.instance;
        int waited = 0;
        while (gossiper.getEndpointStateForEndpoint(endpoint).getApplicationState(ApplicationState.SCHEMA) == null) {
            Thread.sleep(1000L);
            if ((waited += 1000) <= 60000) continue;
            throw new RuntimeException("Didin't receive gossiped schema from " + endpoint + " in " + 60000 + "ms");
        }
        waited = 0;
        while (!gossiper.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.SCHEMA).value.equals(gossiper.getEndpointStateForEndpoint((InetAddress)FBUtilities.getLocalAddress()).getApplicationState((ApplicationState)ApplicationState.SCHEMA).value)) {
            Thread.sleep(1000L);
            if ((waited += 1000) <= 60000) continue;
            throw new RuntimeException("Could not reach schema agreement with " + endpoint + " in " + 60000 + "ms");
        }
        logger_.debug("schema for {} matches local schema", (Object)endpoint);
        return waited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverHintsToEndpoint(InetAddress endpoint) throws IOException, DigestMismatchException, InvalidRequestException, TimeoutException, InterruptedException {
        QueryFilter filter;
        ColumnFamily hintColumnFamily;
        try {
            logger_.debug("Checking remote schema before delivering hints");
            int waited = this.waitForSchemaAgreement(endpoint);
            if (waited == 0) {
                int sleep = new Random().nextInt(60000);
                logger_.debug("Sleeping {}ms to stagger hint delivery", (Object)sleep);
                Thread.sleep(sleep);
            }
            if (!Gossiper.instance.getEndpointStateForEndpoint(endpoint).isAlive()) {
                logger_.info("Endpoint {} died before hint delivery, aborting", (Object)endpoint);
                return;
            }
        }
        finally {
            this.queuedDeliveries.remove((Object)endpoint);
        }
        logger_.info("Started hinted handoff for endpoint " + endpoint);
        ByteBuffer endpointAsUTF8 = ByteBufferUtil.bytes(endpoint.getHostAddress());
        DecoratedKey epkey = StorageService.getPartitioner().decorateKey(endpointAsUTF8);
        int rowsReplayed = 0;
        ColumnFamilyStore hintStore = Table.open("system").getColumnFamilyStore(HINTS_CF);
        ByteBuffer startColumn = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        block5: while (!HintedHandOffManager.pagingFinished(hintColumnFamily = ColumnFamilyStore.removeDeleted(hintStore.getColumnFamily(filter = QueryFilter.getSliceFilter(epkey, new QueryPath(HINTS_CF), startColumn, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 10000)), Integer.MAX_VALUE), startColumn)) {
            for (IColumn keyColumn : hintColumnFamily.getSortedColumns()) {
                startColumn = keyColumn.name();
                Collection<IColumn> tableCFs = keyColumn.getSubColumns();
                for (IColumn tableCF : tableCFs) {
                    String[] parts = HintedHandOffManager.getTableAndCFNames(tableCF.name());
                    if (HintedHandOffManager.sendMessage(endpoint, parts[0], parts[1], keyColumn.name())) {
                        HintedHandOffManager.deleteHintKey(endpointAsUTF8, keyColumn.name(), tableCF.name(), tableCF.timestamp());
                        ++rowsReplayed;
                    } else {
                        logger_.info("Could not complete hinted handoff to " + endpoint);
                        break block5;
                    }
                    startColumn = keyColumn.name();
                }
            }
        }
        if (rowsReplayed > 0) {
            hintStore.forceFlush();
            try {
                CompactionManager.instance.submitMajor(hintStore, 0L, Integer.MAX_VALUE).get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger_.info(String.format("Finished hinted handoff of %s rows to endpoint %s", rowsReplayed, endpoint));
    }

    public static void renameHints(String oldTable, String newTable) throws IOException {
        QueryFilter filter;
        ColumnFamily cf;
        DecoratedKey oldTableKey = StorageService.getPartitioner().decorateKey(ByteBufferUtil.bytes(oldTable));
        ColumnFamilyStore hintStore = Table.open("system").getColumnFamilyStore(HINTS_CF);
        ByteBuffer startCol = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        long now = System.currentTimeMillis();
        while (!HintedHandOffManager.pagingFinished(cf = ColumnFamilyStore.removeDeleted(hintStore.getColumnFamily(filter = QueryFilter.getSliceFilter(oldTableKey, new QueryPath(HINTS_CF), startCol, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 10000)), Integer.MAX_VALUE), startCol)) {
            if (newTable != null) {
                RowMutation insert = new RowMutation("system", ByteBufferUtil.bytes(newTable));
                insert.add(cf);
                insert.apply();
            }
            RowMutation drop = new RowMutation("system", oldTableKey.key);
            for (ByteBuffer key : cf.getColumnNames()) {
                drop.delete(new QueryPath(HINTS_CF, key), now);
                startCol = key;
            }
            drop.apply();
        }
    }

    public void deliverHints(final InetAddress to) {
        if (!this.queuedDeliveries.add((Object)to)) {
            return;
        }
        WrappedRunnable r = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                HintedHandOffManager.this.deliverHintsToEndpoint(to);
            }
        };
        this.executor_.execute(r);
    }

    public void deliverHints(String to) throws UnknownHostException {
        this.deliverHints(InetAddress.getByName(to));
    }

    @Override
    public List<String> listEndpointsPendingHints() {
        List<Row> rows = this.getHintsSlice(1);
        LinkedList<String> result = new LinkedList<String>();
        for (Row r : rows) {
            if (r.cf == null) continue;
            result.addFirst(new String(r.key.key.array()));
        }
        return result;
    }

    @Override
    public Map<String, Integer> countPendingHints() {
        List<Row> rows = this.getHintsSlice(Integer.MAX_VALUE);
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Row r : rows) {
            if (r.cf == null) continue;
            result.put(new String(r.key.key.array()), r.cf.getColumnCount());
        }
        return result;
    }

    private List<Row> getHintsSlice(int column_count) {
        List<Row> rows;
        ColumnParent parent = new ColumnParent(HINTS_CF);
        SlicePredicate predicate = new SlicePredicate();
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(new byte[0]).setFinish(new byte[0]);
        sliceRange.setCount(column_count);
        predicate.setSlice_range(sliceRange);
        IPartitioner partitioner = StorageService.getPartitioner();
        ByteBuffer empty = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        Range range = new Range((Token)partitioner.getToken(empty), (Token)partitioner.getToken(empty));
        try {
            rows = StorageProxy.getRangeSlice(new RangeSliceCommand("system", parent, predicate, range, 65536), ConsistencyLevel.ONE);
        }
        catch (Exception e) {
            logger_.info("HintsCF getEPPendingHints timed out.");
            throw new RuntimeException(e);
        }
        return rows;
    }
}

