/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.cql.jdbc.ColumnDecoder;
import org.apache.cassandra.cql.jdbc.Utils;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.Compression;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection {
    private static final Pattern KeyspacePattern = Pattern.compile("USE (\\w+);?", 10);
    private static final Pattern SelectPattern = Pattern.compile("(?:SELECT|DELETE)\\s+.+\\s+FROM\\s+(\\w+).*", 10);
    private static final Pattern UpdatePatter = Pattern.compile("UPDATE\\s+(\\w+)\\s+.*", 2);
    public static Compression defaultCompression = Compression.GZIP;
    public final String hostName;
    public final int portNo;
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    protected long timeOfLastFailure = 0L;
    protected int numFailures = 0;
    private Cassandra.Client client;
    private TTransport transport;
    public String curKeyspace;
    public String curColumnFamily;
    public ColumnDecoder decoder;

    public Connection(String hostName, int portNo) throws TTransportException {
        this.hostName = hostName;
        this.portNo = portNo;
        TSocket socket = new TSocket(hostName, portNo);
        this.transport = new TFramedTransport((TTransport)socket);
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new Cassandra.Client((TProtocol)protocol);
        socket.open();
        logger.info("Connected to {}:{}", (Object)hostName, (Object)portNo);
    }

    public Connection(String hostName, int portNo, String userName, String password) throws AuthenticationException, AuthorizationException, TException {
        this(hostName, portNo);
        HashMap credentials = new HashMap();
        AuthenticationRequest areq = new AuthenticationRequest(credentials);
        this.client.login(areq);
    }

    public CqlResult execute(String queryStr) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        return this.execute(queryStr, defaultCompression);
    }

    public CqlResult execute(String queryStr, Compression compress) throws InvalidRequestException, UnavailableException, TimedOutException, SchemaDisagreementException, TException {
        if (this.decoder == null) {
            this.decoder = new ColumnDecoder(this.client.describe_keyspaces());
        }
        this.curKeyspace = this.getKeyspace(queryStr);
        this.curColumnFamily = this.getColumnFamily(queryStr);
        try {
            return this.client.execute_cql_query(Utils.compressQuery(queryStr, compress), compress);
        }
        catch (TException error) {
            ++this.numFailures;
            this.timeOfLastFailure = System.currentTimeMillis();
            throw error;
        }
    }

    String getKeyspace(String query) {
        String ks = this.curKeyspace;
        Matcher isKeyspace = KeyspacePattern.matcher(query);
        if (isKeyspace.matches()) {
            ks = isKeyspace.group(1);
        }
        return ks;
    }

    String getColumnFamily(String query) {
        Matcher isUpdate;
        String cf = this.curColumnFamily;
        Matcher isSelect = SelectPattern.matcher(query);
        if (isSelect.matches()) {
            cf = isSelect.group(1);
        }
        if ((isUpdate = UpdatePatter.matcher(query)).matches()) {
            cf = isUpdate.group(1);
        }
        return cf;
    }

    public void close() {
        this.transport.close();
    }

    public boolean isOpen() {
        return this.transport.isOpen();
    }

    class QueryMetadata {
        public final String keyspace;
        public final String columnFamily;

        QueryMetadata(String keyspace, String columnFamily) {
            this.keyspace = keyspace;
            this.columnFamily = columnFamily;
        }
    }
}

