/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.apache.cassandra.cql.jdbc.CassandraResultSetMetaData;
import org.apache.cassandra.cql.jdbc.ColumnDecoder;
import org.apache.cassandra.cql.jdbc.ColumnMetaData;
import org.apache.cassandra.cql.jdbc.TypedColumn;
import org.apache.cassandra.cql.jdbc.Utils;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.thrift.Column;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlRow;

class CassandraResultSet
implements ResultSet {
    private final CqlResult rSet;
    private final ColumnDecoder decoder;
    private final String keyspace;
    private final String columnFamily;
    private Iterator<CqlRow> rSetIter;
    private byte[] curRowKey = null;
    private List<TypedColumn> values = new ArrayList<TypedColumn>();
    private Map<String, Object> valueMap = new WeakHashMap<String, Object>();
    private final RsMetaData meta;
    private final AbstractType nameType;
    private boolean wasNull;

    CassandraResultSet(CqlResult resultSet, ColumnDecoder decoder, String keyspace, String columnFamily) {
        this.rSet = resultSet;
        this.decoder = decoder;
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.rSetIter = this.rSet.getRowsIterator();
        this.meta = new RsMetaData();
        this.nameType = decoder.getComparator(keyspace, columnFamily, ColumnDecoder.Specifier.Comparator, null);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public boolean absolute(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void close() throws SQLException {
        this.valueMap.clear();
        this.values.clear();
        this.valueMap = null;
        this.values = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int findColumn(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean first() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Array getArray(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Array getArray(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Blob getBlob(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Blob getBlob(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean getBoolean(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean getBoolean(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public byte getByte(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public byte getByte(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public byte[] getBytes(int index) throws SQLException {
        TypedColumn column = this.values.get(index - 1);
        assert (column != null);
        Object value = column.getValue();
        this.wasNull = value == null;
        return value == null ? null : ((ByteBuffer)value).array();
    }

    @Override
    public byte[] getBytes(String name) throws SQLException {
        String nameAsString = this.decoder.colNameAsString(this.keyspace, this.columnFamily, name);
        Object value = this.valueMap.get(nameAsString);
        this.wasNull = value == null;
        return value == null ? null : ((ByteBuffer)value).array();
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Clob getClob(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Clob getClob(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Date getDate(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Date getDate(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public double getDouble(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public double getDouble(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public float getFloat(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public float getFloat(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getInt(int index) throws SQLException {
        TypedColumn column = this.values.get(index - 1);
        assert (column != null);
        Object value = column.getValue();
        this.wasNull = value == null;
        return value == null ? 0 : ((BigInteger)value).intValue();
    }

    @Override
    public int getInt(String name) throws SQLException {
        String nameAsString = this.decoder.colNameAsString(this.keyspace, this.columnFamily, name);
        Object value = this.valueMap.get(nameAsString);
        this.wasNull = value == null;
        return value == null ? 0 : ((BigInteger)value).intValue();
    }

    @Override
    public long getLong(int index) throws SQLException {
        assert (this.values != null);
        TypedColumn column = this.values.get(index - 1);
        assert (column != null);
        Object value = column.getValue();
        this.wasNull = value == null;
        return value == null ? 0L : (Long)value;
    }

    @Override
    public long getLong(String name) throws SQLException {
        String nameAsString = this.decoder.colNameAsString(this.keyspace, this.columnFamily, name);
        Object value = this.valueMap.get(nameAsString);
        this.wasNull = value == null;
        return value == null ? 0L : (Long)value;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.meta;
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Object getObject(int index) throws SQLException {
        TypedColumn column = this.values.get(index - 1);
        assert (column != null);
        Object value = column.getValue();
        this.wasNull = value == null;
        return value;
    }

    @Override
    public Object getObject(String name) throws SQLException {
        String nameAsString = this.decoder.colNameAsString(this.keyspace, this.columnFamily, name);
        Object value = this.valueMap.get(nameAsString);
        this.wasNull = value == null;
        return value;
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Ref getRef(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Ref getRef(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getRow() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public short getShort(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public short getShort(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public String getString(int index) throws SQLException {
        TypedColumn column = this.values.get(index - 1);
        assert (column != null);
        Object value = column.getValue();
        this.wasNull = value == null;
        return value == null ? null : ColumnDecoder.colValueAsString(value);
    }

    @Override
    public String getString(String name) throws SQLException {
        String nameAsString = this.decoder.colNameAsString(this.keyspace, this.columnFamily, name);
        Object value = this.valueMap.get(nameAsString);
        this.wasNull = value == null;
        return value == null ? null : ColumnDecoder.colValueAsString(value);
    }

    @Override
    public Time getTime(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Time getTime(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public int getType() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean last() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Unsupported unwrap interface: " + iface.getSimpleName());
    }

    @Override
    public synchronized boolean next() throws SQLException {
        if (!this.values.isEmpty() || !this.valueMap.isEmpty()) {
            this.values.clear();
            this.valueMap.clear();
        }
        if (this.rSetIter != null && this.rSetIter.hasNext()) {
            CqlRow row = this.rSetIter.next();
            this.curRowKey = row.getKey();
            List cols = row.getColumns();
            for (Column col : cols) {
                byte[] name = col.getName();
                byte[] value = col.getValue();
                TypedColumn c = this.decoder.makeCol(this.keyspace, this.columnFamily, name, value);
                this.values.add(c);
                this.valueMap.put(this.decoder.colNameAsString(this.keyspace, this.columnFamily, name), c.getValue());
            }
            return !this.values.isEmpty() || !this.valueMap.isEmpty();
        }
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateByte(int arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateByte(String arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateClob(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateDate(int arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateDate(String arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateDouble(int arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateDouble(String arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateFloat(int arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateFloat(String arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateInt(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateInt(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateLong(int arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateLong(String arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNString(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNull(int arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateNull(String arg0) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateObject(int arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateObject(String arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateShort(int arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateShort(String arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateString(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateTime(int arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateTime(String arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    private class RsMetaData
    implements CassandraResultSetMetaData,
    ResultSetMetaData {
        private RsMetaData() {
        }

        @Override
        public byte[] getKey() {
            return CassandraResultSet.this.curRowKey;
        }

        @Override
        public boolean isNameCaseSensitive(int column) throws SQLException {
            this.checkIndex(--column);
            if (CassandraResultSet.this.nameType instanceof ColumnMetaData) {
                return ((ColumnMetaData)((Object)CassandraResultSet.this.nameType)).isCaseSensitive();
            }
            return CassandraResultSet.this.nameType.getType().equals(String.class);
        }

        @Override
        public boolean isValueCaseSensitive(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn tc = (TypedColumn)CassandraResultSet.this.values.get(column);
            if (tc.getValidator() instanceof ColumnMetaData) {
                return ((ColumnMetaData)((Object)tc.getValidator())).isCaseSensitive();
            }
            return tc.getValidator().getType().equals(String.class);
        }

        @Override
        public boolean isNameCurrency(int column) throws SQLException {
            this.checkIndex(--column);
            if (CassandraResultSet.this.nameType instanceof ColumnMetaData) {
                return ((ColumnMetaData)((Object)CassandraResultSet.this.nameType)).isCurrency();
            }
            return false;
        }

        @Override
        public boolean isValueCurrency(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn tc = (TypedColumn)CassandraResultSet.this.values.get(column);
            if (tc.getValidator() instanceof ColumnMetaData) {
                return ((ColumnMetaData)((Object)tc.getValidator())).isCurrency();
            }
            return false;
        }

        @Override
        public boolean isNameSigned(int column) throws SQLException {
            this.checkIndex(--column);
            return Utils.isTypeSigned(CassandraResultSet.this.nameType);
        }

        @Override
        public boolean isValueSigned(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn tc = (TypedColumn)CassandraResultSet.this.values.get(column);
            return Utils.isTypeSigned(tc.getValidator());
        }

        @Override
        public int getNameDisplaySize(int column) throws SQLException {
            return this.getColumnName(column).length();
        }

        @Override
        public int getValueDisplaySize(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column)).getValueString().length();
        }

        @Override
        public int getNamePrecision(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn col = (TypedColumn)CassandraResultSet.this.values.get(column);
            if (CassandraResultSet.this.nameType instanceof ColumnMetaData) {
                return ((ColumnMetaData)((Object)CassandraResultSet.this.nameType)).getPrecision();
            }
            if (CassandraResultSet.this.nameType.getType().equals(String.class)) {
                return col.getNameString().length();
            }
            if (CassandraResultSet.this.nameType == BytesType.instance) {
                return col.getNameString().length();
            }
            if (CassandraResultSet.this.nameType.getType().equals(UUID.class)) {
                return 36;
            }
            if (CassandraResultSet.this.nameType == LongType.instance) {
                return 19;
            }
            return 0;
        }

        @Override
        public int getValuePrecision(int column) throws SQLException {
            this.checkIndex(--column);
            TypedColumn col = (TypedColumn)CassandraResultSet.this.values.get(column);
            if (col.getValidator() instanceof ColumnMetaData) {
                return ((ColumnMetaData)((Object)col.getValidator())).getPrecision();
            }
            if (col.getValidator().getType().equals(String.class)) {
                return col.getValueString().length();
            }
            if (col.getValidator() == BytesType.instance) {
                return col.getValueString().length();
            }
            if (col.getValidator().getType().equals(UUID.class)) {
                return 36;
            }
            if (col.getValidator() == LongType.instance) {
                return 19;
            }
            return 0;
        }

        @Override
        public int getNameScale(int column) throws SQLException {
            this.checkIndex(--column);
            return Utils.getTypeScale(CassandraResultSet.this.nameType);
        }

        @Override
        public int getValueScale(int column) throws SQLException {
            this.checkIndex(--column);
            return Utils.getTypeScale(((TypedColumn)CassandraResultSet.this.values.get(column)).getValidator());
        }

        @Override
        public int getNameType(int column) throws SQLException {
            this.checkIndex(--column);
            return Utils.getJdbcType(CassandraResultSet.this.nameType);
        }

        @Override
        public int getValueType(int column) throws SQLException {
            this.checkIndex(--column);
            return Utils.getJdbcType(((TypedColumn)CassandraResultSet.this.values.get(column)).getValidator());
        }

        @Override
        public String getNameTypeName(int column) throws SQLException {
            this.checkIndex(--column);
            return CassandraResultSet.this.nameType.getClass().getSimpleName();
        }

        @Override
        public String getValueTypeName(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column)).getValidator().getClass().getSimpleName();
        }

        @Override
        public String getNameClassName(int column) throws SQLException {
            this.checkIndex(--column);
            return CassandraResultSet.this.nameType.getType().getName();
        }

        @Override
        public String getValueClassName(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column)).getValidator().getType().getName();
        }

        private void checkIndex(int i) throws SQLException {
            if (i >= CassandraResultSet.this.values.size()) {
                throw new SQLException("Invalid column index " + i);
            }
        }

        @Override
        public int getColumnCount() throws SQLException {
            return CassandraResultSet.this.values.size();
        }

        @Override
        public boolean isAutoIncrement(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column)).getValidator() instanceof CounterColumnType;
        }

        @Override
        public boolean isCaseSensitive(int column) throws SQLException {
            return this.isValueCaseSensitive(column);
        }

        @Override
        public boolean isSearchable(int column) throws SQLException {
            return false;
        }

        @Override
        public boolean isCurrency(int column) throws SQLException {
            return this.isValueCurrency(column);
        }

        @Override
        public int isNullable(int column) throws SQLException {
            return 2;
        }

        @Override
        public boolean isSigned(int column) throws SQLException {
            return this.isValueSigned(column);
        }

        @Override
        public int getColumnDisplaySize(int column) throws SQLException {
            return this.getValueDisplaySize(column);
        }

        @Override
        public String getColumnLabel(int column) throws SQLException {
            return this.getColumnName(column);
        }

        @Override
        public String getColumnName(int column) throws SQLException {
            this.checkIndex(--column);
            return ((TypedColumn)CassandraResultSet.this.values.get(column)).getNameString();
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            return CassandraResultSet.this.keyspace;
        }

        @Override
        public int getPrecision(int column) throws SQLException {
            return this.getValuePrecision(column);
        }

        @Override
        public int getScale(int column) throws SQLException {
            return this.getValueScale(column);
        }

        @Override
        public String getTableName(int column) throws SQLException {
            return CassandraResultSet.this.columnFamily;
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            throw new SQLFeatureNotSupportedException("Cassandra has no catalogs");
        }

        @Override
        public int getColumnType(int column) throws SQLException {
            return this.getValueType(column);
        }

        @Override
        public String getColumnTypeName(int column) throws SQLException {
            return this.getValueTypeName(column);
        }

        @Override
        public boolean isReadOnly(int column) throws SQLException {
            return column == 0;
        }

        @Override
        public boolean isWritable(int column) throws SQLException {
            return column > 0;
        }

        @Override
        public boolean isDefinitelyWritable(int column) throws SQLException {
            return this.isWritable(column);
        }

        @Override
        public String getColumnClassName(int column) throws SQLException {
            return this.getValueClassName(column);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            if (iface.equals(CassandraResultSetMetaData.class)) {
                return (T)this;
            }
            throw new SQLFeatureNotSupportedException("No wrappers");
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return CassandraResultSetMetaData.class.isAssignableFrom(iface);
        }
    }
}

