/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.cassandra.cache.JMXInstrumentedCache;
import org.apache.cassandra.io.ICompactionInfo;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheWriter<K, V>
implements ICompactionInfo {
    private static final Logger logger = LoggerFactory.getLogger(CacheWriter.class);
    private final File path;
    private final Function<K, ByteBuffer> converter;
    private final Set<K> keys;
    private final String columnFamily;
    private final long estimatedTotalBytes;
    private long bytesWritten;

    public CacheWriter(String columnFamily, JMXInstrumentedCache<K, V> cache, File path, Function<K, ByteBuffer> converter) {
        this.columnFamily = columnFamily;
        this.path = path;
        this.converter = converter;
        this.keys = cache.getKeySet();
        long bytes = 0L;
        for (K key : this.keys) {
            bytes += (long)((ByteBuffer)converter.apply(key)).remaining();
        }
        this.estimatedTotalBytes = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCache() throws IOException {
        long start = System.currentTimeMillis();
        if (this.keys.size() == 0 || this.estimatedTotalBytes == 0L) {
            logger.debug("Deleting {} (cache is empty)");
            this.path.delete();
            return;
        }
        logger.debug("Saving {}", (Object)this.path);
        File tmpFile = File.createTempFile(this.path.getName(), null, this.path.getParentFile());
        BufferedRandomAccessFile out = new BufferedRandomAccessFile(tmpFile, "rw", 65535, true);
        try {
            for (K key : this.keys) {
                ByteBuffer bytes = (ByteBuffer)this.converter.apply(key);
                ByteBufferUtil.writeWithLength(bytes, out);
                this.bytesWritten += (long)bytes.remaining();
            }
        }
        finally {
            out.close();
        }
        this.path.delete();
        if (!tmpFile.renameTo(this.path)) {
            throw new IOException("Unable to rename " + tmpFile + " to " + this.path);
        }
        logger.info(String.format("Saved %s (%d items) in %d ms", this.path.getName(), this.keys.size(), System.currentTimeMillis() - start));
    }

    @Override
    public long getTotalBytes() {
        return Math.max(this.estimatedTotalBytes, this.getBytesComplete());
    }

    @Override
    public long getBytesComplete() {
        return this.bytesWritten;
    }

    @Override
    public String getTaskType() {
        return "Save " + this.path.getName();
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }
}

