/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

@Deprecated
public class RenameColumnFamily
extends Migration {
    private String tableName;
    private String oldName;
    private String newName;
    private Integer cfId;

    protected RenameColumnFamily() {
    }

    public RenameColumnFamily(String tableName, String oldName, String newName) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        this.tableName = tableName;
        this.oldName = oldName;
        this.newName = newName;
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(tableName);
        if (ksm == null) {
            throw new ConfigurationException("Keyspace does not already exist.");
        }
        if (!ksm.cfMetaData().containsKey(oldName)) {
            throw new ConfigurationException("CF is not defined in that keyspace.");
        }
        if (ksm.cfMetaData().containsKey(newName)) {
            throw new ConfigurationException("CF is already defined in that keyspace.");
        }
        if (!Migration.isLegalName(newName)) {
            throw new ConfigurationException("Invalid column family name: " + newName);
        }
        this.cfId = ksm.cfMetaData().get((Object)oldName).cfId;
        KSMetaData newKsm = this.makeNewKeyspaceDefinition(ksm);
        this.rm = Migration.makeDefinitionMutation(newKsm, null, this.newVersion);
    }

    private KSMetaData makeNewKeyspaceDefinition(KSMetaData ksm) {
        CFMetaData oldCfm = ksm.cfMetaData().get(this.oldName);
        ArrayList<CFMetaData> newCfs = new ArrayList<CFMetaData>(ksm.cfMetaData().values());
        newCfs.remove(oldCfm);
        assert (newCfs.size() == ksm.cfMetaData().size() - 1);
        CFMetaData newCfm = CFMetaData.rename(oldCfm, this.newName);
        newCfs.add(newCfm);
        return new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.replicationFactor, newCfs.toArray(new CFMetaData[newCfs.size()]));
    }

    @Override
    public void applyModels() throws IOException {
        KSMetaData oldKsm = DatabaseDescriptor.getTableDefinition(this.tableName);
        CFMetaData.purge(oldKsm.cfMetaData().get(this.oldName));
        KSMetaData ksm = this.makeNewKeyspaceDefinition(DatabaseDescriptor.getTableDefinition(this.tableName));
        try {
            CFMetaData.map(ksm.cfMetaData().get(this.newName));
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        DatabaseDescriptor.setTableDefinition(ksm, this.newVersion);
        if (!this.clientMode) {
            Table.open(ksm.name).renameCf(this.cfId, this.newName);
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.RenameColumnFamily rcf = new org.apache.cassandra.db.migration.avro.RenameColumnFamily();
        rcf.ksname = new Utf8(this.tableName);
        rcf.cfid = this.cfId;
        rcf.old_cfname = new Utf8(this.oldName);
        rcf.new_cfname = new Utf8(this.newName);
        mi.migration = rcf;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.RenameColumnFamily rcf = (org.apache.cassandra.db.migration.avro.RenameColumnFamily)((Object)mi.migration);
        this.tableName = ((Object)rcf.ksname).toString();
        this.cfId = rcf.cfid;
        this.oldName = ((Object)rcf.old_cfname).toString();
        this.newName = ((Object)rcf.new_cfname).toString();
    }

    public String toString() {
        return String.format("Rename column family (%d) %s.%s to %s.%s", this.cfId, this.tableName, this.oldName, this.tableName, this.newName);
    }
}

