/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;

public class LocalPartitioner
implements IPartitioner<LocalToken> {
    private final AbstractType comparator;

    public LocalPartitioner(AbstractType comparator) {
        this.comparator = comparator;
    }

    @Override
    public DecoratedKey<LocalToken> convertFromDiskFormat(ByteBuffer key) {
        return this.decorateKey(key);
    }

    @Override
    public DecoratedKey<LocalToken> decorateKey(ByteBuffer key) {
        return new DecoratedKey<LocalToken>(this.getToken(key), key);
    }

    @Override
    public Token midpoint(Token left, Token right) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LocalToken getMinimumToken() {
        return new LocalToken(this.comparator, ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public LocalToken getToken(ByteBuffer key) {
        return new LocalToken(this.comparator, key);
    }

    @Override
    public LocalToken getRandomToken() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Token.TokenFactory getTokenFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public Map<Token, Float> describeOwnership(List<Token> sortedTokens) {
        return Collections.singletonMap(this.getMinimumToken(), new Float(1.0));
    }
}

