/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import org.apache.cassandra.db.commitlog.CommitLogSegment;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.util.FileUtils;

public class CommitLogHeader {
    public static CommitLogHeaderSerializer serializer = new CommitLogHeaderSerializer();
    private Map<Integer, Integer> cfDirtiedAt;

    public static String getHeaderPathFromSegment(CommitLogSegment segment) {
        return CommitLogHeader.getHeaderPathFromSegmentPath(segment.getPath());
    }

    public static String getHeaderPathFromSegmentPath(String segmentPath) {
        return segmentPath + ".header";
    }

    CommitLogHeader() {
        this(new HashMap<Integer, Integer>());
    }

    private CommitLogHeader(Map<Integer, Integer> cfDirtiedAt) {
        this.cfDirtiedAt = cfDirtiedAt;
    }

    boolean isDirty(Integer cfId) {
        return this.cfDirtiedAt.containsKey(cfId);
    }

    int getPosition(Integer cfId) {
        Integer x = this.cfDirtiedAt.get(cfId);
        return x == null ? 0 : x;
    }

    void turnOn(Integer cfId, long position) {
        assert (position >= 0L && position <= Integer.MAX_VALUE);
        this.cfDirtiedAt.put(cfId, (int)position);
    }

    void turnOff(Integer cfId) {
        this.cfDirtiedAt.remove(cfId);
    }

    boolean isSafeToDelete() throws IOException {
        return this.cfDirtiedAt.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("");
        sb.append("CLH(dirty+flushed={");
        for (Map.Entry<Integer, Integer> entry : this.cfDirtiedAt.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        sb.append("})");
        return sb.toString();
    }

    public String dirtyString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Integer, Integer> entry : this.cfDirtiedAt.entrySet()) {
            sb.append(entry.getKey()).append(", ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeCommitLogHeader(CommitLogHeader header, String headerFile) throws IOException {
        FilterOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(headerFile));
            serializer.serialize(header, (DataOutput)((Object)out));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CommitLogHeader readCommitLogHeader(String headerFile) throws IOException {
        CommitLogHeader commitLogHeader;
        DataInputStream reader = null;
        try {
            reader = new DataInputStream(new BufferedInputStream(new FileInputStream(headerFile)));
            commitLogHeader = serializer.deserialize(reader);
        }
        catch (Throwable throwable) {
            FileUtils.closeQuietly(reader);
            throw throwable;
        }
        FileUtils.closeQuietly(reader);
        return commitLogHeader;
    }

    int getReplayPosition() {
        return this.cfDirtiedAt.isEmpty() ? -1 : Collections.min(this.cfDirtiedAt.values());
    }

    static class CommitLogHeaderSerializer
    implements ICompactSerializer2<CommitLogHeader> {
        CommitLogHeaderSerializer() {
        }

        @Override
        public void serialize(CommitLogHeader clHeader, DataOutput dos) throws IOException {
            CRC32 checksum = new CRC32();
            dos.writeInt(clHeader.cfDirtiedAt.size());
            checksum.update(clHeader.cfDirtiedAt.size());
            dos.writeLong(checksum.getValue());
            for (Map.Entry entry : clHeader.cfDirtiedAt.entrySet()) {
                dos.writeInt((Integer)entry.getKey());
                checksum.update((Integer)entry.getKey());
                dos.writeInt((Integer)entry.getValue());
                checksum.update((Integer)entry.getValue());
            }
            dos.writeLong(checksum.getValue());
        }

        @Override
        public CommitLogHeader deserialize(DataInput dis) throws IOException {
            CRC32 checksum = new CRC32();
            int lastFlushedAtSize = dis.readInt();
            checksum.update(lastFlushedAtSize);
            if (checksum.getValue() != dis.readLong()) {
                throw new IOException("Invalid or corrupt commitlog header");
            }
            HashMap<Integer, Integer> lastFlushedAt = new HashMap<Integer, Integer>();
            for (int i = 0; i < lastFlushedAtSize; ++i) {
                int key = dis.readInt();
                checksum.update(key);
                int value = dis.readInt();
                checksum.update(value);
                lastFlushedAt.put(key, value);
            }
            if (checksum.getValue() != dis.readLong()) {
                throw new IOException("Invalid or corrupt commitlog header");
            }
            return new CommitLogHeader(lastFlushedAt);
        }
    }
}

