/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.BufferedRandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableIdentityIterator
implements Comparable<SSTableIdentityIterator>,
IColumnIterator {
    private static final Logger logger = LoggerFactory.getLogger(SSTableIdentityIterator.class);
    private final DecoratedKey key;
    private final long finishedAt;
    private final BufferedRandomAccessFile file;
    public final SSTableReader sstable;
    private final long dataStart;
    public final long dataSize;
    private final ColumnFamily columnFamily;
    public final int columnCount;
    private final long columnPosition;
    private final int expireBefore;
    private final boolean validateColumns;

    public SSTableIdentityIterator(SSTableReader sstable, BufferedRandomAccessFile file, DecoratedKey key, long dataStart, long dataSize) throws IOException {
        this(sstable, file, key, dataStart, dataSize, false);
    }

    public SSTableIdentityIterator(SSTableReader sstable, BufferedRandomAccessFile file, DecoratedKey key, long dataStart, long dataSize, boolean checkData) throws IOException {
        this.sstable = sstable;
        this.file = file;
        this.key = key;
        this.dataStart = dataStart;
        this.dataSize = dataSize;
        this.expireBefore = (int)(System.currentTimeMillis() / 1000L);
        this.validateColumns = checkData;
        this.finishedAt = dataStart + dataSize;
        try {
            file.seek(this.dataStart);
            if (checkData) {
                try {
                    IndexHelper.defreezeBloomFilter(file, dataSize, sstable.descriptor.usesOldBloomFilter);
                }
                catch (Exception e) {
                    if (e instanceof EOFException) {
                        throw (EOFException)e;
                    }
                    logger.debug("Invalid bloom filter in {}; will rebuild it", (Object)sstable);
                }
                try {
                    IndexHelper.deserializeIndex(file);
                }
                catch (Exception e) {
                    logger.debug("Invalid row summary in {}; will rebuild it", (Object)sstable);
                }
                file.seek(this.dataStart);
            }
            IndexHelper.skipBloomFilter(file);
            IndexHelper.skipIndex(file);
            this.columnFamily = sstable.createColumnFamily();
            ColumnFamily.serializer().deserializeFromSSTableNoColumns(this.columnFamily, file);
            this.columnCount = file.readInt();
            this.columnPosition = file.getFilePointer();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public boolean hasNext() {
        return this.file.getFilePointer() < this.finishedAt;
    }

    @Override
    public IColumn next() {
        try {
            IColumn column = this.sstable.getColumnSerializer().deserialize(this.file, this.expireBefore);
            if (this.validateColumns) {
                column.validateFields(this.sstable.metadata);
            }
            return column;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        catch (MarshalException e) {
            throw new IOError(new IOException("Error validating row " + this.key, e));
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
    }

    public String getPath() {
        return this.file.getPath();
    }

    public void echoData(DataOutput out) throws IOException {
        this.file.seek(this.dataStart);
        while (this.file.getFilePointer() < this.finishedAt) {
            out.write(this.file.readByte());
        }
    }

    public ColumnFamily getColumnFamilyWithColumns() throws IOException {
        this.file.seek(this.columnPosition - 4L);
        ColumnFamily cf = this.columnFamily.cloneMeShallow();
        ColumnFamily.serializer().deserializeColumns(this.file, cf);
        if (this.validateColumns) {
            try {
                cf.validateColumnFields();
            }
            catch (MarshalException e) {
                throw new IOException("Error validating row " + this.key, e);
            }
        }
        return cf;
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }

    public void reset() {
        try {
            this.file.seek(this.columnPosition);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }
}

