/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.streaming.StreamIn;
import org.apache.cassandra.streaming.StreamInSession;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingStreamReader {
    private static final Logger logger = LoggerFactory.getLogger(IncomingStreamReader.class);
    private final PendingFile localFile;
    private final PendingFile remoteFile;
    private final SocketChannel socketChannel;
    private final StreamInSession session;

    public IncomingStreamReader(StreamHeader header, SocketChannel socketChannel) throws IOException {
        this.socketChannel = socketChannel;
        InetSocketAddress remoteAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        this.session = StreamInSession.get(remoteAddress.getAddress(), header.sessionId);
        this.session.addFiles(header.pendingFiles);
        this.session.setCurrentFile(header.file);
        this.session.setTable(header.table);
        this.remoteFile = header.file;
        this.localFile = this.remoteFile != null ? StreamIn.getContextMapping(this.remoteFile) : null;
    }

    public void read() throws IOException {
        if (this.remoteFile != null) {
            this.readFile();
        }
        this.session.closeIfFinished();
    }

    private void readFile() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Receiving stream");
            logger.debug("Creating file for {}", (Object)this.localFile.getFilename());
        }
        FileOutputStream fos = new FileOutputStream(this.localFile.getFilename(), true);
        FileChannel fc = fos.getChannel();
        long offset = 0L;
        try {
            for (Pair<Long, Long> section : this.localFile.sections) {
                long length = (Long)section.right - (Long)section.left;
                long bytesRead = 0L;
                while (bytesRead < length) {
                    long toRead = Math.min(0xA00000L, length - bytesRead);
                    long lastRead = fc.transferFrom(this.socketChannel, offset + bytesRead, toRead);
                    if (lastRead == 0L) {
                        throw new IOException("Transfer failed for remote file " + this.remoteFile);
                    }
                    bytesRead += lastRead;
                    this.remoteFile.progress += lastRead;
                }
                offset += length;
            }
        }
        catch (IOException ex) {
            this.session.retry(this.remoteFile);
            FileUtils.deleteWithConfirm(new File(this.localFile.getFilename()));
            throw ex;
        }
        finally {
            fc.close();
        }
        this.session.finished(this.remoteFile, this.localFile);
    }
}

