/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.Collection;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.WriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;

public class DatacenterWriteResponseHandler
extends WriteResponseHandler {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private static final String localdc = snitch.getDatacenter(FBUtilities.getLocalAddress());

    protected DatacenterWriteResponseHandler(Collection<InetAddress> writeEndpoints, Multimap<InetAddress, InetAddress> hintedEndpoints, ConsistencyLevel consistencyLevel, String table) {
        super(writeEndpoints, hintedEndpoints, consistencyLevel, table);
        assert (consistencyLevel == ConsistencyLevel.LOCAL_QUORUM);
    }

    public static IWriteResponseHandler create(Collection<InetAddress> writeEndpoints, Multimap<InetAddress, InetAddress> hintedEndpoints, ConsistencyLevel consistencyLevel, String table) {
        return new DatacenterWriteResponseHandler(writeEndpoints, hintedEndpoints, consistencyLevel, table);
    }

    @Override
    protected int determineBlockFor(String table) {
        NetworkTopologyStrategy strategy = (NetworkTopologyStrategy)Table.open(table).getReplicationStrategy();
        return strategy.getReplicationFactor(localdc) / 2 + 1;
    }

    @Override
    public void response(Message message) {
        if ((message == null || localdc.equals(snitch.getDatacenter(message.getFrom()))) && this.responses.decrementAndGet() == 0) {
            this.condition.signal();
        }
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        int liveNodes = 0;
        for (InetAddress destination : this.hintedEndpoints.keySet()) {
            if (!localdc.equals(snitch.getDatacenter(destination)) || !this.writeEndpoints.contains(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < this.responses.get()) {
            throw new UnavailableException();
        }
    }
}

