/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Filter;
import org.apache.cassandra.utils.LegacyBloomFilter;

public class IndexHelper {
    public static void skipBloomFilter(FileDataInput in) throws IOException {
        int size = in.readInt();
        FileUtils.skipBytesFully((DataInput)in, size);
    }

    public static void skipIndex(FileDataInput file) throws IOException {
        int columnIndexSize = file.readInt();
        FileUtils.skipBytesFully((DataInput)file, columnIndexSize);
    }

    public static ArrayList<IndexInfo> deserializeIndex(FileDataInput in) throws IOException {
        int columnIndexSize = in.readInt();
        if (columnIndexSize == 0) {
            return null;
        }
        ArrayList<IndexInfo> indexList = new ArrayList<IndexInfo>();
        FileMark mark = in.mark();
        while (in.bytesPastMark(mark) < (long)columnIndexSize) {
            indexList.add(IndexInfo.deserialize(in));
        }
        assert (in.bytesPastMark(mark) == (long)columnIndexSize);
        return indexList;
    }

    public static Filter defreezeBloomFilter(FileDataInput file, boolean usesOldBloomFilter) throws IOException {
        return IndexHelper.defreezeBloomFilter(file, Integer.MAX_VALUE, usesOldBloomFilter);
    }

    public static Filter defreezeBloomFilter(FileDataInput file, long maxSize, boolean useOldBuffer) throws IOException {
        int size = file.readInt();
        if ((long)size > maxSize || size <= 0) {
            throw new EOFException("bloom filter claims to be " + size + " bytes, longer than entire row size " + maxSize);
        }
        ByteBuffer bytes = file.readBytes(size);
        DataInputStream stream = new DataInputStream(ByteBufferUtil.inputStream(bytes));
        return useOldBuffer ? (Filter)LegacyBloomFilter.serializer().deserialize(stream) : (Filter)BloomFilter.serializer().deserialize(stream);
    }

    public static int indexFor(ByteBuffer name, List<IndexInfo> indexList, AbstractType comparator, boolean reversed) {
        if (name.remaining() == 0 && reversed) {
            return indexList.size() - 1;
        }
        IndexInfo target = new IndexInfo(name, name, 0L, 0L);
        int index = Collections.binarySearch(indexList, target, IndexHelper.getComparator(comparator, reversed));
        return index < 0 ? -index - (reversed ? 2 : 1) : index;
    }

    public static Comparator<IndexInfo> getComparator(AbstractType nameComparator, boolean reversed) {
        return reversed ? nameComparator.indexReverseComparator : nameComparator.indexComparator;
    }

    public static class IndexInfo {
        public final long width;
        public final ByteBuffer lastName;
        public final ByteBuffer firstName;
        public final long offset;

        public IndexInfo(ByteBuffer firstName, ByteBuffer lastName, long offset, long width) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.offset = offset;
            this.width = width;
        }

        public void serialize(DataOutput dos) throws IOException {
            ByteBufferUtil.writeWithShortLength(this.firstName, dos);
            ByteBufferUtil.writeWithShortLength(this.lastName, dos);
            dos.writeLong(this.offset);
            dos.writeLong(this.width);
        }

        public int serializedSize() {
            return 2 + this.firstName.remaining() + 2 + this.lastName.remaining() + 8 + 8;
        }

        public static IndexInfo deserialize(FileDataInput dis) throws IOException {
            return new IndexInfo(ByteBufferUtil.readWithShortLength(dis), ByteBufferUtil.readWithShortLength(dis), dis.readLong(), dis.readLong());
        }
    }
}

