/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.HintedHandOffManager;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.commons.lang.StringUtils;

@Deprecated
public class RenameKeyspace
extends Migration {
    private String oldName;
    private String newName;

    protected RenameKeyspace() {
    }

    public RenameKeyspace(String oldName, String newName) throws ConfigurationException, IOException {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        this.oldName = oldName;
        this.newName = newName;
        KSMetaData oldKsm = DatabaseDescriptor.getTableDefinition(oldName);
        if (oldKsm == null) {
            throw new ConfigurationException("Keyspace either does not exist or does not match the one currently defined.");
        }
        if (DatabaseDescriptor.getTableDefinition(newName) != null) {
            throw new ConfigurationException("Keyspace already exists.");
        }
        if (!Migration.isLegalName(newName)) {
            throw new ConfigurationException("Invalid keyspace name: " + newName);
        }
        KSMetaData newKsm = RenameKeyspace.rename(oldKsm, newName, false);
        this.rm = RenameKeyspace.makeDefinitionMutation(newKsm, oldKsm, this.newVersion);
    }

    private static KSMetaData rename(KSMetaData ksm, String newName, boolean purgeOldCfs) {
        ArrayList<CFMetaData> newCfs = new ArrayList<CFMetaData>(ksm.cfMetaData().size());
        for (CFMetaData oldCf : ksm.cfMetaData().values()) {
            if (purgeOldCfs) {
                CFMetaData.purge(oldCf);
            }
            newCfs.add(CFMetaData.renameTable(oldCf, newName));
        }
        return new KSMetaData(newName, ksm.strategyClass, ksm.strategyOptions, ksm.replicationFactor, newCfs.toArray(new CFMetaData[newCfs.size()]));
    }

    @Override
    public void applyModels() throws IOException {
        if (!this.clientMode) {
            RenameKeyspace.renameKsStorageFiles(this.oldName, this.newName);
        }
        KSMetaData oldKsm = DatabaseDescriptor.getTableDefinition(this.oldName);
        for (CFMetaData cfm : oldKsm.cfMetaData().values()) {
            CFMetaData.purge(cfm);
        }
        KSMetaData newKsm = RenameKeyspace.rename(oldKsm, this.newName, true);
        for (CFMetaData cfm : newKsm.cfMetaData().values()) {
            try {
                CFMetaData.map(cfm);
            }
            catch (ConfigurationException ex) {
                throw new RuntimeException(ex);
            }
        }
        DatabaseDescriptor.clearTableDefinition(oldKsm, this.newVersion);
        DatabaseDescriptor.setTableDefinition(newKsm, this.newVersion);
        if (!this.clientMode) {
            Table.clear(oldKsm.name);
            Table.open(this.newName);
            HintedHandOffManager.renameHints(this.oldName, this.newName);
        }
    }

    private static void renameKsStorageFiles(String oldKs, String newKs) throws IOException {
        ArrayList<File> failed = new ArrayList<File>();
        for (String dataDir : DatabaseDescriptor.getAllDataFileLocations()) {
            File ksDir = new File(dataDir, oldKs);
            if (!ksDir.exists() || ksDir.renameTo(new File(dataDir, newKs))) continue;
            failed.add(ksDir);
        }
        if (!failed.isEmpty()) {
            throw new IOException("One or more problems encountered while renaming " + StringUtils.join(failed, (String)","));
        }
    }

    @Override
    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.RenameKeyspace rks = new org.apache.cassandra.db.migration.avro.RenameKeyspace();
        rks.old_ksname = new Utf8(this.oldName);
        rks.new_ksname = new Utf8(this.newName);
        mi.migration = rks;
    }

    @Override
    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi) {
        org.apache.cassandra.db.migration.avro.RenameKeyspace rks = (org.apache.cassandra.db.migration.avro.RenameKeyspace)((Object)mi.migration);
        this.oldName = ((Object)rks.old_ksname).toString();
        this.newName = ((Object)rks.new_ksname).toString();
    }

    public String toString() {
        return String.format("Rename keyspace %s to %s", this.oldName, this.newName);
    }
}

