/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ec2Snitch
extends AbstractNetworkTopologySnitch {
    protected static Logger logger = LoggerFactory.getLogger(Ec2Snitch.class);
    protected String ec2zone;
    protected String ec2region;

    public Ec2Snitch() throws IOException, ConfigurationException {
        HttpURLConnection conn = (HttpURLConnection)new URL("http://169.254.169.254/latest/meta-data/placement/availability-zone").openConnection();
        conn.setRequestMethod("GET");
        if (conn.getResponseCode() != 200) {
            throw new ConfigurationException("Ec2Snitch was unable to find region/zone data. Not an ec2 node?");
        }
        int cl = conn.getContentLength();
        byte[] b = new byte[cl];
        DataInputStream d = new DataInputStream((FilterInputStream)conn.getContent());
        d.readFully(b);
        String azone = new String(b, "UTF-8");
        String[] splits = azone.split("-");
        this.ec2zone = splits[splits.length - 1];
        this.ec2region = splits.length < 3 ? splits[0] : splits[0] + "-" + splits[1];
        logger.info("EC2Snitch using region: " + this.ec2region + ", zone: " + this.ec2zone + ".");
    }

    @Override
    public String getRack(InetAddress endpoint) {
        if (endpoint == FBUtilities.getLocalAddress()) {
            return this.ec2zone;
        }
        return Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        if (endpoint == FBUtilities.getLocalAddress()) {
            return this.ec2region;
        }
        return Gossiper.instance.getEndpointStateForEndpoint((InetAddress)endpoint).getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    @Override
    public void gossiperStarting() {
        logger.info("Ec2Snitch adding ApplicationState ec2region=" + this.ec2region + " ec2zone=" + this.ec2zone);
        Gossiper.instance.addLocalApplicationState(ApplicationState.DC, StorageService.instance.valueFactory.datacenter(this.ec2region));
        Gossiper.instance.addLocalApplicationState(ApplicationState.RACK, StorageService.instance.valueFactory.rack(this.ec2zone));
    }
}

