/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.log4j.Logger;

public class ExpiringColumn
extends Column {
    private static Logger logger = Logger.getLogger(ExpiringColumn.class);
    private final int localExpirationTime;
    private final int timeToLive;

    public ExpiringColumn(ByteBuffer name, ByteBuffer value, long timestamp, int timeToLive) {
        this(name, value, timestamp, timeToLive, (int)(System.currentTimeMillis() / 1000L) + timeToLive);
    }

    public ExpiringColumn(ByteBuffer name, ByteBuffer value, long timestamp, int timeToLive, int localExpirationTime) {
        super(name, value, timestamp);
        assert (timeToLive > 0) : timeToLive;
        assert (localExpirationTime > 0) : localExpirationTime;
        this.timeToLive = timeToLive;
        this.localExpirationTime = localExpirationTime;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    @Override
    public boolean isMarkedForDelete() {
        return (int)(System.currentTimeMillis() / 1000L) > this.localExpirationTime;
    }

    @Override
    public int size() {
        return super.size() + 4 + 4;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name.duplicate());
        digest.update(this.value.duplicate());
        DataOutputBuffer buffer = new DataOutputBuffer();
        try {
            buffer.writeLong(this.timestamp);
            buffer.writeByte(2);
            buffer.writeInt(this.timeToLive);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        digest.update(buffer.getData(), 0, buffer.getLength());
    }

    @Override
    public int getLocalDeletionTime() {
        return this.localExpirationTime;
    }

    @Override
    public IColumn deepCopy() {
        return new ExpiringColumn(ByteBufferUtil.clone(this.name), ByteBufferUtil.clone(this.value), this.timestamp, this.timeToLive, this.localExpirationTime);
    }

    @Override
    public String getString(AbstractType comparator) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getString(comparator));
        sb.append("!");
        sb.append(this.timeToLive);
        return sb.toString();
    }

    @Override
    public long getMarkedForDeleteAt() {
        if (this.isMarkedForDelete()) {
            return this.timestamp;
        }
        throw new IllegalStateException("column is not marked for delete");
    }
}

