/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.cassandra.io.util.AbstractDataInput;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;

public class MappedFileDataInput
extends AbstractDataInput
implements FileDataInput {
    private final MappedByteBuffer buffer;
    private final String filename;
    private int position;

    public MappedFileDataInput(FileInputStream stream, String filename, int position) throws IOException {
        FileChannel channel = stream.getChannel();
        this.buffer = channel.map(FileChannel.MapMode.READ_ONLY, position, channel.size());
        this.filename = filename;
        this.position = position;
    }

    public MappedFileDataInput(MappedByteBuffer buffer, String filename, int position) {
        assert (buffer != null);
        this.buffer = buffer;
        this.filename = filename;
        this.position = position;
    }

    @Override
    protected void seekInternal(int pos) {
        this.position = pos;
    }

    @Override
    protected int getPosition() {
        return this.position;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset(FileMark mark) throws IOException {
        assert (mark instanceof MappedFileDataInputMark);
        this.seekInternal(((MappedFileDataInputMark)mark).position);
    }

    @Override
    public FileMark mark() {
        return new MappedFileDataInputMark(this.position);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof MappedFileDataInputMark);
        assert (this.position >= ((MappedFileDataInputMark)mark).position);
        return this.position - ((MappedFileDataInputMark)mark).position;
    }

    @Override
    public boolean isEOF() throws IOException {
        return this.position == this.buffer.capacity();
    }

    @Override
    public long bytesRemaining() throws IOException {
        return this.buffer.capacity() - this.position;
    }

    @Override
    public String getPath() {
        return this.filename;
    }

    @Override
    public int read() throws IOException {
        if (this.isEOF()) {
            return -1;
        }
        return this.buffer.get(this.position++) & 0xFF;
    }

    @Override
    public synchronized ByteBuffer readBytes(int length) throws IOException {
        int remaining = this.buffer.remaining() - this.position;
        assert (length <= remaining) : String.format("mmap segment underflow; remaining is %d but %d requested", remaining, length);
        ByteBuffer bytes = this.buffer.duplicate();
        bytes.position(this.buffer.position() + this.position).limit(this.buffer.position() + this.position + length);
        this.position += length;
        return bytes;
    }

    @Override
    public final void readFully(byte[] buffer) throws IOException {
        throw new UnsupportedOperationException("use readBytes instead");
    }

    @Override
    public final void readFully(byte[] buffer, int offset, int count) throws IOException {
        throw new UnsupportedOperationException("use readBytes instead");
    }

    @Override
    public int skipBytes(int n) throws IOException {
        assert (n >= 0) : "skipping negative bytes is illegal: " + n;
        if (n == 0) {
            return 0;
        }
        int oldPosition = this.position;
        assert ((long)oldPosition + (long)n <= Integer.MAX_VALUE);
        this.position = Math.min(this.buffer.capacity(), this.position + n);
        return this.position - oldPosition;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "filename='" + this.filename + "'" + ", position=" + this.position + ")";
    }

    private static class MappedFileDataInputMark
    implements FileMark {
        int position;

        MappedFileDataInputMark(int position) {
            this.position = position;
        }
    }
}

