/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.util.List;
import org.apache.cassandra.config.RawKeyspace;
import org.apache.cassandra.config.RequestSchedulerOptions;

public class Config {
    public String cluster_name = "Test Cluster";
    public String authenticator;
    public String authority;
    public String partitioner;
    public Boolean auto_bootstrap = false;
    public Boolean hinted_handoff_enabled = true;
    public Integer max_hint_window_in_ms = Integer.MAX_VALUE;
    public String[] seeds;
    public DiskAccessMode disk_access_mode = DiskAccessMode.auto;
    public String job_tracker_host;
    public String job_jar_file_location;
    public String initial_token;
    public Long rpc_timeout_in_ms = new Long(2000L);
    public Integer phi_convict_threshold = 8;
    public Integer concurrent_reads = 8;
    public Integer concurrent_writes = 32;
    public Integer memtable_flush_writers = null;
    public Integer sliced_buffer_size_in_kb = 64;
    public Integer storage_port = 7000;
    public String listen_address;
    public String rpc_address;
    public Integer rpc_port = 9160;
    public Boolean rpc_keepalive = true;
    public Integer rpc_min_threads = 16;
    public Integer rpc_max_threads = Integer.MAX_VALUE;
    public Integer rpc_send_buff_size_in_bytes;
    public Integer rpc_recv_buff_size_in_bytes;
    public Integer thrift_max_message_length_in_mb = 16;
    public Integer thrift_framed_transport_size_in_mb = 15;
    public Boolean snapshot_before_compaction = false;
    public Integer compaction_thread_priority = 1;
    public Integer binary_memtable_throughput_in_mb = 256;
    public Integer column_index_size_in_kb = 64;
    public Integer in_memory_compaction_limit_in_mb = 256;
    public String[] data_file_directories;
    public String saved_caches_directory;
    public String commitlog_directory;
    public Integer commitlog_rotation_threshold_in_mb;
    public CommitLogSync commitlog_sync;
    public Double commitlog_sync_batch_window_in_ms;
    public Integer commitlog_sync_period_in_ms;
    public String endpoint_snitch;
    public Boolean dynamic_snitch = false;
    public Integer dynamic_snitch_update_interval_in_ms = 100;
    public Integer dynamic_snitch_reset_interval_in_ms = 600000;
    public Double dynamic_snitch_badness_threshold = 0.0;
    public String request_scheduler;
    public RequestSchedulerId request_scheduler_id;
    public RequestSchedulerOptions request_scheduler_options;
    public Integer index_interval = 128;
    public List<RawKeyspace> keyspaces;
    public Double flush_largest_memtables_at = 1.0;
    public Double reduce_cache_sizes_at = 1.0;
    public double reduce_cache_capacity_to = 0.6;
    public int hinted_handoff_throttle_delay_in_ms = 0;
    public boolean compaction_preheat_key_cache = true;
    public boolean incremental_backups = false;

    public static enum RequestSchedulerId {
        keyspace;

    }

    public static enum DiskAccessMode {
        auto,
        mmap,
        mmap_index_only,
        standard;

    }

    public static enum CommitLogSync {
        periodic,
        batch;

    }
}

