/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.KeyIterator;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class SSTableExport {
    private static final int PAGE_SIZE = 1000;
    private static final String KEY_OPTION = "k";
    private static final String EXCLUDEKEY_OPTION = "x";
    private static final String ENUMERATEKEYS_OPTION = "e";
    private static Options options = new Options();
    private static CommandLine cmd;

    private static String quote(String val) {
        return String.format("\"%s\"", val);
    }

    private static String asKey(String val) {
        return String.format("%s: ", SSTableExport.quote(val));
    }

    private static void serializeColumns(Iterator<IColumn> columns, PrintStream out) {
        while (columns.hasNext()) {
            SSTableExport.serializeColumn(columns.next(), out);
            if (!columns.hasNext()) continue;
            out.print(", ");
        }
    }

    private static void serializeColumns(Collection<IColumn> columns, PrintStream out) {
        SSTableExport.serializeColumns(columns.iterator(), out);
    }

    private static void serializeColumn(IColumn column, PrintStream out) {
        out.print("[");
        out.print(SSTableExport.quote(ByteBufferUtil.bytesToHex(column.name())));
        out.print(", ");
        out.print(SSTableExport.quote(ByteBufferUtil.bytesToHex(column.value())));
        out.print(", ");
        out.print(column.timestamp());
        out.print(", ");
        out.print(column.isMarkedForDelete());
        if (column instanceof ExpiringColumn) {
            out.print(", ");
            out.print(((ExpiringColumn)column).getTimeToLive());
            out.print(", ");
            out.print(column.getLocalDeletionTime());
        }
        out.print("]");
    }

    private static void serializeRow(SSTableReader reader, SSTableIdentityIterator row, DecoratedKey key, PrintStream out) {
        ColumnFamily columnFamily = row.getColumnFamily();
        boolean isSuperCF = columnFamily.isSuper();
        ByteBuffer startColumn = ByteBufferUtil.EMPTY_BYTE_BUFFER;
        out.print(SSTableExport.asKey(ByteBufferUtil.bytesToHex(key.key)));
        out.print(isSuperCF ? "{" : "[");
        while (true) {
            QueryFilter filter = QueryFilter.getSliceFilter(key, new QueryPath(columnFamily.metadata().tableName), startColumn, ByteBufferUtil.EMPTY_BYTE_BUFFER, false, 1000);
            IColumnIterator columns = filter.getSSTableColumnIterator(reader);
            int columnCount = 0;
            while (columns.hasNext()) {
                startColumn = ((IColumn)columns.next()).name();
                ++columnCount;
            }
            try {
                columns = filter.getSSTableColumnIterator(reader);
                SSTableExport.serializeRow(columns, isSuperCF, out);
            }
            catch (IOException e) {
                System.err.println("WARNING: Corrupt row " + key + " (skipping).");
            }
            if (columnCount < 1000) break;
            out.print(",");
        }
        out.print(isSuperCF ? "}" : "]");
    }

    private static void serializeRow(IColumnIterator columns, boolean isSuper, PrintStream out) throws IOException {
        if (isSuper) {
            while (columns.hasNext()) {
                IColumn column = (IColumn)columns.next();
                out.print(SSTableExport.asKey(ByteBufferUtil.bytesToHex(column.name())));
                out.print("{");
                out.print(SSTableExport.asKey("deletedAt"));
                out.print(column.getMarkedForDeleteAt());
                out.print(", ");
                out.print(SSTableExport.asKey("subColumns"));
                out.print("[");
                SSTableExport.serializeColumns(column.getSubColumns(), out);
                out.print("]");
                out.print("}");
                if (!columns.hasNext()) continue;
                out.print(", ");
            }
        } else {
            SSTableExport.serializeColumns(columns, out);
        }
    }

    public static void enumeratekeys(String ssTableFile, PrintStream outs) throws IOException {
        Descriptor desc = Descriptor.fromFilename(ssTableFile);
        KeyIterator iter = new KeyIterator(desc);
        DecoratedKey lastKey = null;
        while (iter.hasNext()) {
            DecoratedKey key = (DecoratedKey)iter.next();
            if (lastKey != null && lastKey.compareTo(key) > 0) {
                throw new IOException("Key out of order! " + lastKey + " > " + key);
            }
            lastKey = key;
            outs.println(ByteBufferUtil.bytesToHex(key.key));
        }
        iter.close();
        outs.flush();
    }

    public static void export(String ssTableFile, PrintStream outs, Collection<String> toExport, String[] excludes) throws IOException {
        SSTableReader reader = SSTableReader.open(Descriptor.fromFilename(ssTableFile));
        SSTableScanner scanner = reader.getDirectScanner(65535);
        IPartitioner partitioner = StorageService.getPartitioner();
        for (String toExclude : excludes) {
            toExport.remove(toExclude);
        }
        outs.println("{");
        int i = 0;
        DecoratedKey lastKey = null;
        for (String key : toExport) {
            DecoratedKey decoratedKey = partitioner.decorateKey(ByteBufferUtil.hexToBytes(key));
            if (lastKey != null && lastKey.compareTo(decoratedKey) > 0) {
                throw new IOException("Key out of order! " + lastKey + " > " + decoratedKey);
            }
            lastKey = decoratedKey;
            scanner.seekTo(decoratedKey);
            if (!scanner.hasNext()) continue;
            SSTableExport.serializeRow(reader, (SSTableIdentityIterator)scanner.next(), decoratedKey, outs);
            if (i != 0) {
                outs.println(",");
            }
            ++i;
        }
        outs.println("\n}");
        outs.flush();
        scanner.close();
    }

    static void export(SSTableReader reader, PrintStream outs, String[] excludes) throws IOException {
        HashSet<Object> excludeSet = new HashSet();
        if (excludes != null) {
            excludeSet = new HashSet<String>(Arrays.asList(excludes));
        }
        SSTableScanner scanner = reader.getDirectScanner(65535);
        outs.println("{");
        int i = 0;
        while (scanner.hasNext()) {
            SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
            String currentKey = ByteBufferUtil.bytesToHex(row.getKey().key);
            if (excludeSet.contains(currentKey)) continue;
            if (i != 0) {
                outs.println(",");
            }
            SSTableExport.serializeRow(reader, row, row.getKey(), outs);
            ++i;
        }
        outs.println("\n}");
        outs.flush();
        scanner.close();
    }

    public static void export(String ssTableFile, PrintStream outs, String[] excludes) throws IOException {
        SSTableExport.export(SSTableReader.open(Descriptor.fromFilename(ssTableFile)), outs, excludes);
    }

    public static void export(String ssTableFile, String[] excludes) throws IOException {
        SSTableExport.export(ssTableFile, System.out, excludes);
    }

    public static void main(String[] args) throws IOException, ConfigurationException {
        String usage = String.format("Usage: %s <sstable> [-k key [-k key [...]] -x key [-x key [...]]]%n", SSTableExport.class.getName());
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e1) {
            System.err.println(e1.getMessage());
            System.err.println(usage);
            System.exit(1);
        }
        if (cmd.getArgs().length != 1) {
            System.err.println("You must supply exactly one sstable");
            System.err.println(usage);
            System.exit(1);
        }
        String[] keys = cmd.getOptionValues(KEY_OPTION);
        String[] excludes = cmd.getOptionValues(EXCLUDEKEY_OPTION);
        String ssTableFileName = new File(cmd.getArgs()[0]).getAbsolutePath();
        DatabaseDescriptor.loadSchemas();
        if (DatabaseDescriptor.getNonSystemTables().size() < 1) {
            String msg = "no non-system tables are defined";
            System.err.println(msg);
            throw new ConfigurationException(msg);
        }
        if (cmd.hasOption(ENUMERATEKEYS_OPTION)) {
            SSTableExport.enumeratekeys(ssTableFileName, System.out);
        } else if (keys != null && keys.length > 0) {
            SSTableExport.export(ssTableFileName, System.out, Arrays.asList(keys), excludes);
        } else {
            SSTableExport.export(ssTableFileName, excludes);
        }
        System.exit(0);
    }

    static {
        Option optKey = new Option(KEY_OPTION, true, "Row key");
        optKey.setArgs(500);
        options.addOption(optKey);
        Option excludeKey = new Option(EXCLUDEKEY_OPTION, true, "Excluded row key");
        excludeKey.setArgs(500);
        options.addOption(excludeKey);
        Option optEnumerate = new Option(ENUMERATEKEYS_OPTION, false, "enumerate keys only");
        options.addOption(optEnumerate);
    }
}

