/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilySerializer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableNamesIterator
extends SimpleAbstractColumnIterator
implements IColumnIterator {
    private static Logger logger = LoggerFactory.getLogger(SSTableNamesIterator.class);
    private ColumnFamily cf;
    private Iterator<IColumn> iter;
    public final SortedSet<ByteBuffer> columns;
    public final DecoratedKey key;

    public SSTableNamesIterator(SSTableReader sstable, DecoratedKey key, SortedSet<ByteBuffer> columns) {
        assert (columns != null);
        this.columns = columns;
        this.key = key;
        FileDataInput file = sstable.getFileDataInput(key, DatabaseDescriptor.getIndexedReadBufferSizeInKB() * 1024);
        if (file == null) {
            return;
        }
        try {
            DecoratedKey keyInDisk = SSTableReader.decodeKey(sstable.partitioner, sstable.descriptor, ByteBufferUtil.readWithShortLength(file));
            assert (keyInDisk.equals(key)) : String.format("%s != %s in %s", keyInDisk, key, file.getPath());
            SSTableReader.readRowSize(file, sstable.descriptor);
            this.read(sstable, file);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            FileUtils.closeQuietly(file);
        }
    }

    public SSTableNamesIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, SortedSet<ByteBuffer> columns) {
        assert (columns != null);
        this.columns = columns;
        this.key = key;
        try {
            this.read(sstable, file);
        }
        catch (IOException ioe) {
            throw new IOError(ioe);
        }
    }

    private void read(SSTableReader sstable, FileDataInput file) throws IOException {
        Filter bf = IndexHelper.defreezeBloomFilter(file, sstable.descriptor.usesOldBloomFilter);
        ArrayList<IndexHelper.IndexInfo> indexList = IndexHelper.deserializeIndex(file);
        ColumnFamilySerializer serializer = ColumnFamily.serializer();
        try {
            this.cf = serializer.deserializeFromSSTableNoColumns(ColumnFamily.create(sstable.metadata), file);
        }
        catch (Exception e) {
            throw new IOException(serializer + " failed to deserialize " + sstable.getColumnFamilyName() + " with " + sstable.metadata + " from " + file, e);
        }
        ArrayList<ByteBuffer> filteredColumnNames = new ArrayList<ByteBuffer>(this.columns.size());
        for (ByteBuffer name : this.columns) {
            if (!bf.isPresent(name)) continue;
            filteredColumnNames.add(name);
        }
        if (filteredColumnNames.isEmpty()) {
            return;
        }
        if (indexList == null) {
            this.readSimpleColumns(file, this.columns, filteredColumnNames);
        } else {
            this.readIndexedColumns(sstable.metadata, file, this.columns, filteredColumnNames, indexList);
        }
        this.iter = this.cf.getSortedColumns().iterator();
    }

    private void readSimpleColumns(FileDataInput file, SortedSet<ByteBuffer> columnNames, List<ByteBuffer> filteredColumnNames) throws IOException {
        int columns = file.readInt();
        int n = 0;
        for (int i = 0; i < columns; ++i) {
            IColumn column = this.cf.getColumnSerializer().deserialize(file);
            if (!columnNames.contains(column.name())) continue;
            this.cf.addColumn(column);
            if (n++ > filteredColumnNames.size()) break;
        }
    }

    private void readIndexedColumns(CFMetaData metadata, FileDataInput file, SortedSet<ByteBuffer> columnNames, List<ByteBuffer> filteredColumnNames, List<IndexHelper.IndexInfo> indexList) throws IOException {
        file.readInt();
        AbstractType comparator = metadata.comparator;
        TreeSet<IndexHelper.IndexInfo> ranges = new TreeSet<IndexHelper.IndexInfo>(IndexHelper.getComparator(comparator, false));
        for (ByteBuffer name : filteredColumnNames) {
            int index = IndexHelper.indexFor(name, indexList, comparator, false);
            if (index == indexList.size()) continue;
            IndexHelper.IndexInfo indexInfo = indexList.get(index);
            if (comparator.compare(name, indexInfo.firstName) < 0) continue;
            ranges.add(indexInfo);
        }
        FileMark mark = file.mark();
        for (IndexHelper.IndexInfo indexInfo : ranges) {
            file.reset(mark);
            long curOffsert = file.skipBytes((int)indexInfo.offset);
            assert (curOffsert == indexInfo.offset);
            while ((long)file.bytesPastMark(mark) < indexInfo.offset + indexInfo.width) {
                IColumn column = this.cf.getColumnSerializer().deserialize(file);
                if (!columnNames.contains(column.name())) continue;
                this.cf.addColumn(column);
            }
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.cf;
    }

    protected IColumn computeNext() {
        if (this.iter == null || !this.iter.hasNext()) {
            return (IColumn)this.endOfData();
        }
        return this.iter.next();
    }
}

