/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.avro;

import java.util.List;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.avro.InvalidRequestException;
import org.apache.cassandra.avro.NotFoundException;
import org.apache.cassandra.avro.TimedOutException;
import org.apache.cassandra.avro.TokenRange;
import org.apache.cassandra.avro.UnavailableException;

class ErrorFactory {
    ErrorFactory() {
    }

    static InvalidRequestException newInvalidRequestException(Utf8 why) {
        InvalidRequestException exception = new InvalidRequestException();
        exception.why = why;
        return exception;
    }

    static InvalidRequestException newInvalidRequestException(String why) {
        return ErrorFactory.newInvalidRequestException(new Utf8(why));
    }

    static InvalidRequestException newInvalidRequestException(Throwable e) {
        InvalidRequestException exception = ErrorFactory.newInvalidRequestException(e.getMessage());
        exception.initCause(e);
        return exception;
    }

    static NotFoundException newNotFoundException(Utf8 why) {
        NotFoundException exception = new NotFoundException();
        exception.why = why;
        return exception;
    }

    static NotFoundException newNotFoundException(String why) {
        return ErrorFactory.newNotFoundException(new Utf8(why));
    }

    static NotFoundException newNotFoundException() {
        return ErrorFactory.newNotFoundException(new Utf8());
    }

    static TimedOutException newTimedOutException(Utf8 why) {
        TimedOutException exception = new TimedOutException();
        exception.why = why;
        return exception;
    }

    static TimedOutException newTimedOutException(String why) {
        return ErrorFactory.newTimedOutException(new Utf8(why));
    }

    static TimedOutException newTimedOutException() {
        return ErrorFactory.newTimedOutException(new Utf8());
    }

    static UnavailableException newUnavailableException(Utf8 why) {
        UnavailableException exception = new UnavailableException();
        exception.why = why;
        return exception;
    }

    static UnavailableException newUnavailableException(String why) {
        return ErrorFactory.newUnavailableException(new Utf8(why));
    }

    static UnavailableException newUnavailableException(Throwable t) {
        UnavailableException exception = ErrorFactory.newUnavailableException(t.getMessage());
        exception.initCause(t);
        return exception;
    }

    static UnavailableException newUnavailableException() {
        return ErrorFactory.newUnavailableException(new Utf8());
    }

    public static TokenRange newTokenRange(String startRange, String endRange, List<? extends CharSequence> endpoints) {
        TokenRange tRange = new TokenRange();
        tRange.start_token = startRange;
        tRange.end_token = endRange;
        tRange.endpoints = endpoints;
        return tRange;
    }
}

