/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.LegacyBloomFilter;

class LegacyBloomFilterSerializer
implements ICompactSerializer<LegacyBloomFilter> {
    LegacyBloomFilterSerializer() {
    }

    @Override
    public void serialize(LegacyBloomFilter bf, DataOutputStream dos) throws IOException {
        dos.writeInt(bf.getHashCount());
        ObjectOutputStream oos = new ObjectOutputStream(dos);
        oos.writeObject(bf.getBitSet());
        oos.flush();
    }

    @Override
    public LegacyBloomFilter deserialize(DataInputStream dis) throws IOException {
        int hashes = dis.readInt();
        ObjectInputStream ois = new ObjectInputStream(dis);
        try {
            BitSet bs = (BitSet)ois.readObject();
            return new LegacyBloomFilter(hashes, bs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

