/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

public enum Stage {
    READ,
    MUTATION,
    STREAM,
    GOSSIP,
    REQUEST_RESPONSE,
    ANTI_ENTROPY,
    MIGRATION,
    MISC,
    INTERNAL_RESPONSE,
    READ_REPAIR;


    public String getJmxType() {
        switch (this) {
            case ANTI_ENTROPY: 
            case GOSSIP: 
            case MIGRATION: 
            case MISC: 
            case STREAM: 
            case INTERNAL_RESPONSE: {
                return "internal";
            }
            case MUTATION: 
            case READ: 
            case REQUEST_RESPONSE: 
            case READ_REPAIR: {
                return "request";
            }
        }
        throw new AssertionError((Object)("Unknown stage " + (Object)((Object)this)));
    }

    public String getJmxName() {
        String name = "";
        for (String word : this.toString().split("_")) {
            name = name + word.substring(0, 1) + word.substring(1).toLowerCase();
        }
        return name + "Stage";
    }
}

