/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.type.TypeReference;

public class SSTableImport {
    private static final String KEYSPACE_OPTION = "K";
    private static final String COLUMN_FAMILY_OPTION = "c";
    private static final String KEY_COUNT_OPTION = "n";
    private static final String IS_SORTED_OPTION = "s";
    private static Options options;
    private static CommandLine cmd;
    private static Integer keyCountToImport;
    private static boolean isSorted;
    private static JsonFactory factory;

    private static void addToStandardCF(List<?> row, ColumnFamily cfamily) {
        SSTableImport.addColumnsToCF(row, null, cfamily);
    }

    private static void addColumnsToCF(List<?> row, ByteBuffer superName, ColumnFamily cfamily) {
        CFMetaData cfm = cfamily.metadata();
        assert (cfm != null);
        for (Object c : row) {
            JsonColumn<List> col = new JsonColumn<List>((List)c);
            QueryPath path = new QueryPath(cfm.cfName, superName, col.getName());
            if (((JsonColumn)col).ttl > 0) {
                cfamily.addColumn(null, new ExpiringColumn(col.getName(), col.getValue(), ((JsonColumn)col).timestamp, ((JsonColumn)col).ttl, ((JsonColumn)col).localExpirationTime));
                continue;
            }
            if (((JsonColumn)col).isDeleted) {
                cfamily.addTombstone(path, col.getValue(), ((JsonColumn)col).timestamp);
                continue;
            }
            cfamily.addColumn(path, col.getValue(), ((JsonColumn)col).timestamp);
        }
    }

    private static void addToSuperCF(Map<?, ?> row, ColumnFamily cfamily) {
        CFMetaData metaData = cfamily.metadata();
        assert (metaData != null);
        for (Map.Entry<?, ?> entry : row.entrySet()) {
            ByteBuffer superName = ByteBufferUtil.hexToBytes((String)entry.getKey());
            Map data = (Map)entry.getValue();
            SSTableImport.addColumnsToCF((List)data.get("subColumns"), superName, cfamily);
        }
    }

    public static void importJson(String jsonFile, String keyspace, String cf, String ssTablePath) throws IOException {
        int importedKeys;
        ColumnFamily columnFamily = ColumnFamily.create(keyspace, cf);
        IPartitioner partitioner = DatabaseDescriptor.getPartitioner();
        int n = importedKeys = isSorted ? SSTableImport.importSorted(jsonFile, columnFamily, ssTablePath, partitioner) : SSTableImport.importUnsorted(SSTableImport.getParser(jsonFile), columnFamily, ssTablePath, partitioner);
        if (importedKeys != -1) {
            System.out.printf("%d keys imported successfully.%n", importedKeys);
        }
    }

    private static int importUnsorted(JsonParser parser, ColumnFamily columnFamily, String ssTablePath, IPartitioner<?> partitioner) throws IOException {
        int importedKeys = 0;
        long start = System.currentTimeMillis();
        Map data = (Map)parser.readValueAs(new TypeReference<Map<?, ?>>(){});
        keyCountToImport = keyCountToImport == null ? data.size() : keyCountToImport.intValue();
        SSTableWriter writer = new SSTableWriter(ssTablePath, keyCountToImport.intValue());
        System.out.printf("Importing %s keys...%n", keyCountToImport);
        TreeMap decoratedKeys = new TreeMap();
        for (Object k : data.keySet()) {
            String key = (String)k;
            decoratedKeys.put(partitioner.decorateKey(ByteBufferUtil.hexToBytes(key)), key);
        }
        for (Map.Entry entry : decoratedKeys.entrySet()) {
            if (columnFamily.getColumnFamilyType() == ColumnFamilyType.Super) {
                SSTableImport.addToSuperCF((Map)data.get(entry.getValue()), columnFamily);
            } else {
                SSTableImport.addToStandardCF((List)data.get(entry.getValue()), columnFamily);
            }
            writer.append((DecoratedKey)entry.getKey(), columnFamily);
            columnFamily.clear();
            ++importedKeys;
            long current = System.currentTimeMillis();
            if (current - start >= 5000L) {
                System.out.printf("Currently imported %d keys.%n", importedKeys);
                start = current;
            }
            if (keyCountToImport != importedKeys) continue;
            break;
        }
        writer.closeAndOpenReader();
        return importedKeys;
    }

    public static int importSorted(String jsonFile, ColumnFamily columnFamily, String ssTablePath, IPartitioner<?> partitioner) throws IOException {
        int importedKeys = 0;
        long start = System.currentTimeMillis();
        JsonParser parser = SSTableImport.getParser(jsonFile);
        if (keyCountToImport == null) {
            keyCountToImport = 0;
            System.out.println("Counting keys to import, please wait... (NOTE: to skip this use -n <num_keys>)");
            parser.nextToken();
            while (parser.nextToken() != null) {
                parser.nextToken();
                parser.skipChildren();
                if (parser.getCurrentName() == null) continue;
                Integer n = keyCountToImport;
                Integer n2 = keyCountToImport = Integer.valueOf(keyCountToImport + 1);
            }
        }
        System.out.printf("Importing %s keys...%n", keyCountToImport);
        parser = SSTableImport.getParser(jsonFile);
        SSTableWriter writer = new SSTableWriter(ssTablePath, keyCountToImport.intValue());
        int lineNumber = 1;
        DecoratedKey<?> prevStoredKey = null;
        while (parser.nextToken() != null) {
            Object columns;
            String key = parser.getCurrentName();
            if (key == null) continue;
            String tokenName = parser.nextToken().name();
            if (tokenName.equals("START_ARRAY")) {
                if (columnFamily.getColumnFamilyType() == ColumnFamilyType.Super) {
                    throw new RuntimeException("Can't write Standard columns to the Super Column Family.");
                }
                columns = (List)parser.readValueAs(new TypeReference<List<?>>(){});
                SSTableImport.addToStandardCF(columns, columnFamily);
            } else if (tokenName.equals("START_OBJECT")) {
                if (columnFamily.getColumnFamilyType() == ColumnFamilyType.Standard) {
                    throw new RuntimeException("Can't write Super columns to the Standard Column Family.");
                }
                columns = (Map)parser.readValueAs(new TypeReference<Map<?, ?>>(){});
                SSTableImport.addToSuperCF(columns, columnFamily);
            } else {
                throw new UnsupportedOperationException("Only Array or Hash allowed as row content.");
            }
            DecoratedKey<?> currentKey = partitioner.decorateKey(ByteBufferUtil.hexToBytes(key));
            if (prevStoredKey != null && prevStoredKey.compareTo(currentKey) != -1) {
                System.err.printf("Line %d: Key %s is greater than previous, collection is not sorted properly. Aborting import. You might need to delete SSTables manually.%n", lineNumber, key);
                return -1;
            }
            writer.append(currentKey, columnFamily);
            columnFamily.clear();
            prevStoredKey = currentKey;
            ++importedKeys;
            ++lineNumber;
            long current = System.currentTimeMillis();
            if (current - start >= 5000L) {
                System.out.printf("Currently imported %d keys.%n", importedKeys);
                start = current;
            }
            if (keyCountToImport != importedKeys) continue;
            break;
        }
        writer.closeAndOpenReader();
        return importedKeys;
    }

    private static JsonParser getParser(String fileName) throws IOException {
        return factory.createJsonParser(new File(fileName));
    }

    public static void main(String[] args) throws IOException, ParseException, ConfigurationException {
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            SSTableImport.printProgramUsage();
            System.exit(1);
        }
        if (cmd.getArgs().length != 2) {
            SSTableImport.printProgramUsage();
            System.exit(1);
        }
        String json = cmd.getArgs()[0];
        String ssTable = cmd.getArgs()[1];
        String keyspace = cmd.getOptionValue(KEYSPACE_OPTION);
        String cfamily = cmd.getOptionValue(COLUMN_FAMILY_OPTION);
        if (cmd.hasOption(KEY_COUNT_OPTION)) {
            keyCountToImport = Integer.valueOf(cmd.getOptionValue(KEY_COUNT_OPTION));
        }
        if (cmd.hasOption(IS_SORTED_OPTION)) {
            isSorted = true;
        }
        DatabaseDescriptor.loadSchemas();
        if (DatabaseDescriptor.getNonSystemTables().size() < 1) {
            String msg = "no non-system tables are defined";
            System.err.println(msg);
            throw new ConfigurationException(msg);
        }
        try {
            SSTableImport.importJson(json, keyspace, cfamily, ssTable);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("ERROR: " + e.getMessage());
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void printProgramUsage() {
        System.out.printf("Usage: %s -s -K <keyspace> -c <column_family> -n <num_keys> <json> <sstable>%n%n", SSTableImport.class.getName());
        System.out.println("Options:");
        for (Object o : options.getOptions()) {
            Option opt = (Option)o;
            System.out.println("  -" + opt.getOpt() + " - " + opt.getDescription());
        }
    }

    public static void setKeyCountToImport(Integer keyCount) {
        keyCountToImport = keyCount;
    }

    static {
        keyCountToImport = null;
        isSorted = false;
        factory = new MappingJsonFactory();
        options = new Options();
        Option optKeyspace = new Option(KEYSPACE_OPTION, true, "Keyspace name.");
        optKeyspace.setRequired(true);
        options.addOption(optKeyspace);
        Option optColfamily = new Option(COLUMN_FAMILY_OPTION, true, "Column Family name.");
        optColfamily.setRequired(true);
        options.addOption(optColfamily);
        options.addOption(new Option(KEY_COUNT_OPTION, true, "Number of keys to import (Optional)."));
        options.addOption(new Option(IS_SORTED_OPTION, false, "Assume JSON file as already sorted (e.g. created by sstable2json tool) (Optional)."));
    }

    private static class JsonColumn<T> {
        private ByteBuffer name;
        private ByteBuffer value;
        private long timestamp;
        private boolean isDeleted;
        private int ttl;
        private int localExpirationTime;

        public JsonColumn(T json) {
            if (json instanceof List) {
                List fields = (List)json;
                assert (fields.size() == 4 || fields.size() == 6) : "Column definition should have 4 or 6 fields.";
                this.name = ByteBufferUtil.hexToBytes((String)fields.get(0));
                this.value = ByteBufferUtil.hexToBytes((String)fields.get(1));
                this.timestamp = (Long)fields.get(2);
                this.isDeleted = (Boolean)fields.get(3);
                if (fields.size() == 6) {
                    this.ttl = (Integer)fields.get(4);
                    this.localExpirationTime = (int)((Long)fields.get(5)).longValue();
                }
            }
        }

        public ByteBuffer getName() {
            return this.name.duplicate();
        }

        public ByteBuffer getValue() {
            return this.value.duplicate();
        }
    }
}

