/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.AbstractCassandraDaemon;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CassandraServer;
import org.apache.cassandra.thrift.CustomTThreadPoolServer;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.thrift.TCustomServerSocket;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraDaemon
extends AbstractCassandraDaemon {
    private static Logger logger = LoggerFactory.getLogger(CassandraDaemon.class);
    private ThriftServer server;

    @Override
    protected void startServer() {
        if (this.server == null) {
            this.server = new ThriftServer(this.listenAddr, this.listenPort);
            this.server.start();
        }
    }

    @Override
    protected void stopServer() {
        if (this.server != null) {
            this.server.stopServer();
            try {
                this.server.join();
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting thrift server to stop", (Throwable)e);
            }
            this.server = null;
        }
    }

    public static void main(String[] args) {
        new CassandraDaemon().activate();
    }

    private static class ThriftServer
    extends Thread {
        private TServer serverEngine;

        public ThriftServer(InetAddress listenAddr, int listenPort) {
            TTransportFactory outTransportFactory;
            TTransportFactory inTransportFactory;
            CassandraServer cassandraServer = new CassandraServer();
            Cassandra.Processor processor = new Cassandra.Processor(cassandraServer);
            TCustomServerSocket tServerSocket = null;
            try {
                tServerSocket = new TCustomServerSocket(new InetSocketAddress(listenAddr, listenPort), DatabaseDescriptor.getRpcKeepAlive(), DatabaseDescriptor.getRpcSendBufferSize(), DatabaseDescriptor.getRpcRecvBufferSize());
            }
            catch (TTransportException e) {
                throw new RuntimeException(String.format("Unable to create thrift socket to %s:%s", listenAddr, listenPort), e);
            }
            logger.info(String.format("Binding thrift service to %s:%s", listenAddr, listenPort));
            TBinaryProtocol.Factory tProtocolFactory = new TBinaryProtocol.Factory(true, true, DatabaseDescriptor.getThriftMaxMessageLength());
            if (DatabaseDescriptor.isThriftFramed()) {
                int tFramedTransportSize = DatabaseDescriptor.getThriftFramedTransportSize();
                inTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
                outTransportFactory = new TFramedTransport.Factory(tFramedTransportSize);
                logger.info("Using TFastFramedTransport with a max frame size of {} bytes.", (Object)tFramedTransportSize);
            } else {
                inTransportFactory = new TTransportFactory();
                outTransportFactory = new TTransportFactory();
            }
            CustomTThreadPoolServer.Options options = new CustomTThreadPoolServer.Options();
            options.minWorkerThreads = 64;
            AbstractCassandraDaemon.CleaningThreadPool executorService = new AbstractCassandraDaemon.CleaningThreadPool(cassandraServer.clientState, options.minWorkerThreads, options.maxWorkerThreads);
            this.serverEngine = new CustomTThreadPoolServer(new TProcessorFactory((TProcessor)processor), tServerSocket, inTransportFactory, outTransportFactory, (TProtocolFactory)tProtocolFactory, (TProtocolFactory)tProtocolFactory, options, executorService);
        }

        @Override
        public void run() {
            logger.info("Listening for thrift clients...");
            this.serverEngine.serve();
        }

        public void stopServer() {
            logger.info("Stop listening to thrift clients");
            this.serverEngine.stop();
        }
    }
}

