/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexScanCommand;
import org.apache.cassandra.db.RangeSliceCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.ReadVerbHandler;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.Truncation;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DatacenterReadCallback;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.service.RangeSliceResponseResolver;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.ReadResponseResolver;
import org.apache.cassandra.service.RepairCallback;
import org.apache.cassandra.service.StorageProxyMBean;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.TruncateResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LatencyTracker;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageProxy
implements StorageProxyMBean {
    private static final Logger logger = LoggerFactory.getLogger(StorageProxy.class);
    private static ScheduledExecutorService repairExecutor = new ScheduledThreadPoolExecutor(1);
    private static final ThreadLocal<Random> random = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private static final LatencyTracker readStats = new LatencyTracker();
    private static final LatencyTracker rangeStats = new LatencyTracker();
    private static final LatencyTracker writeStats = new LatencyTracker();
    private static boolean hintedHandoffEnabled = DatabaseDescriptor.hintedHandoffEnabled();
    private static int maxHintWindow = DatabaseDescriptor.getMaxHintWindow();
    private static final String UNREACHABLE = "UNREACHABLE";

    private StorageProxy() {
    }

    public static void mutate(List<RowMutation> mutations, ConsistencyLevel consistency_level) throws UnavailableException, TimeoutException {
        long startTime = System.nanoTime();
        ArrayList<IWriteResponseHandler> responseHandlers = new ArrayList<IWriteResponseHandler>();
        RowMutation mostRecentRowMutation = null;
        StorageService ss = StorageService.instance;
        String localDataCenter = DatabaseDescriptor.getEndpointSnitch().getDatacenter(FBUtilities.getLocalAddress());
        try {
            Iterator<RowMutation> i$ = mutations.iterator();
            while (i$.hasNext()) {
                RowMutation rm;
                mostRecentRowMutation = rm = i$.next();
                String table = rm.getTable();
                AbstractReplicationStrategy rs = Table.open(table).getReplicationStrategy();
                List<InetAddress> naturalEndpoints = ss.getNaturalEndpoints(table, rm.key());
                Collection<InetAddress> writeEndpoints = ss.getTokenMetadata().getWriteEndpoints((Token)StorageService.getPartitioner().getToken(rm.key()), table, (Collection<InetAddress>)naturalEndpoints);
                Multimap<InetAddress, InetAddress> hintedEndpoints = rs.getHintedEndpoints(writeEndpoints);
                IWriteResponseHandler responseHandler = rs.getWriteResponseHandler(writeEndpoints, hintedEndpoints, consistency_level);
                responseHandler.assureSufficientLiveNodes();
                responseHandlers.add(responseHandler);
                HashMap<String, Multimap<Message, InetAddress>> dcMessages = new HashMap<String, Multimap<Message, InetAddress>>(hintedEndpoints.size());
                Message unhintedMessage = null;
                for (Map.Entry entry : hintedEndpoints.asMap().entrySet()) {
                    InetAddress destination = (InetAddress)entry.getKey();
                    Collection targets = (Collection)entry.getValue();
                    String dc = DatabaseDescriptor.getEndpointSnitch().getDatacenter(destination);
                    if (targets.size() == 1 && ((InetAddress)targets.iterator().next()).equals(destination)) {
                        Multimap messages;
                        if (destination.equals(FBUtilities.getLocalAddress())) {
                            StorageProxy.insertLocal(rm, responseHandler);
                            continue;
                        }
                        if (unhintedMessage == null) {
                            unhintedMessage = rm.makeRowMutationMessage();
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("insert writing key " + ByteBufferUtil.bytesToHex(rm.key()) + " to " + destination);
                        }
                        if ((messages = (Multimap)dcMessages.get(dc)) == null) {
                            messages = HashMultimap.create();
                            dcMessages.put(dc, (Multimap<Message, InetAddress>)messages);
                        }
                        messages.put((Object)unhintedMessage, (Object)destination);
                        continue;
                    }
                    Message hintedMessage = rm.makeRowMutationMessage();
                    for (InetAddress target : targets) {
                        if (target.equals(destination)) continue;
                        StorageProxy.addHintHeader(hintedMessage, target);
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("insert writing key " + ByteBufferUtil.bytesToHex(rm.key()) + " to " + destination + " for " + target);
                    }
                    if (writeEndpoints.contains(destination) || consistency_level == ConsistencyLevel.ANY) {
                        MessagingService.instance().sendRR(hintedMessage, destination, responseHandler);
                        continue;
                    }
                    MessagingService.instance().sendOneWay(hintedMessage, destination);
                }
                StorageProxy.sendMessages(localDataCenter, dcMessages, responseHandler);
            }
            for (IWriteResponseHandler responseHandler : responseHandlers) {
                responseHandler.get();
            }
        }
        catch (IOException e) {
            if (mostRecentRowMutation == null) {
                throw new RuntimeException("no mutations were seen but found an error during write anyway", e);
            }
            throw new RuntimeException("error writing key " + ByteBufferUtil.bytesToHex(mostRecentRowMutation.key()), e);
        }
        finally {
            writeStats.addNano(System.nanoTime() - startTime);
        }
    }

    private static void sendMessages(String localDataCenter, Map<String, Multimap<Message, InetAddress>> dcMessages, IWriteResponseHandler handler) throws IOException {
        for (Map.Entry<String, Multimap<Message, InetAddress>> entry : dcMessages.entrySet()) {
            String dataCenter = entry.getKey();
            for (Map.Entry messages : entry.getValue().asMap().entrySet()) {
                Message message = (Message)messages.getKey();
                message.removeHeader("FORWARD");
                if (dataCenter.equals(localDataCenter) || StorageService.instance.useEfficientCrossDCWrites()) {
                    for (InetAddress destination : (Collection)messages.getValue()) {
                        MessagingService.instance().sendRR(message, destination, handler);
                    }
                    continue;
                }
                Iterator iter = ((Collection)messages.getValue()).iterator();
                InetAddress target = (InetAddress)iter.next();
                while (iter.hasNext()) {
                    InetAddress destination = (InetAddress)iter.next();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    byte[] previousHints = message.getHeader("FORWARD");
                    if (previousHints != null) {
                        dos.write(previousHints);
                    }
                    dos.write(destination.getAddress());
                    message.setHeader("FORWARD", bos.toByteArray());
                }
                MessagingService.instance().sendRR(message, target, handler);
            }
        }
    }

    private static void addHintHeader(Message message, InetAddress target) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        byte[] previousHints = message.getHeader("HINT");
        if (previousHints != null) {
            dos.write(previousHints);
        }
        ByteBufferUtil.writeWithShortLength(ByteBuffer.wrap(target.getHostAddress().getBytes(Charsets.UTF_8)), dos);
        message.setHeader("HINT", bos.toByteArray());
    }

    private static void insertLocal(final RowMutation rm, final IWriteResponseHandler responseHandler) {
        if (logger.isDebugEnabled()) {
            logger.debug("insert writing local " + rm.toString(true));
        }
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws IOException {
                rm.deepCopy().apply();
                responseHandler.response(null);
            }
        };
        StageManager.getStage(Stage.MUTATION).execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> read(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException, InvalidRequestException {
        List<Row> rows;
        if (StorageService.instance.isBootstrapMode()) {
            throw new UnavailableException();
        }
        long startTime = System.nanoTime();
        try {
            rows = StorageProxy.fetchRows(commands, consistency_level);
        }
        finally {
            readStats.addNano(System.nanoTime() - startTime);
        }
        return rows;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Row> fetchRows(List<ReadCommand> commands, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        Row row;
        ArrayList<ReadCallback<Row>> readCallbacks = new ArrayList<ReadCallback<Row>>();
        ArrayList<void> commandEndpoints = new ArrayList<void>();
        ArrayList<Row> rows = new ArrayList<Row>();
        HashSet<ReadCommand> repairs = new HashSet<ReadCommand>();
        for (ReadCommand command : commands) {
            InetAddress dataPoint;
            void var8_10;
            assert (!command.isDigestQuery());
            List<InetAddress> list = StorageService.instance.getLiveNaturalEndpoints(command.table, command.key);
            DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), list);
            ReadResponseResolver resolver = new ReadResponseResolver(command.table, command.key);
            ReadCallback<Row> handler = StorageProxy.getReadCallback(resolver, command.table, consistency_level);
            handler.assureSufficientLiveNodes(list);
            if (StorageProxy.randomlyReadRepair(command)) {
                if (list.size() > handler.blockfor) {
                    repairs.add(command);
                }
            } else {
                List<InetAddress> list2 = list.subList(0, handler.blockfor);
            }
            ReadCommand digestCommand = null;
            if (var8_10.size() > 1) {
                digestCommand = command.copy();
                digestCommand.setDigestQuery(true);
            }
            if ((dataPoint = (InetAddress)var8_10.get(0)).equals(FBUtilities.getLocalAddress())) {
                if (logger.isDebugEnabled()) {
                    logger.debug("reading data for " + command + " locally");
                }
                StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(command, handler));
            } else {
                Message message = command.makeReadMessage();
                if (logger.isDebugEnabled()) {
                    logger.debug("reading data for " + command + " from " + dataPoint);
                }
                MessagingService.instance().sendRR(message, dataPoint, handler);
            }
            Message digestMessage = null;
            for (InetAddress digestPoint : var8_10.subList(1, var8_10.size())) {
                if (digestPoint.equals(FBUtilities.getLocalAddress())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("reading digest for " + command + " locally");
                    }
                    StageManager.getStage(Stage.READ).execute(new LocalReadRunnable(digestCommand, handler));
                    continue;
                }
                if (digestMessage == null) {
                    digestMessage = digestCommand.makeReadMessage();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("reading digest for " + command + " from " + digestPoint);
                }
                MessagingService.instance().sendRR(digestMessage, digestPoint, handler);
            }
            readCallbacks.add(handler);
            commandEndpoints.add(var8_10);
        }
        ArrayList<RepairCallback<Row>> repairResponseHandlers = null;
        for (int i = 0; i < commands.size(); ++i) {
            ReadCallback readCallback = (ReadCallback)readCallbacks.get(i);
            ReadCommand command = commands.get(i);
            List endpoints = (List)commandEndpoints.get(i);
            try {
                long startTime2 = System.currentTimeMillis();
                row = (Row)readCallback.get();
                if (row != null) {
                    rows.add(row);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Read: " + (System.currentTimeMillis() - startTime2) + " ms.");
                }
                if (!repairs.contains(command)) continue;
                repairExecutor.schedule(new RepairRunner(readCallback.resolver, command, endpoints), DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
                continue;
            }
            catch (DigestMismatchException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Digest mismatch:", (Throwable)ex);
                }
                RepairCallback<Row> handler = StorageProxy.repair(command, endpoints);
                if (repairResponseHandlers == null) {
                    repairResponseHandlers = new ArrayList<RepairCallback<Row>>();
                }
                repairResponseHandlers.add(handler);
            }
        }
        if (repairResponseHandlers != null) {
            for (RepairCallback repairCallback : repairResponseHandlers) {
                try {
                    row = (Row)repairCallback.get();
                    if (row == null) continue;
                    rows.add(row);
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        return rows;
    }

    static <T> ReadCallback<T> getReadCallback(IResponseResolver<T> resolver, String table, ConsistencyLevel consistencyLevel) {
        if (consistencyLevel.equals((Object)ConsistencyLevel.LOCAL_QUORUM) || consistencyLevel.equals((Object)ConsistencyLevel.EACH_QUORUM)) {
            return new DatacenterReadCallback<T>(resolver, consistencyLevel, table);
        }
        return new ReadCallback<T>(resolver, consistencyLevel, table);
    }

    private static RepairCallback<Row> repair(ReadCommand command, List<InetAddress> endpoints) throws IOException {
        ReadResponseResolver resolver = new ReadResponseResolver(command.table, command.key);
        RepairCallback<Row> handler = new RepairCallback<Row>(resolver, endpoints);
        Message messageRepair = command.makeReadMessage();
        for (InetAddress endpoint : endpoints) {
            MessagingService.instance().sendRR(messageRepair, endpoint, handler);
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Row> getRangeSlice(RangeSliceCommand command, ConsistencyLevel consistency_level) throws IOException, UnavailableException, TimeoutException {
        ArrayList<Row> rows;
        if (logger.isDebugEnabled()) {
            logger.debug(command.toString());
        }
        long startTime = System.nanoTime();
        try {
            rows = new ArrayList<Row>(command.max_keys);
            List<AbstractBounds> ranges = StorageProxy.getRestrictedRanges(command.range);
            for (AbstractBounds range : ranges) {
                List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(command.keyspace, range.right);
                if (consistency_level == ConsistencyLevel.ONE && liveEndpoints.contains(FBUtilities.getLocalAddress())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("local range slice");
                    }
                    ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
                    try {
                        rows.addAll(cfs.getRangeSlice(command.super_column, range, command.max_keys, QueryFilter.getFilter(command.predicate, cfs.getComparator())));
                    }
                    catch (ExecutionException e) {
                        throw new RuntimeException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), liveEndpoints);
                RangeSliceCommand c2 = new RangeSliceCommand(command.keyspace, command.column_family, command.super_column, command.predicate, range, command.max_keys);
                Message message = c2.getMessage();
                RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(command.keyspace, liveEndpoints);
                AbstractReplicationStrategy rs = Table.open(command.keyspace).getReplicationStrategy();
                ReadCallback<List<Row>> handler = StorageProxy.getReadCallback(resolver, command.keyspace, consistency_level);
                for (InetAddress endpoint : liveEndpoints) {
                    MessagingService.instance().sendRR(message, endpoint, handler);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("reading " + c2 + " from " + endpoint);
                }
                try {
                    if (logger.isDebugEnabled()) {
                        for (Row row : handler.get()) {
                            logger.debug("range slices read " + row.key);
                        }
                    }
                    rows.addAll((Collection<Row>)handler.get());
                }
                catch (DigestMismatchException e) {
                    throw new AssertionError((Object)e);
                }
                if (rows.size() < command.max_keys) continue;
                break;
            }
        }
        finally {
            rangeStats.addNano(System.nanoTime() - startTime);
        }
        return rows.size() > command.max_keys ? rows.subList(0, command.max_keys) : rows;
    }

    public static Map<String, List<String>> describeSchemaVersions() {
        String myVersion = DatabaseDescriptor.getDefsVersion().toString();
        final ConcurrentHashMap versions = new ConcurrentHashMap();
        Set<InetAddress> liveHosts = Gossiper.instance.getLiveMembers();
        final CountDownLatch latch = new CountDownLatch(liveHosts.size());
        IAsyncCallback cb = new IAsyncCallback(){

            @Override
            public void response(Message message) {
                logger.debug("Received schema check response from " + message.getFrom().getHostAddress());
                UUID theirVersion = UUID.fromString(new String(message.getMessageBody()));
                versions.put(message.getFrom(), theirVersion);
                latch.countDown();
            }
        };
        for (InetAddress endpoint : liveHosts) {
            Message message = new Message(FBUtilities.getLocalAddress(), StorageService.Verb.SCHEMA_CHECK, ArrayUtils.EMPTY_BYTE_ARRAY);
            MessagingService.instance().sendRR(message, endpoint, cb);
        }
        try {
            latch.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)"This latch shouldn't have been interrupted.");
        }
        logger.debug("My version is " + myVersion);
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        HashSet<InetAddress> allHosts = new HashSet<InetAddress>();
        allHosts.addAll(Gossiper.instance.getLiveMembers());
        allHosts.addAll(Gossiper.instance.getUnreachableMembers());
        for (InetAddress inetAddress : allHosts) {
            UUID version = (UUID)versions.get(inetAddress);
            String stringVersion = version == null ? UNREACHABLE : version.toString();
            ArrayList<String> hosts = (ArrayList<String>)results.get(stringVersion);
            if (hosts == null) {
                hosts = new ArrayList<String>();
                results.put(stringVersion, hosts);
            }
            hosts.add(inetAddress.getHostAddress());
        }
        if (results.get(UNREACHABLE) != null) {
            logger.debug("Hosts not in agreement. Didn't get a response from everybody: " + StringUtils.join((Collection)((Collection)results.get(UNREACHABLE)), (String)","));
        }
        for (Map.Entry entry : results.entrySet()) {
            if (((String)entry.getKey()).equals(UNREACHABLE) || ((String)entry.getKey()).equals(myVersion)) continue;
            for (String host : (List)entry.getValue()) {
                logger.debug("%s disagrees (%s)", (Object)host, entry.getKey());
            }
        }
        if (results.size() == 1) {
            logger.debug("Schemas are in agreement.");
        }
        return results;
    }

    static List<AbstractBounds> getRestrictedRanges(AbstractBounds queryRange) {
        if (queryRange instanceof Bounds && queryRange.left.equals(queryRange.right) && !queryRange.left.equals(StorageService.getPartitioner().getMinimumToken())) {
            if (logger.isDebugEnabled()) {
                logger.debug("restricted single token match for query " + queryRange);
            }
            return Collections.singletonList(queryRange);
        }
        TokenMetadata tokenMetadata = StorageService.instance.getTokenMetadata();
        ArrayList<AbstractBounds> ranges = new ArrayList<AbstractBounds>();
        Iterator<Token> ringIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), queryRange.left, true);
        AbstractBounds remainder = queryRange;
        while (ringIter.hasNext()) {
            Token token = ringIter.next();
            if (remainder == null || !remainder.left.equals(token) && !remainder.contains(token)) break;
            Pair<AbstractBounds, AbstractBounds> splits = remainder.split(token);
            if (splits.left != null) {
                ranges.add((AbstractBounds)splits.left);
            }
            remainder = (AbstractBounds)splits.right;
        }
        if (remainder != null) {
            ranges.add(remainder);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("restricted ranges for query " + queryRange + " are " + ranges);
        }
        return ranges;
    }

    private static boolean randomlyReadRepair(ReadCommand command) {
        CFMetaData cfmd = DatabaseDescriptor.getTableMetaData(command.table).get(command.getColumnFamilyName());
        return cfmd.getReadRepairChance() > random.get().nextDouble();
    }

    @Override
    public long getReadOperations() {
        return readStats.getOpCount();
    }

    @Override
    public long getTotalReadLatencyMicros() {
        return readStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentReadLatencyMicros() {
        return readStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalReadLatencyHistogramMicros() {
        return readStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentReadLatencyHistogramMicros() {
        return readStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getRangeOperations() {
        return rangeStats.getOpCount();
    }

    @Override
    public long getTotalRangeLatencyMicros() {
        return rangeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentRangeLatencyMicros() {
        return rangeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalRangeLatencyHistogramMicros() {
        return rangeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentRangeLatencyHistogramMicros() {
        return rangeStats.getRecentLatencyHistogramMicros();
    }

    @Override
    public long getWriteOperations() {
        return writeStats.getOpCount();
    }

    @Override
    public long getTotalWriteLatencyMicros() {
        return writeStats.getTotalLatencyMicros();
    }

    @Override
    public double getRecentWriteLatencyMicros() {
        return writeStats.getRecentLatencyMicros();
    }

    @Override
    public long[] getTotalWriteLatencyHistogramMicros() {
        return writeStats.getTotalLatencyHistogramMicros();
    }

    @Override
    public long[] getRecentWriteLatencyHistogramMicros() {
        return writeStats.getRecentLatencyHistogramMicros();
    }

    public static List<Row> scan(String keyspace, String column_family, IndexClause index_clause, SlicePredicate column_predicate, ConsistencyLevel consistency_level) throws IOException, TimeoutException, UnavailableException {
        IPartitioner p = StorageService.getPartitioner();
        Object leftToken = index_clause.start_key == null ? p.getMinimumToken() : p.getToken(index_clause.start_key);
        List<AbstractBounds> ranges = StorageProxy.getRestrictedRanges(new Bounds((Token)leftToken, (Token)p.getMinimumToken()));
        logger.debug("scan ranges are " + StringUtils.join(ranges, (String)","));
        ArrayList<Row> rows = new ArrayList<Row>(index_clause.count);
        for (AbstractBounds range : ranges) {
            List<Row> theseRows;
            List<InetAddress> liveEndpoints = StorageService.instance.getLiveNaturalEndpoints(keyspace, range.right);
            DatabaseDescriptor.getEndpointSnitch().sortByProximity(FBUtilities.getLocalAddress(), liveEndpoints);
            RangeSliceResponseResolver resolver = new RangeSliceResponseResolver(keyspace, liveEndpoints);
            ReadCallback<List<Row>> handler = StorageProxy.getReadCallback(resolver, keyspace, consistency_level);
            if (handler.blockfor > liveEndpoints.size()) {
                throw new UnavailableException();
            }
            IndexScanCommand command = new IndexScanCommand(keyspace, column_family, index_clause, column_predicate, range);
            Message message = command.getMessage();
            for (InetAddress endpoint : liveEndpoints) {
                MessagingService.instance().sendRR(message, endpoint, handler);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("reading " + command + " from " + endpoint);
            }
            try {
                theseRows = handler.get();
            }
            catch (DigestMismatchException e) {
                throw new RuntimeException(e);
            }
            rows.addAll(theseRows);
            if (logger.isDebugEnabled()) {
                for (Row row : theseRows) {
                    logger.debug("read " + row);
                }
            }
            if (rows.size() < index_clause.count) continue;
            return rows.subList(0, index_clause.count);
        }
        return rows;
    }

    @Override
    public boolean getHintedHandoffEnabled() {
        return hintedHandoffEnabled;
    }

    @Override
    public void setHintedHandoffEnabled(boolean b) {
        hintedHandoffEnabled = b;
    }

    public static boolean isHintedHandoffEnabled() {
        return hintedHandoffEnabled;
    }

    @Override
    public int getMaxHintWindow() {
        return maxHintWindow;
    }

    @Override
    public void setMaxHintWindow(int ms) {
        maxHintWindow = ms;
    }

    public static boolean shouldHint(InetAddress ep) {
        return Gossiper.instance.getEndpointDowntime(ep) <= (long)maxHintWindow;
    }

    public static void truncateBlocking(String keyspace, String cfname) throws UnavailableException, TimeoutException, IOException {
        logger.debug("Starting a blocking truncate operation on keyspace {}, CF ", (Object)keyspace, (Object)cfname);
        if (StorageProxy.isAnyHostDown()) {
            logger.info("Cannot perform truncate, some hosts are down");
            throw new UnavailableException();
        }
        Set<InetAddress> allEndpoints = Gossiper.instance.getLiveMembers();
        int blockFor = allEndpoints.size();
        TruncateResponseHandler responseHandler = new TruncateResponseHandler(blockFor);
        logger.debug("Starting to send truncate messages to hosts {}", allEndpoints);
        Truncation truncation = new Truncation(keyspace, cfname);
        Message message = truncation.makeTruncationMessage();
        for (InetAddress endpoint : allEndpoints) {
            MessagingService.instance().sendRR(message, endpoint, responseHandler);
        }
        logger.debug("Sent all truncate messages, now waiting for {} responses", (Object)blockFor);
        responseHandler.get();
        logger.debug("truncate done");
    }

    private static boolean isAnyHostDown() {
        return !Gossiper.instance.getUnreachableMembers().isEmpty();
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(new StorageProxy(), new ObjectName("org.apache.cassandra.db:type=StorageProxy"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RepairRunner
    extends WrappedRunnable {
        private final IResponseResolver<Row> resolver;
        private final ReadCommand command;
        private final List<InetAddress> endpoints;

        public RepairRunner(IResponseResolver<Row> resolver, ReadCommand command, List<InetAddress> endpoints) {
            this.resolver = resolver;
            this.command = command;
            this.endpoints = endpoints;
        }

        @Override
        protected void runMayThrow() throws IOException {
            try {
                this.resolver.resolve();
            }
            catch (DigestMismatchException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Digest mismatch:", (Throwable)e);
                }
                final RepairCallback callback = StorageProxy.repair(this.command, this.endpoints);
                WrappedRunnable runnable = new WrappedRunnable(){

                    @Override
                    public void runMayThrow() throws DigestMismatchException, IOException, TimeoutException {
                        callback.get();
                    }
                };
                repairExecutor.schedule(runnable, DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
            }
        }
    }

    static class LocalReadRunnable
    extends WrappedRunnable {
        private final ReadCommand command;
        private final ReadCallback<Row> handler;
        private final long start = System.currentTimeMillis();

        LocalReadRunnable(ReadCommand command, ReadCallback<Row> handler) {
            this.command = command;
            this.handler = handler;
        }

        @Override
        protected void runMayThrow() throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug("LocalReadRunnable reading " + this.command);
            }
            Table table = Table.open(this.command.table);
            ReadResponse result = ReadVerbHandler.getResponse(this.command, this.command.getRow(table));
            MessagingService.instance().addLatency(FBUtilities.getLocalAddress(), System.currentTimeMillis() - this.start);
            this.handler.response(result);
        }
    }
}

