/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.thrift.ColumnParent;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.utils.ByteBufferUtil;

public class QueryPath {
    public final String columnFamilyName;
    public final ByteBuffer superColumnName;
    public final ByteBuffer columnName;

    public QueryPath(String columnFamilyName, ByteBuffer superColumnName, ByteBuffer columnName) {
        this.columnFamilyName = columnFamilyName;
        this.superColumnName = superColumnName;
        this.columnName = columnName;
    }

    public QueryPath(ColumnParent columnParent) {
        this(columnParent.column_family, columnParent.super_column, null);
    }

    public QueryPath(String columnFamilyName, ByteBuffer superColumnName) {
        this(columnFamilyName, superColumnName, null);
    }

    public QueryPath(String columnFamilyName) {
        this(columnFamilyName, null);
    }

    public QueryPath(ColumnPath column_path) {
        this(column_path.column_family, column_path.super_column, column_path.column);
    }

    public static QueryPath column(ByteBuffer columnName) {
        return new QueryPath(null, null, columnName);
    }

    public String toString() {
        return "QueryPath(columnFamilyName='" + this.columnFamilyName + '\'' + ", superColumnName='" + this.superColumnName + '\'' + ", columnName='" + this.columnName + '\'' + ')';
    }

    public void serialize(DataOutputStream dos) throws IOException {
        assert (!"".equals(this.columnFamilyName));
        assert (this.superColumnName == null || this.superColumnName.remaining() > 0);
        assert (this.columnName == null || this.columnName.remaining() > 0);
        dos.writeUTF(this.columnFamilyName == null ? "" : this.columnFamilyName);
        ByteBufferUtil.writeWithShortLength(this.superColumnName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.superColumnName, dos);
        ByteBufferUtil.writeWithShortLength(this.columnName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.columnName, dos);
    }

    public static QueryPath deserialize(DataInputStream din) throws IOException {
        String cfName = din.readUTF();
        ByteBuffer scName = ByteBufferUtil.readWithShortLength(din);
        ByteBuffer cName = ByteBufferUtil.readWithShortLength(din);
        return new QueryPath(cfName.isEmpty() ? null : cfName, scName.remaining() == 0 ? null : scName, cName.remaining() == 0 ? null : cName);
    }
}

