/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.utils.EstimatedHistogram;

public class LatencyTracker {
    private final AtomicLong opCount = new AtomicLong(0L);
    private final AtomicLong totalLatency = new AtomicLong(0L);
    private long lastLatency = 0L;
    private long lastOpCount = 0L;
    private EstimatedHistogram totalHistogram = new EstimatedHistogram();
    private EstimatedHistogram recentHistogram = new EstimatedHistogram();

    public void addNano(long nanos) {
        this.addMicro(nanos / 1000L);
    }

    public void addMicro(long micros) {
        this.opCount.incrementAndGet();
        this.totalLatency.addAndGet(micros);
        this.totalHistogram.add(micros);
        this.recentHistogram.add(micros);
    }

    public long getOpCount() {
        return this.opCount.get();
    }

    public long getTotalLatencyMicros() {
        return this.totalLatency.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRecentLatencyMicros() {
        long ops = this.opCount.get();
        long n = this.totalLatency.get();
        try {
            double d = ((double)n - (double)this.lastLatency) / (double)(ops - this.lastOpCount);
            return d;
        }
        finally {
            this.lastLatency = n;
            this.lastOpCount = ops;
        }
    }

    public long[] getTotalLatencyHistogramMicros() {
        return this.totalHistogram.get(false);
    }

    public long[] getRecentLatencyHistogramMicros() {
        return this.recentHistogram.get(true);
    }
}

