/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.BitSetSerializer;
import org.apache.cassandra.utils.BloomFilter;

class BloomFilterSerializer
implements ICompactSerializer<BloomFilter> {
    BloomFilterSerializer() {
    }

    @Override
    public void serialize(BloomFilter bf, DataOutputStream dos) throws IOException {
        dos.writeInt(bf.getHashCount());
        BitSetSerializer.serialize(bf.filter(), dos);
    }

    @Override
    public BloomFilter deserialize(DataInputStream dis) throws IOException {
        int hashes = dis.readInt();
        BitSet bs = BitSetSerializer.deserialize(dis);
        return new BloomFilter(hashes, bs);
    }
}

