/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;

public class BufferedRandomAccessFile
extends RandomAccessFile
implements FileDataInput {
    static final int LogBuffSz_ = 16;
    public static final int BuffSz_ = 65536;
    private String path_;
    private boolean dirty_;
    private boolean syncNeeded_;
    private long curr_;
    private long lo_;
    private long hi_;
    private byte[] buff_;
    private long maxHi_;
    private boolean hitEOF_;
    private long diskPos_;
    private long fileLength = -1L;

    public BufferedRandomAccessFile(File file, String mode) throws IOException {
        this(file, mode, 0);
    }

    public BufferedRandomAccessFile(File file, String mode, int size) throws IOException {
        super(file, mode);
        this.path_ = file.getAbsolutePath();
        this.init(size, mode);
    }

    public BufferedRandomAccessFile(String name, String mode) throws IOException {
        this(name, mode, 0);
    }

    public BufferedRandomAccessFile(String name, String mode, int size) throws IOException {
        super(name, mode);
        this.path_ = name;
        this.init(size, mode);
    }

    private void init(int size, String mode) throws IOException {
        this.dirty_ = false;
        this.hi_ = 0L;
        this.curr_ = 0L;
        this.lo_ = 0L;
        this.buff_ = size > 65536 ? new byte[size] : new byte[65536];
        this.maxHi_ = 65536L;
        this.hitEOF_ = false;
        this.diskPos_ = 0L;
        if ("r".equals(mode)) {
            this.fileLength = super.length();
        }
    }

    @Override
    public String getPath() {
        return this.path_;
    }

    public void sync() throws IOException {
        if (this.syncNeeded_) {
            this.flush();
            this.getChannel().force(true);
            this.syncNeeded_ = false;
        }
    }

    @Override
    public void close() throws IOException {
        this.sync();
        this.buff_ = null;
        super.close();
    }

    public void flush() throws IOException {
        if (this.dirty_) {
            if (this.diskPos_ != this.lo_) {
                super.seek(this.lo_);
            }
            int len = (int)(this.hi_ - this.lo_);
            super.write(this.buff_, 0, len);
            this.diskPos_ = this.hi_;
            this.dirty_ = false;
        }
    }

    private int fillBuffer() throws IOException {
        int n;
        int count = 0;
        for (int remainder = this.buff_.length; remainder > 0 && (n = super.read(this.buff_, count, remainder)) >= 0; remainder -= n) {
            count += n;
        }
        this.hitEOF_ = count < this.buff_.length;
        this.diskPos_ += (long)count;
        return count;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.curr_ = pos;
    }

    private void reBuffer() throws IOException {
        this.flush();
        this.lo_ = this.curr_;
        this.maxHi_ = this.lo_ + (long)this.buff_.length;
        if (this.diskPos_ != this.lo_) {
            super.seek(this.lo_);
            this.diskPos_ = this.lo_;
        }
        int n = this.fillBuffer();
        this.hi_ = this.lo_ + (long)n;
    }

    @Override
    public long getFilePointer() {
        return this.curr_;
    }

    @Override
    public long length() throws IOException {
        if (this.fileLength == -1L) {
            return Math.max(this.curr_, super.length());
        }
        return this.fileLength;
    }

    @Override
    public int read() throws IOException {
        if (this.lo_ > this.curr_ || this.curr_ >= this.hi_) {
            this.reBuffer();
            if (this.curr_ == this.hi_ && this.hitEOF_) {
                return -1;
            }
        }
        byte res = this.buff_[(int)(this.curr_ - this.lo_)];
        ++this.curr_;
        return res & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.lo_ > this.curr_ || this.curr_ >= this.hi_) {
            this.reBuffer();
            if (this.curr_ == this.hi_ && this.hitEOF_) {
                return -1;
            }
        }
        len = Math.min(len, (int)(this.hi_ - this.curr_));
        int buffOff = (int)(this.curr_ - this.lo_);
        System.arraycopy(this.buff_, buffOff, b, off, len);
        this.curr_ += (long)len;
        return len;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.lo_ > this.curr_ || this.curr_ > this.hi_ || this.curr_ >= this.maxHi_) {
            this.reBuffer();
        }
        this.buff_[(int)(this.curr_ - this.lo_)] = (byte)b;
        ++this.curr_;
        if (this.curr_ > this.hi_) {
            this.hi_ = this.curr_;
        }
        this.dirty_ = true;
        this.syncNeeded_ = true;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = this.writeAtMost(b, off, len);
            off += n;
            len -= n;
            this.dirty_ = true;
            this.syncNeeded_ = true;
        }
    }

    private int writeAtMost(byte[] b, int off, int len) throws IOException {
        if (this.lo_ > this.curr_ || this.curr_ > this.hi_ || this.curr_ >= this.maxHi_) {
            this.reBuffer();
        }
        len = Math.min(len, (int)(this.maxHi_ - this.curr_));
        int buffOff = (int)(this.curr_ - this.lo_);
        System.arraycopy(b, off, this.buff_, buffOff, len);
        this.curr_ += (long)len;
        if (this.curr_ > this.hi_) {
            this.hi_ = this.curr_;
        }
        return len;
    }

    @Override
    public boolean isEOF() throws IOException {
        return this.getFilePointer() == this.length();
    }

    @Override
    public long bytesRemaining() throws IOException {
        return this.length() - this.getFilePointer();
    }

    @Override
    public FileMark mark() {
        return new BufferedRandomAccessFileMark(this.getFilePointer());
    }

    @Override
    public void reset(FileMark mark) throws IOException {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public int bytesPastMark(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.getFilePointer() - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        if (bytes > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Overflow: " + bytes);
        }
        return (int)bytes;
    }

    private static class BufferedRandomAccessFileMark
    implements FileMark {
        long pointer;

        BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

