/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogUtil {
    public static void init() {
        String file = System.getProperty("storage-config");
        file = file + File.separator + "log4j.properties";
        PropertyConfigurator.configure((String)file);
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger((String)name);
    }

    public static String stackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static String getTimestamp() {
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return df.format(date);
    }

    public static String throwableToString(Throwable e) {
        StringBuilder sbuf = new StringBuilder("");
        String trace = LogUtil.stackTrace(e);
        sbuf.append("Exception was generated at : " + LogUtil.getTimestamp() + " on thread " + Thread.currentThread().getName());
        sbuf.append(System.getProperty("line.separator"));
        String message = e.getMessage();
        if (message != null) {
            sbuf.append(message);
        }
        sbuf.append(System.getProperty("line.separator")).append(trace);
        return sbuf.toString();
    }

    public static String getLogMessage(String message) {
        StringBuilder sbuf = new StringBuilder("Log started at : " + LogUtil.getTimestamp());
        sbuf.append(File.separator).append(message);
        return sbuf.toString();
    }

    public static void setLogLevel(String logger, String level) {
        Logger loggerObj = LogManager.getLogger((String)logger);
        if (null == loggerObj) {
            return;
        }
        if ((level = level.toUpperCase()).equals("DEBUG")) {
            loggerObj.setLevel(Level.DEBUG);
        } else if (level.equals("ERROR")) {
            loggerObj.setLevel(Level.ERROR);
        } else if (level.equals("FATAL")) {
            loggerObj.setLevel(Level.FATAL);
        } else if (level.equals("INFO")) {
            loggerObj.setLevel(Level.INFO);
        } else if (level.equals("OFF")) {
            loggerObj.setLevel(Level.OFF);
        } else if (level.equals("WARN")) {
            loggerObj.setLevel(Level.WARN);
        } else {
            loggerObj.setLevel(Level.ALL);
        }
    }
}

