/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.utils.MurmurHash;

public abstract class Filter {
    int hashCount;
    private static MurmurHash hasher = new MurmurHash();

    int getHashCount() {
        return this.hashCount;
    }

    public int[] getHashBuckets(String key) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    public int[] getHashBuckets(byte[] key) {
        return Filter.getHashBuckets(key, this.hashCount, this.buckets());
    }

    abstract int buckets();

    public abstract void add(String var1);

    public abstract boolean isPresent(String var1);

    abstract int emptyBuckets();

    ICompactSerializer<Filter> getSerializer() {
        Method method = null;
        try {
            method = this.getClass().getMethod("serializer", new Class[0]);
            return (ICompactSerializer)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int[] getHashBuckets(String key, int hashCount, int max) {
        byte[] b;
        try {
            b = key.getBytes("UTF-16");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return Filter.getHashBuckets(b, hashCount, max);
    }

    static int[] getHashBuckets(byte[] b, int hashCount, int max) {
        int[] result = new int[hashCount];
        int hash1 = hasher.hash(b, b.length, 0);
        int hash2 = hasher.hash(b, b.length, hash1);
        for (int i = 0; i < hashCount; ++i) {
            result[i] = Math.abs((hash1 + i * hash2) % max);
        }
        return result;
    }
}

