/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import org.apache.cassandra.utils.PrimeFinder;

public abstract class FastHash
implements Cloneable {
    protected transient int size_;
    protected transient int free_;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected float loadFactor_;
    protected int maxSize_;
    protected int autoCompactRemovesRemaining_;
    protected float autoCompactionFactor_;
    private boolean autoCompactTemporaryDisable_ = false;

    public FastHash() {
        this(10, 0.5f);
    }

    public FastHash(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public FastHash(int initialCapacity, float loadFactor) {
        this.loadFactor_ = loadFactor;
        this.autoCompactionFactor_ = loadFactor;
        this.setUp((int)Math.ceil((float)initialCapacity / loadFactor));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean isEmpty() {
        return 0 == this.size_;
    }

    public int size() {
        return this.size_;
    }

    protected abstract int capacity();

    public void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this.maxSize_ - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)desiredCapacity + (float)this.size() / this.loadFactor_) + 1));
            this.computeMaxSize(this.capacity());
        }
    }

    public void compact() {
        this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)this.size() / this.loadFactor_) + 1));
        this.computeMaxSize(this.capacity());
        if (this.autoCompactionFactor_ != 0.0f) {
            this.computeNextAutoCompactionAmount(this.size());
        }
    }

    public void setAutoCompactionFactor(float factor) {
        if (factor < 0.0f) {
            throw new IllegalArgumentException("Factor must be >= 0: " + factor);
        }
        this.autoCompactionFactor_ = factor;
    }

    public float getAutoCompactionFactor() {
        return this.autoCompactionFactor_;
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int index) {
        --this.size_;
        if (this.autoCompactionFactor_ != 0.0f) {
            --this.autoCompactRemovesRemaining_;
            if (!this.autoCompactTemporaryDisable_ && this.autoCompactRemovesRemaining_ <= 0) {
                this.compact();
            }
        }
    }

    public void clear() {
        this.size_ = 0;
        this.free_ = this.capacity();
    }

    protected int setUp(int initialCapacity) {
        int capacity = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(capacity);
        this.computeNextAutoCompactionAmount(initialCapacity);
        return capacity;
    }

    protected abstract void rehash(int var1);

    protected void tempDisableAutoCompaction() {
        this.autoCompactTemporaryDisable_ = true;
    }

    protected void reenableAutoCompaction(boolean check_for_compaction) {
        this.autoCompactTemporaryDisable_ = false;
        if (check_for_compaction && this.autoCompactRemovesRemaining_ <= 0 && this.autoCompactionFactor_ != 0.0f) {
            this.compact();
        }
    }

    private final void computeMaxSize(int capacity) {
        this.maxSize_ = Math.min(capacity - 1, (int)Math.floor((float)capacity * this.loadFactor_));
        this.free_ = capacity - this.size_;
    }

    private void computeNextAutoCompactionAmount(int size) {
        if (this.autoCompactionFactor_ != 0.0f) {
            this.autoCompactRemovesRemaining_ = Math.round((float)size * this.autoCompactionFactor_);
        }
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this.free_;
        }
        if (++this.size_ > this.maxSize_ || this.free_ == 0) {
            int newCapacity = this.size_ > this.maxSize_ ? PrimeFinder.nextPrime(this.capacity() << 1) : this.capacity();
            this.rehash(newCapacity);
            this.computeMaxSize(this.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }
}

