/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.DataInputBuffer;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class TokenUpdateVerbHandler
implements IVerbHandler {
    private static Logger logger_ = Logger.getLogger(TokenUpdateVerbHandler.class);

    @Override
    public void doVerb(Message message) {
        block6: {
            byte[] body = message.getMessageBody();
            try {
                DataInputBuffer bufIn = new DataInputBuffer();
                bufIn.reset(body, body.length);
                Token token = Token.serializer().deserialize(bufIn);
                logger_.info((Object)("Updating the token to [" + token + "]"));
                StorageService.instance().updateToken(token);
                Map<String, byte[]> headers = message.getHeaders();
                headers.remove(StorageService.getLocalStorageEndPoint().getHost());
                if (logger_.isDebugEnabled()) {
                    logger_.debug((Object)("Number of nodes in the header " + headers.size()));
                }
                Set<String> nodes = headers.keySet();
                IPartitioner p = StorageService.getPartitioner();
                Iterator<String> i$ = nodes.iterator();
                if (i$.hasNext()) {
                    String node = i$.next();
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Processing node " + node));
                    }
                    byte[] bytes = headers.remove(node);
                    EndPoint target = new EndPoint(node, DatabaseDescriptor.getStoragePort());
                    token = p.getTokenFactory().fromByteArray(bytes);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    DataOutputStream dos = new DataOutputStream(bos);
                    Token.serializer().serialize(token, dos);
                    message.setMessageBody(bos.toByteArray());
                    if (logger_.isDebugEnabled()) {
                        logger_.debug((Object)("Sending a token update message to " + target + " to update it to " + token));
                    }
                    MessagingService.getMessagingInstance().sendOneWay(message, target);
                }
            }
            catch (IOException ex) {
                if (!logger_.isDebugEnabled()) break block6;
                logger_.debug((Object)LogUtil.throwableToString(ex));
            }
        }
    }
}

