/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.utils.BloomFilter;

public class ThreadListBuilder {
    private static final int bufSize_ = 0x4000000;
    private static final int count_ = 0x8000000;

    public static void main(String[] args) throws Throwable {
        if (args.length != 2) {
            System.out.println("Usage : java org.apache.cassandra.tools.ThreadListBuilder <directory containing files to be processed> <directory to dump the bloom filter in.>");
            System.exit(1);
        }
        File directory = new File(args[0]);
        File[] files = directory.listFiles();
        ArrayList<DataOutputBuffer> buffers = new ArrayList<DataOutputBuffer>();
        BloomFilter bf = new BloomFilter(0x8000000, 8);
        int keyCount = 0;
        for (File file : files) {
            System.out.println("Processing file " + file);
            BufferedReader bufReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)), 0x4000000);
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                if (keyCount > 0 && keyCount % 0x8000000 == 0) {
                    DataOutputBuffer bufOut = new DataOutputBuffer();
                    BloomFilter.serializer().serialize(bf, bufOut);
                    System.out.println("Finished serializing the bloom filter");
                    buffers.add(bufOut);
                    bf = new BloomFilter(0x8000000, 8);
                }
                line = line.trim();
                bf.add(line);
                ++keyCount;
            }
        }
        DataOutputBuffer bufOut = new DataOutputBuffer();
        BloomFilter.serializer().serialize(bf, bufOut);
        buffers.add(bufOut);
        int size = buffers.size();
        for (int i = 0; i < size; ++i) {
            DataOutputBuffer buffer = (DataOutputBuffer)buffers.get(i);
            String file = args[1] + File.separator + "Bloom-Filter-" + i + ".dat";
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.write(buffer.getData(), 0, buffer.getLength());
            raf.close();
            buffer.close();
        }
        System.out.println("Done writing the bloom filter to disk");
    }
}

