/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.net.EndPoint;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.DigestMismatchException;
import org.apache.cassandra.service.IResponseResolver;
import org.apache.cassandra.service.QuorumResponseHandler;
import org.apache.cassandra.service.ReadResponseResolver;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class MultiQuorumResponseHandler
implements IAsyncCallback {
    private static Logger logger_ = Logger.getLogger(QuorumResponseHandler.class);
    private Lock lock_ = new ReentrantLock();
    private Condition condition_;
    private Map<String, ReadCommand> readMessages_ = new HashMap<String, ReadCommand>();
    private Map<String, EndPoint[]> endpoints_ = new HashMap<String, EndPoint[]>();
    private Map<String, SingleQuorumResponseHandler> handlers_ = new HashMap<String, SingleQuorumResponseHandler>();
    private List<Row> responses_ = new ArrayList<Row>();
    private AtomicBoolean done_ = new AtomicBoolean(false);

    public MultiQuorumResponseHandler(Map<String, ReadCommand> readMessages, Map<String, EndPoint[]> endpoints) {
        this.condition_ = this.lock_.newCondition();
        this.readMessages_ = readMessages;
        this.endpoints_ = endpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] get() throws TimeoutException {
        long startTime = System.currentTimeMillis();
        this.lock_.lock();
        try {
            boolean bVal;
            block8: {
                bVal = true;
                try {
                    if (!this.done_.get()) {
                        bVal = this.condition_.await(DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
                    }
                }
                catch (InterruptedException ex) {
                    if (!logger_.isDebugEnabled()) break block8;
                    logger_.debug((Object)LogUtil.throwableToString(ex));
                }
            }
            if (!bVal && !this.done_.get()) {
                StringBuilder sb = new StringBuilder("");
                for (Row row : this.responses_) {
                    sb.append(row.key());
                    sb.append(":");
                }
                throw new TimeoutException("Operation timed out - received only " + this.responses_.size() + " responses from " + sb.toString() + " .");
            }
        }
        finally {
            this.lock_.unlock();
        }
        logger_.info((Object)("MultiQuorumResponseHandler: " + (System.currentTimeMillis() - startTime) + " ms."));
        return this.responses_.toArray(new Row[0]);
    }

    void onCompleteResponse(Row row) {
        if (!this.done_.get()) {
            this.responses_.add(row);
            if (this.responses_.size() == this.readMessages_.size()) {
                this.done_.set(true);
                this.condition_.signal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(Message message) {
        this.lock_.lock();
        try {
            SingleQuorumResponseHandler handler = this.handlers_.get(message.getMessageId());
            handler.response(message);
        }
        finally {
            this.lock_.unlock();
        }
    }

    @Override
    public void attachContext(Object o) {
        String[] gids;
        for (String gid : gids = (String[])o) {
            ReadResponseResolver responseResolver = new ReadResponseResolver();
            SingleQuorumResponseHandler handler = new SingleQuorumResponseHandler(responseResolver);
            this.handlers_.put(gid, handler);
        }
    }

    private class SingleQuorumResponseHandler
    implements IAsyncCallback {
        private Lock lock_ = new ReentrantLock();
        private IResponseResolver<Row> responseResolver_;
        private List<Message> responses_ = new ArrayList<Message>();

        SingleQuorumResponseHandler(IResponseResolver<Row> responseResolver) {
            this.responseResolver_ = responseResolver;
        }

        @Override
        public void attachContext(Object o) {
            throw new UnsupportedOperationException("This operation is not supported in this implementation");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void response(Message response) {
            this.lock_.lock();
            try {
                this.responses_.add(response);
                int majority = (DatabaseDescriptor.getReplicationFactor() >> 1) + 1;
                if (this.responses_.size() >= majority && this.responseResolver_.isDataPresent(this.responses_)) {
                    this.onCompletion();
                }
            }
            catch (IOException ex) {
                logger_.info((Object)LogUtil.throwableToString(ex));
            }
            finally {
                this.lock_.unlock();
            }
        }

        private void onCompletion() throws IOException {
            try {
                Row row = this.responseResolver_.resolve(this.responses_);
                MultiQuorumResponseHandler.this.onCompleteResponse(row);
            }
            catch (DigestMismatchException ex) {
                String key = ex.getMessage();
                this.onDigestMismatch(key);
            }
        }

        private void onDigestMismatch(String key) throws IOException {
            if (DatabaseDescriptor.getConsistencyCheck()) {
                ReadCommand readCommand = (ReadCommand)MultiQuorumResponseHandler.this.readMessages_.get(key);
                readCommand.setDigestQuery(false);
                Message messageRepair = readCommand.makeReadMessage();
                EndPoint[] endpoints = (EndPoint[])MultiQuorumResponseHandler.this.endpoints_.get(readCommand.key);
                Message[][] messages = new Message[][]{{messageRepair, messageRepair, messageRepair}};
                EndPoint[][] epList = new EndPoint[][]{endpoints};
                MessagingService.getMessagingInstance().sendRR(messages, epList, (IAsyncCallback)MultiQuorumResponseHandler.this);
            }
        }
    }
}

