/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class ColumnPath
implements TBase,
Serializable,
Cloneable,
Comparable<ColumnPath> {
    private static final TStruct STRUCT_DESC = new TStruct("ColumnPath");
    private static final TField COLUMN_FAMILY_FIELD_DESC = new TField("column_family", 11, 3);
    private static final TField SUPER_COLUMN_FIELD_DESC = new TField("super_column", 11, 4);
    private static final TField COLUMN_FIELD_DESC = new TField("column", 11, 5);
    public String column_family;
    public byte[] super_column;
    public byte[] column;
    public static final int COLUMN_FAMILY = 3;
    public static final int SUPER_COLUMN = 4;
    public static final int COLUMN = 5;
    public static final Map<Integer, FieldMetaData> metaDataMap = Collections.unmodifiableMap(new HashMap<Integer, FieldMetaData>(){
        {
            this.put(3, new FieldMetaData("column_family", 1, new FieldValueMetaData(11)));
            this.put(4, new FieldMetaData("super_column", 2, new FieldValueMetaData(11)));
            this.put(5, new FieldMetaData("column", 2, new FieldValueMetaData(11)));
        }
    });

    public ColumnPath() {
    }

    public ColumnPath(String column_family, byte[] super_column, byte[] column) {
        this();
        this.column_family = column_family;
        this.super_column = super_column;
        this.column = column;
    }

    public ColumnPath(ColumnPath other) {
        if (other.isSetColumn_family()) {
            this.column_family = other.column_family;
        }
        if (other.isSetSuper_column()) {
            this.super_column = new byte[other.super_column.length];
            System.arraycopy(other.super_column, 0, this.super_column, 0, other.super_column.length);
        }
        if (other.isSetColumn()) {
            this.column = new byte[other.column.length];
            System.arraycopy(other.column, 0, this.column, 0, other.column.length);
        }
    }

    public ColumnPath deepCopy() {
        return new ColumnPath(this);
    }

    @Deprecated
    public ColumnPath clone() {
        return new ColumnPath(this);
    }

    public String getColumn_family() {
        return this.column_family;
    }

    public ColumnPath setColumn_family(String column_family) {
        this.column_family = column_family;
        return this;
    }

    public void unsetColumn_family() {
        this.column_family = null;
    }

    public boolean isSetColumn_family() {
        return this.column_family != null;
    }

    public void setColumn_familyIsSet(boolean value) {
        if (!value) {
            this.column_family = null;
        }
    }

    public byte[] getSuper_column() {
        return this.super_column;
    }

    public ColumnPath setSuper_column(byte[] super_column) {
        this.super_column = super_column;
        return this;
    }

    public void unsetSuper_column() {
        this.super_column = null;
    }

    public boolean isSetSuper_column() {
        return this.super_column != null;
    }

    public void setSuper_columnIsSet(boolean value) {
        if (!value) {
            this.super_column = null;
        }
    }

    public byte[] getColumn() {
        return this.column;
    }

    public ColumnPath setColumn(byte[] column) {
        this.column = column;
        return this;
    }

    public void unsetColumn() {
        this.column = null;
    }

    public boolean isSetColumn() {
        return this.column != null;
    }

    public void setColumnIsSet(boolean value) {
        if (!value) {
            this.column = null;
        }
    }

    public void setFieldValue(int fieldID, Object value) {
        switch (fieldID) {
            case 3: {
                if (value == null) {
                    this.unsetColumn_family();
                    break;
                }
                this.setColumn_family((String)value);
                break;
            }
            case 4: {
                if (value == null) {
                    this.unsetSuper_column();
                    break;
                }
                this.setSuper_column((byte[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    this.unsetColumn();
                    break;
                }
                this.setColumn((byte[])value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 3: {
                return this.getColumn_family();
            }
            case 4: {
                return this.getSuper_column();
            }
            case 5: {
                return this.getColumn();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean isSet(int fieldID) {
        switch (fieldID) {
            case 3: {
                return this.isSetColumn_family();
            }
            case 4: {
                return this.isSetSuper_column();
            }
            case 5: {
                return this.isSetColumn();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ColumnPath) {
            return this.equals((ColumnPath)that);
        }
        return false;
    }

    public boolean equals(ColumnPath that) {
        if (that == null) {
            return false;
        }
        boolean this_present_column_family = this.isSetColumn_family();
        boolean that_present_column_family = that.isSetColumn_family();
        if (this_present_column_family || that_present_column_family) {
            if (!this_present_column_family || !that_present_column_family) {
                return false;
            }
            if (!this.column_family.equals(that.column_family)) {
                return false;
            }
        }
        boolean this_present_super_column = this.isSetSuper_column();
        boolean that_present_super_column = that.isSetSuper_column();
        if (this_present_super_column || that_present_super_column) {
            if (!this_present_super_column || !that_present_super_column) {
                return false;
            }
            if (!Arrays.equals(this.super_column, that.super_column)) {
                return false;
            }
        }
        boolean this_present_column = this.isSetColumn();
        boolean that_present_column = that.isSetColumn();
        if (this_present_column || that_present_column) {
            if (!this_present_column || !that_present_column) {
                return false;
            }
            if (!Arrays.equals(this.column, that.column)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(ColumnPath other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        ColumnPath typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetColumn_family()).compareTo(this.isSetColumn_family());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo((String)this.column_family, (String)typedOther.column_family);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSuper_column()).compareTo(this.isSetSuper_column());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo((byte[])this.super_column, (byte[])typedOther.super_column);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn()).compareTo(this.isSetColumn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo((byte[])this.column, (byte[])typedOther.column);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 3: {
                    if (field.type == 11) {
                        this.column_family = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 11) {
                        this.super_column = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 11) {
                        this.column = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.column_family != null) {
            oprot.writeFieldBegin(COLUMN_FAMILY_FIELD_DESC);
            oprot.writeString(this.column_family);
            oprot.writeFieldEnd();
        }
        if (this.super_column != null && this.isSetSuper_column()) {
            oprot.writeFieldBegin(SUPER_COLUMN_FIELD_DESC);
            oprot.writeBinary(this.super_column);
            oprot.writeFieldEnd();
        }
        if (this.column != null && this.isSetColumn()) {
            oprot.writeFieldBegin(COLUMN_FIELD_DESC);
            oprot.writeBinary(this.column);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder("ColumnPath(");
        boolean first = true;
        sb.append("column_family:");
        if (this.column_family == null) {
            sb.append("null");
        } else {
            sb.append(this.column_family);
        }
        first = false;
        if (this.isSetSuper_column()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("super_column:");
            if (this.super_column == null) {
                sb.append("null");
            } else {
                int __super_column_size = Math.min(this.super_column.length, 128);
                for (i = 0; i < __super_column_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.super_column[i]).length() > 1 ? Integer.toHexString(this.super_column[i]).substring(Integer.toHexString(this.super_column[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.super_column[i]).toUpperCase());
                }
                if (this.super_column.length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        if (this.isSetColumn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column:");
            if (this.column == null) {
                sb.append("null");
            } else {
                int __column_size = Math.min(this.column.length, 128);
                for (i = 0; i < __column_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.column[i]).length() > 1 ? Integer.toHexString(this.column[i]).substring(Integer.toHexString(this.column[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.column[i]).toUpperCase());
                }
                if (this.column.length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.column_family == null) {
            throw new TProtocolException("Required field 'column_family' was not present! Struct: " + this.toString());
        }
    }

    static {
        FieldMetaData.addStructMetaDataMap(ColumnPath.class, metaDataMap);
    }
}

