/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net.io;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.io.ICompactSerializer;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.io.IStreamComplete;
import org.apache.cassandra.service.StorageService;
import org.apache.log4j.Logger;

public class StreamContextManager {
    private static Logger logger_ = Logger.getLogger(StreamContextManager.class);
    public static final Map<String, List<StreamContext>> ctxBag_ = new Hashtable<String, List<StreamContext>>();
    public static final Map<String, List<StreamStatus>> streamStatusBag_ = new Hashtable<String, List<StreamStatus>>();
    public static final Map<String, IStreamComplete> streamNotificationHandlers_ = new HashMap<String, IStreamComplete>();

    public static synchronized StreamContext getStreamContext(String key) {
        List<StreamContext> context = ctxBag_.get(key);
        if (context == null) {
            throw new IllegalStateException("Streaming context has not been set.");
        }
        StreamContext streamContext = context.remove(0);
        if (context.isEmpty()) {
            ctxBag_.remove(key);
        }
        return streamContext;
    }

    public static synchronized StreamStatus getStreamStatus(String key) {
        List<StreamStatus> status = streamStatusBag_.get(key);
        if (status == null) {
            throw new IllegalStateException("Streaming status has not been set.");
        }
        StreamStatus streamStatus = status.remove(0);
        if (status.isEmpty()) {
            streamStatusBag_.remove(key);
        }
        return streamStatus;
    }

    public static synchronized boolean isDone(String key) {
        return ctxBag_.get(key) == null;
    }

    public static synchronized IStreamComplete getStreamCompletionHandler(String key) {
        return streamNotificationHandlers_.get(key);
    }

    public static synchronized void removeStreamCompletionHandler(String key) {
        streamNotificationHandlers_.remove(key);
    }

    public static synchronized void registerStreamCompletionHandler(String key, IStreamComplete streamComplete) {
        streamNotificationHandlers_.put(key, streamComplete);
    }

    public static synchronized void addStreamContext(String key, StreamContext streamContext, StreamStatus streamStatus) {
        List<StreamContext> context = ctxBag_.get(key);
        if (context == null) {
            context = new ArrayList<StreamContext>();
            ctxBag_.put(key, context);
        }
        context.add(streamContext);
        List<StreamStatus> status = streamStatusBag_.get(key);
        if (status == null) {
            status = new ArrayList<StreamStatus>();
            streamStatusBag_.put(key, status);
        }
        status.add(streamStatus);
    }

    public static class StreamStatusMessageSerializer
    implements ICompactSerializer<StreamStatusMessage> {
        @Override
        public void serialize(StreamStatusMessage streamStatusMessage, DataOutputStream dos) throws IOException {
            StreamStatus.serializer().serialize(streamStatusMessage.streamStatus_, dos);
        }

        @Override
        public StreamStatusMessage deserialize(DataInputStream dis) throws IOException {
            StreamStatus streamStatus = StreamStatus.serializer().deserialize(dis);
            return new StreamStatusMessage(streamStatus);
        }
    }

    public static class StreamStatusMessage
    implements Serializable {
        private static ICompactSerializer<StreamStatusMessage> serializer_ = new StreamStatusMessageSerializer();
        protected StreamStatus streamStatus_;

        public static ICompactSerializer<StreamStatusMessage> serializer() {
            return serializer_;
        }

        public static Message makeStreamStatusMessage(StreamStatusMessage streamStatusMessage) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            StreamStatusMessage.serializer().serialize(streamStatusMessage, dos);
            return new Message(StorageService.getLocalStorageEndPoint(), "", "BOOTSTRAP-TERMINATE-VERB-HANDLER", bos.toByteArray());
        }

        public StreamStatusMessage(StreamStatus streamStatus) {
            this.streamStatus_ = streamStatus;
        }

        public StreamStatus getStreamStatus() {
            return this.streamStatus_;
        }
    }

    public static class StreamStatusSerializer
    implements ICompactSerializer<StreamStatus> {
        @Override
        public void serialize(StreamStatus streamStatus, DataOutputStream dos) throws IOException {
            dos.writeUTF(streamStatus.getFile());
            dos.writeLong(streamStatus.getExpectedBytes());
            dos.writeInt(streamStatus.getAction().ordinal());
        }

        @Override
        public StreamStatus deserialize(DataInputStream dis) throws IOException {
            String targetFile = dis.readUTF();
            long expectedBytes = dis.readLong();
            StreamStatus streamStatus = new StreamStatus(targetFile, expectedBytes);
            int ordinal = dis.readInt();
            if (ordinal == StreamCompletionAction.DELETE.ordinal()) {
                streamStatus.setAction(StreamCompletionAction.DELETE);
            } else if (ordinal == StreamCompletionAction.STREAM.ordinal()) {
                streamStatus.setAction(StreamCompletionAction.STREAM);
            }
            return streamStatus;
        }
    }

    public static class StreamStatus
    implements Serializable {
        private static ICompactSerializer<StreamStatus> serializer_ = new StreamStatusSerializer();
        private String file_;
        private long expectedBytes_;
        private StreamCompletionAction action_;

        public static ICompactSerializer<StreamStatus> serializer() {
            return serializer_;
        }

        public StreamStatus(String file, long expectedBytes) {
            this.file_ = file;
            this.expectedBytes_ = expectedBytes;
            this.action_ = StreamCompletionAction.DELETE;
        }

        public String getFile() {
            return this.file_;
        }

        public long getExpectedBytes() {
            return this.expectedBytes_;
        }

        void setAction(StreamCompletionAction action) {
            this.action_ = action;
        }

        public StreamCompletionAction getAction() {
            return this.action_;
        }
    }

    public static class StreamContextSerializer
    implements ICompactSerializer<StreamContext> {
        @Override
        public void serialize(StreamContext sc, DataOutputStream dos) throws IOException {
            dos.writeUTF(sc.targetFile_);
            dos.writeLong(sc.expectedBytes_);
            dos.writeUTF(sc.table_);
        }

        @Override
        public StreamContext deserialize(DataInputStream dis) throws IOException {
            String targetFile = dis.readUTF();
            long expectedBytes = dis.readLong();
            String table = dis.readUTF();
            return new StreamContext(targetFile, expectedBytes, table);
        }
    }

    public static class StreamContext
    implements Serializable {
        private static Logger logger_ = Logger.getLogger(StreamContext.class);
        private static ICompactSerializer<StreamContext> serializer_ = new StreamContextSerializer();
        private String targetFile_;
        private long expectedBytes_;
        private String table_;

        public static ICompactSerializer<StreamContext> serializer() {
            return serializer_;
        }

        public StreamContext(String targetFile, long expectedBytes, String table) {
            this.targetFile_ = targetFile;
            this.expectedBytes_ = expectedBytes;
            this.table_ = table;
        }

        public String getTable() {
            return this.table_;
        }

        public String getTargetFile() {
            return this.targetFile_;
        }

        public void setTargetFile(String file) {
            this.targetFile_ = file;
        }

        public long getExpectedBytes() {
            return this.expectedBytes_;
        }

        public boolean equals(Object o) {
            if (!(o instanceof StreamContext)) {
                return false;
            }
            StreamContext rhs = (StreamContext)o;
            return this.targetFile_.equals(rhs.targetFile_);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return this.targetFile_ + ":" + this.expectedBytes_;
        }
    }

    public static enum StreamCompletionAction {
        DELETE,
        STREAM;

    }
}

