/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.LogUtil;
import org.apache.log4j.Logger;

public class EndPoint
implements Serializable,
Comparable<EndPoint> {
    private static Logger logger_ = Logger.getLogger(EndPoint.class);
    private static final long serialVersionUID = -4962625949179835907L;
    private static Map<CharBuffer, String> hostNames_ = new HashMap<CharBuffer, String>();
    protected static final int sentinelPort_ = 5555;
    protected static EndPoint sentinelLocalEndPoint_;
    private String host_;
    private int port_;
    private transient InetSocketAddress ia_;

    public EndPoint(String host, int port) {
        assert (host.matches("\\d+\\.\\d+\\.\\d+\\.\\d+")) : host;
        this.host_ = host;
        this.port_ = port;
    }

    public EndPoint(int port) {
        try {
            this.host_ = FBUtilities.getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.port_ = port;
    }

    public String getHost() {
        return this.host_;
    }

    public int getPort() {
        return this.port_;
    }

    public void setPort(int port) {
        this.port_ = port;
    }

    public InetSocketAddress getInetAddress() {
        if (this.ia_ == null || this.ia_.isUnresolved()) {
            this.ia_ = new InetSocketAddress(this.host_, this.port_);
        }
        return this.ia_;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EndPoint)) {
            return false;
        }
        EndPoint rhs = (EndPoint)o;
        return this.host_.equals(rhs.host_) && this.port_ == rhs.port_;
    }

    public int hashCode() {
        return (this.host_ + this.port_).hashCode();
    }

    @Override
    public int compareTo(EndPoint rhs) {
        return this.host_.compareTo(rhs.host_);
    }

    public String toString() {
        return this.host_ + ":" + this.port_;
    }

    public static EndPoint fromString(String str) {
        String[] values = str.split(":");
        return new EndPoint(values[0], Integer.parseInt(values[1]));
    }

    public static byte[] toBytes(EndPoint ep) {
        ByteBuffer buffer = ByteBuffer.allocate(6);
        byte[] iaBytes = ep.getInetAddress().getAddress().getAddress();
        buffer.put(iaBytes);
        buffer.put(MessagingService.toByteArray((short)ep.getPort()));
        buffer.flip();
        return buffer.array();
    }

    public static EndPoint fromBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        System.arraycopy(bytes, 0, buffer.array(), 0, 4);
        byte[] portBytes = new byte[2];
        System.arraycopy(bytes, 4, portBytes, 0, portBytes.length);
        try {
            CharBuffer charBuffer = buffer.asCharBuffer();
            String host = hostNames_.get(charBuffer);
            if (host == null) {
                host = InetAddress.getByAddress(buffer.array()).getHostAddress();
                hostNames_.put(charBuffer, host);
            }
            short port = MessagingService.byteArrayToShort(portBytes);
            return new EndPoint(host, port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        try {
            sentinelLocalEndPoint_ = new EndPoint(FBUtilities.getHostAddress(), 5555);
        }
        catch (IOException ex) {
            logger_.warn((Object)LogUtil.throwableToString(ex));
        }
    }
}

