/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.net.EndPoint;
import org.apache.log4j.Logger;

public abstract class AbstractReplicationStrategy {
    protected static final Logger logger_ = Logger.getLogger(AbstractReplicationStrategy.class);
    protected TokenMetadata tokenMetadata_;
    protected IPartitioner partitioner_;
    protected int replicas_;
    protected int storagePort_;

    AbstractReplicationStrategy(TokenMetadata tokenMetadata, IPartitioner partitioner, int replicas, int storagePort) {
        this.tokenMetadata_ = tokenMetadata;
        this.partitioner_ = partitioner;
        this.replicas_ = replicas;
        this.storagePort_ = storagePort;
    }

    public abstract EndPoint[] getWriteStorageEndPoints(Token var1);

    public abstract EndPoint[] getReadStorageEndPoints(Token var1, Map<Token, EndPoint> var2);

    public abstract EndPoint[] getReadStorageEndPoints(Token var1);

    public Map<EndPoint, EndPoint> getHintedStorageEndPoints(Token token) {
        return this.getHintedMapForEndpoints(this.getWriteStorageEndPoints(token));
    }

    protected void retrofitPorts(List<EndPoint> eps) {
        for (EndPoint ep : eps) {
            ep.setPort(this.storagePort_);
        }
    }

    protected EndPoint getNextAvailableEndPoint(EndPoint startPoint, List<EndPoint> topN, List<EndPoint> liveNodes) {
        int startIndex;
        EndPoint endPoint = null;
        Map<Token, EndPoint> tokenToEndPointMap = this.tokenMetadata_.cloneTokenEndPointMap();
        ArrayList<Token> tokens = new ArrayList<Token>(tokenToEndPointMap.keySet());
        Collections.sort(tokens);
        Token token = this.tokenMetadata_.getToken(startPoint);
        int index = Collections.binarySearch(tokens, token);
        if (index < 0 && (index = (index + 1) * -1) >= tokens.size()) {
            index = 0;
        }
        int totalNodes = tokens.size();
        int i = startIndex = (index + 1) % totalNodes;
        for (int count = 1; count < totalNodes; ++count) {
            EndPoint tmpEndPoint = tokenToEndPointMap.get(tokens.get(i));
            if (FailureDetector.instance().isAlive(tmpEndPoint) && !topN.contains(tmpEndPoint) && !liveNodes.contains(tmpEndPoint)) {
                endPoint = tmpEndPoint;
                break;
            }
            i = (i + 1) % totalNodes;
        }
        return endPoint;
    }

    private Map<EndPoint, EndPoint> getHintedMapForEndpoints(EndPoint[] topN) {
        ArrayList<EndPoint> liveList = new ArrayList<EndPoint>();
        HashMap<EndPoint, EndPoint> map = new HashMap<EndPoint, EndPoint>();
        for (int i = 0; i < topN.length; ++i) {
            if (FailureDetector.instance().isAlive(topN[i])) {
                map.put(topN[i], topN[i]);
                liveList.add(topN[i]);
                continue;
            }
            EndPoint endPoint = this.getNextAvailableEndPoint(topN[i], Arrays.asList(topN), liveList);
            if (endPoint != null) {
                map.put(endPoint, topN[i]);
                liveList.add(endPoint);
                continue;
            }
            logger_.warn((Object)"Unable to find a live Endpoint we might be out of live nodes , This is dangerous !!!!");
        }
        return map;
    }
}

