/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.BufferedRandomAccessFile;
import org.apache.cassandra.io.DataOutputBuffer;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.io.SSTableReader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.log4j.Logger;

public class SSTableWriter
extends SSTable {
    private static Logger logger = Logger.getLogger(SSTableWriter.class);
    private long keysWritten;
    private BufferedRandomAccessFile dataFile;
    private BufferedRandomAccessFile indexFile;
    private String lastWrittenKey;
    private BloomFilter bf;

    public SSTableWriter(String filename, int keyCount, IPartitioner partitioner) throws IOException {
        super(filename, partitioner);
        this.dataFile = new BufferedRandomAccessFile(this.path, "rw", (int)(DatabaseDescriptor.getFlushDataBufferSizeInMB() * 1024.0 * 1024.0));
        this.indexFile = new BufferedRandomAccessFile(this.indexFilename(), "rw", (int)(DatabaseDescriptor.getFlushIndexBufferSizeInMB() * 1024.0 * 1024.0));
        this.bf = new BloomFilter(keyCount, 15);
    }

    private long beforeAppend(String decoratedKey) throws IOException {
        if (decoratedKey == null) {
            throw new IOException("Keys must not be null.");
        }
        Comparator<String> c = this.partitioner.getDecoratedKeyComparator();
        if (this.lastWrittenKey != null && c.compare(this.lastWrittenKey, decoratedKey) > 0) {
            logger.info((Object)("Last written key : " + this.lastWrittenKey));
            logger.info((Object)("Current key : " + decoratedKey));
            logger.info((Object)("Writing into file " + this.path));
            throw new IOException("Keys must be written in ascending order.");
        }
        return this.lastWrittenKey == null ? 0L : this.dataFile.getFilePointer();
    }

    private void afterAppend(String decoratedKey, long position) throws IOException {
        this.bf.add(decoratedKey);
        this.lastWrittenKey = decoratedKey;
        long indexPosition = this.indexFile.getFilePointer();
        this.indexFile.writeUTF(decoratedKey);
        this.indexFile.writeLong(position);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("wrote " + decoratedKey + " at " + position));
        }
        if (this.keysWritten++ % 128L != 0L) {
            return;
        }
        if (this.indexPositions == null) {
            this.indexPositions = new ArrayList();
        }
        this.indexPositions.add(new SSTable.KeyPosition(decoratedKey, indexPosition));
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("wrote index of " + decoratedKey + " at " + indexPosition));
        }
    }

    public void append(String decoratedKey, DataOutputBuffer buffer) throws IOException {
        long currentPosition = this.beforeAppend(decoratedKey);
        this.dataFile.writeUTF(decoratedKey);
        int length = buffer.getLength();
        assert (length > 0);
        this.dataFile.writeInt(length);
        this.dataFile.write(buffer.getData(), 0, length);
        this.afterAppend(decoratedKey, currentPosition);
    }

    public void append(String decoratedKey, byte[] value) throws IOException {
        long currentPosition = this.beforeAppend(decoratedKey);
        this.dataFile.writeUTF(decoratedKey);
        assert (value.length > 0);
        this.dataFile.writeInt(value.length);
        this.dataFile.write(value);
        this.afterAppend(decoratedKey, currentPosition);
    }

    public SSTableReader closeAndOpenReader() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.filterFilename());
        DataOutputStream stream = new DataOutputStream(fos);
        BloomFilter.serializer().serialize(this.bf, stream);
        stream.flush();
        fos.getFD().sync();
        stream.close();
        this.indexFile.getChannel().force(true);
        this.indexFile.close();
        this.dataFile.close();
        SSTableWriter.rename(this.indexFilename());
        SSTableWriter.rename(this.filterFilename());
        this.path = SSTableWriter.rename(this.path);
        return new SSTableReader(this.path, this.partitioner, this.indexPositions, this.bf);
    }

    static String rename(String tmpFilename) {
        String filename = tmpFilename.replace("-tmp", "");
        new File(tmpFilename).renameTo(new File(filename));
        return filename;
    }

    public static SSTableReader renameAndOpen(String dataFileName) throws IOException {
        SSTableWriter.rename(SSTableWriter.indexFilename(dataFileName));
        SSTableWriter.rename(SSTableWriter.filterFilename(dataFileName));
        dataFileName = SSTableWriter.rename(dataFileName);
        return SSTableReader.open(dataFileName, StorageService.getPartitioner());
    }
}

