/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.BufferedRandomAccessFile;
import org.apache.cassandra.io.FileSSTableMap;
import org.apache.cassandra.io.FileStruct;
import org.apache.cassandra.io.SSTable;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.FileUtils;
import org.apache.log4j.Logger;

public class SSTableReader
extends SSTable {
    private static final Logger logger = Logger.getLogger(SSTableReader.class);
    private static final FileSSTableMap openedFiles = new FileSSTableMap();

    public static int indexInterval() {
        return 128;
    }

    public static int getApproximateKeyCount(List<String> dataFiles) {
        int count = 0;
        for (String dataFileName : dataFiles) {
            SSTableReader sstable = openedFiles.get(dataFileName);
            assert (sstable != null);
            int indexKeyCount = sstable.getIndexPositions().size();
            count += (indexKeyCount + 1) * 128;
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("index size for bloom filter calc for file  : " + dataFileName + "   : " + count));
        }
        return count;
    }

    public static List<String> getIndexedKeys() {
        ArrayList<String> indexedKeys = new ArrayList<String>();
        for (SSTableReader sstable : openedFiles.values()) {
            for (SSTable.KeyPosition kp : sstable.getIndexPositions()) {
                indexedKeys.add(kp.key);
            }
        }
        Collections.sort(indexedKeys);
        return indexedKeys;
    }

    public static synchronized SSTableReader open(String dataFileName) throws IOException {
        return SSTableReader.open(dataFileName, StorageService.getPartitioner());
    }

    public static synchronized SSTableReader open(String dataFileName, IPartitioner partitioner) throws IOException {
        SSTableReader sstable = openedFiles.get(dataFileName);
        if (sstable == null) {
            assert (partitioner != null);
            sstable = new SSTableReader(dataFileName, partitioner);
            long start = System.currentTimeMillis();
            sstable.loadIndexFile();
            sstable.loadBloomFilter();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("INDEX LOAD TIME for " + dataFileName + ": " + (System.currentTimeMillis() - start) + " ms."));
            }
            openedFiles.put(dataFileName, sstable);
        }
        return sstable;
    }

    public static synchronized SSTableReader get(String dataFileName) {
        SSTableReader sstable = openedFiles.get(dataFileName);
        assert (sstable != null);
        return sstable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SSTableReader(String filename, IPartitioner partitioner, List<SSTable.KeyPosition> indexPositions, BloomFilter bloomFilter) {
        super(filename, partitioner);
        this.indexPositions = indexPositions;
        this.bf = bloomFilter;
        SSTableReader sSTableReader = this;
        synchronized (sSTableReader) {
            openedFiles.put(filename, this);
        }
    }

    private SSTableReader(String filename, IPartitioner partitioner) {
        super(filename, partitioner);
    }

    public List<SSTable.KeyPosition> getIndexPositions() {
        return this.indexPositions;
    }

    private void loadBloomFilter() throws IOException {
        DataInputStream stream = new DataInputStream(new FileInputStream(this.filterFilename()));
        this.bf = BloomFilter.serializer().deserialize(stream);
    }

    private void loadIndexFile() throws IOException {
        long indexPosition;
        BufferedRandomAccessFile input = new BufferedRandomAccessFile(this.indexFilename(), "r");
        this.indexPositions = new ArrayList();
        int i = 0;
        long indexSize = input.length();
        while ((indexPosition = input.getFilePointer()) != indexSize) {
            String decoratedKey = input.readUTF();
            input.readLong();
            if (i++ % 128 != 0) continue;
            this.indexPositions.add(new SSTable.KeyPosition(decoratedKey, indexPosition));
        }
    }

    private long getIndexScanPosition(String decoratedKey, IPartitioner partitioner) {
        assert (this.indexPositions != null && this.indexPositions.size() > 0);
        int index = Collections.binarySearch(this.indexPositions, new SSTable.KeyPosition(decoratedKey, -1L));
        if (index < 0) {
            int greaterThan = (index + 1) * -1;
            if (greaterThan == 0) {
                return -1L;
            }
            return ((SSTable.KeyPosition)this.indexPositions.get((int)(greaterThan - 1))).position;
        }
        return ((SSTable.KeyPosition)this.indexPositions.get((int)index)).position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPosition(String decoratedKey) throws IOException {
        if (!this.bf.isPresent(decoratedKey)) {
            return -1L;
        }
        long start = this.getIndexScanPosition(decoratedKey, this.partitioner);
        if (start < 0L) {
            return -1L;
        }
        BufferedRandomAccessFile input = new BufferedRandomAccessFile(SSTableReader.indexFilename(this.path), "r");
        input.seek(start);
        int i = 0;
        try {
            do {
                String indexDecoratedKey;
                try {
                    indexDecoratedKey = input.readUTF();
                }
                catch (EOFException e) {
                    long l = -1L;
                    input.close();
                    return l;
                }
                long position = input.readLong();
                int v = this.partitioner.getDecoratedKeyComparator().compare(indexDecoratedKey, decoratedKey);
                if (v == 0) {
                    long l = position;
                    return l;
                }
                if (v <= 0) continue;
                long l = -1L;
                return l;
            } while (++i < 128);
        }
        finally {
            input.close();
        }
        return -1L;
    }

    public long getNearestPosition(String decoratedKey) throws IOException {
        long start = this.getIndexScanPosition(decoratedKey, this.partitioner);
        if (start < 0L) {
            return 0L;
        }
        BufferedRandomAccessFile input = new BufferedRandomAccessFile(SSTableReader.indexFilename(this.path), "r");
        input.seek(start);
        try {
            while (true) {
                String indexDecoratedKey;
                try {
                    indexDecoratedKey = input.readUTF();
                }
                catch (EOFException e) {
                    long l = -1L;
                    input.close();
                    return l;
                }
                long position = input.readLong();
                int v = this.partitioner.getDecoratedKeyComparator().compare(indexDecoratedKey, decoratedKey);
                if (v < 0) continue;
                long l = position;
                return l;
            }
        }
        finally {
            input.close();
        }
    }

    public void delete() throws IOException {
        FileUtils.deleteWithConfirm(new File(this.path));
        FileUtils.deleteWithConfirm(new File(SSTableReader.indexFilename(this.path)));
        FileUtils.deleteWithConfirm(new File(SSTableReader.filterFilename(this.path)));
        openedFiles.remove(this.path);
    }

    public void forceBloomFilterFailures() {
        this.bf = BloomFilter.alwaysMatchingBloomFilter();
    }

    static void reopenUnsafe() throws IOException {
        ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(openedFiles.values());
        openedFiles.clear();
        for (SSTableReader sstable : sstables) {
            SSTableReader.open(sstable.path, sstable.partitioner);
        }
    }

    public IPartitioner getPartitioner() {
        return this.partitioner;
    }

    public FileStruct getFileStruct() throws IOException {
        return new FileStruct(this);
    }

    public String getTableName() {
        return SSTableReader.parseTableName(this.path);
    }

    public AbstractType getColumnComparator() {
        return DatabaseDescriptor.getComparator(this.getTableName(), this.getColumnFamilyName());
    }

    public ColumnFamily makeColumnFamily() {
        return ColumnFamily.create(this.getTableName(), this.getColumnFamilyName());
    }
}

