/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io;

import java.io.File;
import java.util.List;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.commons.lang.StringUtils;

public abstract class SSTable {
    protected String path;
    protected IPartitioner partitioner;
    protected BloomFilter bf;
    protected List<KeyPosition> indexPositions;
    protected String columnFamilyName;
    public static final int INDEX_INTERVAL = 128;
    public static final String TEMPFILE_MARKER = "tmp";

    public SSTable(String filename, IPartitioner partitioner) {
        assert (filename.endsWith("-Data.db"));
        this.columnFamilyName = new File(filename).getName().split("-")[0];
        this.path = filename;
        this.partitioner = partitioner;
    }

    protected static String indexFilename(String dataFile) {
        Object[] parts = dataFile.split("-");
        parts[parts.length - 1] = "Index.db";
        return StringUtils.join((Object[])parts, (String)"-");
    }

    public String indexFilename() {
        return SSTable.indexFilename(this.path);
    }

    protected static String filterFilename(String dataFile) {
        Object[] parts = dataFile.split("-");
        parts[parts.length - 1] = "Filter.db";
        return StringUtils.join((Object[])parts, (String)"-");
    }

    public String filterFilename() {
        return SSTable.filterFilename(this.path);
    }

    public String getFilename() {
        return this.path;
    }

    public String getColumnFamilyName() {
        return this.columnFamilyName;
    }

    public static String parseTableName(String filename) {
        return new File(filename).getParentFile().getName();
    }

    class KeyPosition
    implements Comparable<KeyPosition> {
        public final String key;
        public final long position;

        public KeyPosition(String key, long position) {
            this.key = key;
            this.position = position;
        }

        @Override
        public int compareTo(KeyPosition kp) {
            return SSTable.this.partitioner.getDecoratedKeyComparator().compare(this.key, kp.key);
        }

        public String toString() {
            return this.key + ":" + this.position;
        }
    }
}

